/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.apigateway.ApiGatewayClient;
import software.amazon.awssdk.services.apigateway.model.GetUsagePlansRequest;
import software.amazon.awssdk.services.apigateway.model.GetUsagePlansResponse;
import software.amazon.awssdk.services.apigateway.model.UsagePlan;

public class GetUsagePlansIterable
implements SdkIterable<GetUsagePlansResponse> {
    private final ApiGatewayClient client;
    private final GetUsagePlansRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetUsagePlansIterable(ApiGatewayClient client, GetUsagePlansRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetUsagePlansResponseFetcher();
    }

    public Iterator<GetUsagePlansResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<UsagePlan> items() {
        Function<GetUsagePlansResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetUsagePlansResponseFetcher
    implements SyncPageFetcher<GetUsagePlansResponse> {
        private GetUsagePlansResponseFetcher() {
        }

        public boolean hasNextPage(GetUsagePlansResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.position());
        }

        public GetUsagePlansResponse nextPage(GetUsagePlansResponse previousPage) {
            if (previousPage == null) {
                return GetUsagePlansIterable.this.client.getUsagePlans(GetUsagePlansIterable.this.firstRequest);
            }
            return GetUsagePlansIterable.this.client.getUsagePlans((GetUsagePlansRequest)((Object)GetUsagePlansIterable.this.firstRequest.toBuilder().position(previousPage.position()).build()));
        }
    }
}

