/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Deletes an existing <a>VpcLink</a> of a specified identifier.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteVpcLinkRequest extends ApiGatewayRequest implements
        ToCopyableBuilder<DeleteVpcLinkRequest.Builder, DeleteVpcLinkRequest> {
    private static final SdkField<String> VPC_LINK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vpcLinkId").getter(getter(DeleteVpcLinkRequest::vpcLinkId)).setter(setter(Builder::vpcLinkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("vpclink_id").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_LINK_ID_FIELD));

    private final String vpcLinkId;

    private DeleteVpcLinkRequest(BuilderImpl builder) {
        super(builder);
        this.vpcLinkId = builder.vpcLinkId;
    }

    /**
     * <p>
     * [Required] The identifier of the <a>VpcLink</a>. It is used in an <a>Integration</a> to reference this
     * <a>VpcLink</a>.
     * </p>
     * 
     * @return [Required] The identifier of the <a>VpcLink</a>. It is used in an <a>Integration</a> to reference this
     *         <a>VpcLink</a>.
     */
    public final String vpcLinkId() {
        return vpcLinkId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vpcLinkId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteVpcLinkRequest)) {
            return false;
        }
        DeleteVpcLinkRequest other = (DeleteVpcLinkRequest) obj;
        return Objects.equals(vpcLinkId(), other.vpcLinkId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteVpcLinkRequest").add("VpcLinkId", vpcLinkId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "vpcLinkId":
            return Optional.ofNullable(clazz.cast(vpcLinkId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteVpcLinkRequest, T> g) {
        return obj -> g.apply((DeleteVpcLinkRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteVpcLinkRequest> {
        /**
         * <p>
         * [Required] The identifier of the <a>VpcLink</a>. It is used in an <a>Integration</a> to reference this
         * <a>VpcLink</a>.
         * </p>
         * 
         * @param vpcLinkId
         *        [Required] The identifier of the <a>VpcLink</a>. It is used in an <a>Integration</a> to reference this
         *        <a>VpcLink</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcLinkId(String vpcLinkId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayRequest.BuilderImpl implements Builder {
        private String vpcLinkId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteVpcLinkRequest model) {
            super(model);
            vpcLinkId(model.vpcLinkId);
        }

        public final String getVpcLinkId() {
            return vpcLinkId;
        }

        @Override
        public final Builder vpcLinkId(String vpcLinkId) {
            this.vpcLinkId = vpcLinkId;
            return this;
        }

        public final void setVpcLinkId(String vpcLinkId) {
            this.vpcLinkId = vpcLinkId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteVpcLinkRequest build() {
            return new DeleteVpcLinkRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
