/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayResponse;
import software.amazon.awssdk.services.apigateway.model.MapOfMethodCopier;
import software.amazon.awssdk.services.apigateway.model.Method;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetResourceResponse
extends ApiGatewayResponse
implements ToCopyableBuilder<Builder, GetResourceResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(GetResourceResponse.getter(GetResourceResponse::id)).setter(GetResourceResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> PARENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("parentId").getter(GetResourceResponse.getter(GetResourceResponse::parentId)).setter(GetResourceResponse.setter(Builder::parentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentId").build()}).build();
    private static final SdkField<String> PATH_PART_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pathPart").getter(GetResourceResponse.getter(GetResourceResponse::pathPart)).setter(GetResourceResponse.setter(Builder::pathPart)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pathPart").build()}).build();
    private static final SdkField<String> PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("path").getter(GetResourceResponse.getter(GetResourceResponse::path)).setter(GetResourceResponse.setter(Builder::path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("path").build()}).build();
    private static final SdkField<Map<String, Method>> RESOURCE_METHODS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("resourceMethods").getter(GetResourceResponse.getter(GetResourceResponse::resourceMethods)).setter(GetResourceResponse.setter(Builder::resourceMethods)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceMethods").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Method::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, PARENT_ID_FIELD, PATH_PART_FIELD, PATH_FIELD, RESOURCE_METHODS_FIELD));
    private final String id;
    private final String parentId;
    private final String pathPart;
    private final String path;
    private final Map<String, Method> resourceMethods;

    private GetResourceResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.parentId = builder.parentId;
        this.pathPart = builder.pathPart;
        this.path = builder.path;
        this.resourceMethods = builder.resourceMethods;
    }

    public String id() {
        return this.id;
    }

    public String parentId() {
        return this.parentId;
    }

    public String pathPart() {
        return this.pathPart;
    }

    public String path() {
        return this.path;
    }

    public boolean hasResourceMethods() {
        return this.resourceMethods != null && !(this.resourceMethods instanceof SdkAutoConstructMap);
    }

    public Map<String, Method> resourceMethods() {
        return this.resourceMethods;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.pathPart());
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceMethods());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceResponse)) {
            return false;
        }
        GetResourceResponse other = (GetResourceResponse)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.parentId(), other.parentId()) && Objects.equals(this.pathPart(), other.pathPart()) && Objects.equals(this.path(), other.path()) && Objects.equals(this.resourceMethods(), other.resourceMethods());
    }

    public String toString() {
        return ToString.builder((String)"GetResourceResponse").add("Id", (Object)this.id()).add("ParentId", (Object)this.parentId()).add("PathPart", (Object)this.pathPart()).add("Path", (Object)this.path()).add("ResourceMethods", this.resourceMethods()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "parentId": {
                return Optional.ofNullable(clazz.cast(this.parentId()));
            }
            case "pathPart": {
                return Optional.ofNullable(clazz.cast(this.pathPart()));
            }
            case "path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "resourceMethods": {
                return Optional.ofNullable(clazz.cast(this.resourceMethods()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetResourceResponse, T> g) {
        return obj -> g.apply((GetResourceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayResponse.BuilderImpl
    implements Builder {
        private String id;
        private String parentId;
        private String pathPart;
        private String path;
        private Map<String, Method> resourceMethods = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceResponse model) {
            super(model);
            this.id(model.id);
            this.parentId(model.parentId);
            this.pathPart(model.pathPart);
            this.path(model.path);
            this.resourceMethods(model.resourceMethods);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getParentId() {
            return this.parentId;
        }

        @Override
        public final Builder parentId(String parentId) {
            this.parentId = parentId;
            return this;
        }

        public final void setParentId(String parentId) {
            this.parentId = parentId;
        }

        public final String getPathPart() {
            return this.pathPart;
        }

        @Override
        public final Builder pathPart(String pathPart) {
            this.pathPart = pathPart;
            return this;
        }

        public final void setPathPart(String pathPart) {
            this.pathPart = pathPart;
        }

        public final String getPath() {
            return this.path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final Map<String, Method.Builder> getResourceMethods() {
            return this.resourceMethods != null ? CollectionUtils.mapValues(this.resourceMethods, Method::toBuilder) : null;
        }

        @Override
        public final Builder resourceMethods(Map<String, Method> resourceMethods) {
            this.resourceMethods = MapOfMethodCopier.copy(resourceMethods);
            return this;
        }

        public final void setResourceMethods(Map<String, Method.BuilderImpl> resourceMethods) {
            this.resourceMethods = MapOfMethodCopier.copyFromBuilder(resourceMethods);
        }

        @Override
        public GetResourceResponse build() {
            return new GetResourceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApiGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetResourceResponse> {
        public Builder id(String var1);

        public Builder parentId(String var1);

        public Builder pathPart(String var1);

        public Builder path(String var1);

        public Builder resourceMethods(Map<String, Method> var1);
    }
}

