/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetApiKeyRequest
extends ApiGatewayRequest
implements ToCopyableBuilder<Builder, GetApiKeyRequest> {
    private static final SdkField<String> API_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetApiKeyRequest.getter(GetApiKeyRequest::apiKey)).setter(GetApiKeyRequest.setter(Builder::apiKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("api_Key").build()}).build();
    private static final SdkField<Boolean> INCLUDE_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(GetApiKeyRequest.getter(GetApiKeyRequest::includeValue)).setter(GetApiKeyRequest.setter(Builder::includeValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("includeValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_KEY_FIELD, INCLUDE_VALUE_FIELD));
    private final String apiKey;
    private final Boolean includeValue;

    private GetApiKeyRequest(BuilderImpl builder) {
        super(builder);
        this.apiKey = builder.apiKey;
        this.includeValue = builder.includeValue;
    }

    public String apiKey() {
        return this.apiKey;
    }

    public Boolean includeValue() {
        return this.includeValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.apiKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeValue());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetApiKeyRequest)) {
            return false;
        }
        GetApiKeyRequest other = (GetApiKeyRequest)((Object)obj);
        return Objects.equals(this.apiKey(), other.apiKey()) && Objects.equals(this.includeValue(), other.includeValue());
    }

    public String toString() {
        return ToString.builder((String)"GetApiKeyRequest").add("ApiKey", (Object)this.apiKey()).add("IncludeValue", (Object)this.includeValue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "apiKey": {
                return Optional.ofNullable(clazz.cast(this.apiKey()));
            }
            case "includeValue": {
                return Optional.ofNullable(clazz.cast(this.includeValue()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetApiKeyRequest, T> g) {
        return obj -> g.apply((GetApiKeyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayRequest.BuilderImpl
    implements Builder {
        private String apiKey;
        private Boolean includeValue;

        private BuilderImpl() {
        }

        private BuilderImpl(GetApiKeyRequest model) {
            super(model);
            this.apiKey(model.apiKey);
            this.includeValue(model.includeValue);
        }

        public final String getApiKey() {
            return this.apiKey;
        }

        @Override
        public final Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public final void setApiKey(String apiKey) {
            this.apiKey = apiKey;
        }

        public final Boolean getIncludeValue() {
            return this.includeValue;
        }

        @Override
        public final Builder includeValue(Boolean includeValue) {
            this.includeValue = includeValue;
            return this;
        }

        public final void setIncludeValue(Boolean includeValue) {
            this.includeValue = includeValue;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetApiKeyRequest build() {
            return new GetApiKeyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApiGatewayRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetApiKeyRequest> {
        public Builder apiKey(String var1);

        public Builder includeValue(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

