/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.apigateway.model.AccessLogSettings;
import software.amazon.awssdk.services.apigateway.model.CacheClusterStatus;
import software.amazon.awssdk.services.apigateway.model.CanarySettings;
import software.amazon.awssdk.services.apigateway.model.MapOfMethodSettingsCopier;
import software.amazon.awssdk.services.apigateway.model.MapOfStringToStringCopier;
import software.amazon.awssdk.services.apigateway.model.MethodSetting;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Stage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Stage> {
    private static final SdkField<String> DEPLOYMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Stage.getter(Stage::deploymentId)).setter(Stage.setter(Builder::deploymentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentId").build()}).build();
    private static final SdkField<String> CLIENT_CERTIFICATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Stage.getter(Stage::clientCertificateId)).setter(Stage.setter(Builder::clientCertificateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientCertificateId").build()}).build();
    private static final SdkField<String> STAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Stage.getter(Stage::stageName)).setter(Stage.setter(Builder::stageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stageName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Stage.getter(Stage::description)).setter(Stage.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Boolean> CACHE_CLUSTER_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(Stage.getter(Stage::cacheClusterEnabled)).setter(Stage.setter(Builder::cacheClusterEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheClusterEnabled").build()}).build();
    private static final SdkField<String> CACHE_CLUSTER_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Stage.getter(Stage::cacheClusterSize)).setter(Stage.setter(Builder::cacheClusterSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheClusterSize").build()}).build();
    private static final SdkField<String> CACHE_CLUSTER_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Stage.getter(Stage::cacheClusterStatusAsString)).setter(Stage.setter(Builder::cacheClusterStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheClusterStatus").build()}).build();
    private static final SdkField<Map<String, MethodSetting>> METHOD_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(Stage.getter(Stage::methodSettings)).setter(Stage.setter(Builder::methodSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("methodSettings").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MethodSetting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(Stage.getter(Stage::variables)).setter(Stage.setter(Builder::variables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variables").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> DOCUMENTATION_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Stage.getter(Stage::documentationVersion)).setter(Stage.setter(Builder::documentationVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentationVersion").build()}).build();
    private static final SdkField<AccessLogSettings> ACCESS_LOG_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Stage.getter(Stage::accessLogSettings)).setter(Stage.setter(Builder::accessLogSettings)).constructor(AccessLogSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessLogSettings").build()}).build();
    private static final SdkField<CanarySettings> CANARY_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Stage.getter(Stage::canarySettings)).setter(Stage.setter(Builder::canarySettings)).constructor(CanarySettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("canarySettings").build()}).build();
    private static final SdkField<Boolean> TRACING_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(Stage.getter(Stage::tracingEnabled)).setter(Stage.setter(Builder::tracingEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tracingEnabled").build()}).build();
    private static final SdkField<String> WEB_ACL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Stage.getter(Stage::webAclArn)).setter(Stage.setter(Builder::webAclArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("webAclArn").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(Stage.getter(Stage::tags)).setter(Stage.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Stage.getter(Stage::createdDate)).setter(Stage.setter(Builder::createdDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Stage.getter(Stage::lastUpdatedDate)).setter(Stage.setter(Builder::lastUpdatedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_ID_FIELD, CLIENT_CERTIFICATE_ID_FIELD, STAGE_NAME_FIELD, DESCRIPTION_FIELD, CACHE_CLUSTER_ENABLED_FIELD, CACHE_CLUSTER_SIZE_FIELD, CACHE_CLUSTER_STATUS_FIELD, METHOD_SETTINGS_FIELD, VARIABLES_FIELD, DOCUMENTATION_VERSION_FIELD, ACCESS_LOG_SETTINGS_FIELD, CANARY_SETTINGS_FIELD, TRACING_ENABLED_FIELD, WEB_ACL_ARN_FIELD, TAGS_FIELD, CREATED_DATE_FIELD, LAST_UPDATED_DATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String deploymentId;
    private final String clientCertificateId;
    private final String stageName;
    private final String description;
    private final Boolean cacheClusterEnabled;
    private final String cacheClusterSize;
    private final String cacheClusterStatus;
    private final Map<String, MethodSetting> methodSettings;
    private final Map<String, String> variables;
    private final String documentationVersion;
    private final AccessLogSettings accessLogSettings;
    private final CanarySettings canarySettings;
    private final Boolean tracingEnabled;
    private final String webAclArn;
    private final Map<String, String> tags;
    private final Instant createdDate;
    private final Instant lastUpdatedDate;

    private Stage(BuilderImpl builder) {
        this.deploymentId = builder.deploymentId;
        this.clientCertificateId = builder.clientCertificateId;
        this.stageName = builder.stageName;
        this.description = builder.description;
        this.cacheClusterEnabled = builder.cacheClusterEnabled;
        this.cacheClusterSize = builder.cacheClusterSize;
        this.cacheClusterStatus = builder.cacheClusterStatus;
        this.methodSettings = builder.methodSettings;
        this.variables = builder.variables;
        this.documentationVersion = builder.documentationVersion;
        this.accessLogSettings = builder.accessLogSettings;
        this.canarySettings = builder.canarySettings;
        this.tracingEnabled = builder.tracingEnabled;
        this.webAclArn = builder.webAclArn;
        this.tags = builder.tags;
        this.createdDate = builder.createdDate;
        this.lastUpdatedDate = builder.lastUpdatedDate;
    }

    public String deploymentId() {
        return this.deploymentId;
    }

    public String clientCertificateId() {
        return this.clientCertificateId;
    }

    public String stageName() {
        return this.stageName;
    }

    public String description() {
        return this.description;
    }

    public Boolean cacheClusterEnabled() {
        return this.cacheClusterEnabled;
    }

    public String cacheClusterSize() {
        return this.cacheClusterSize;
    }

    public CacheClusterStatus cacheClusterStatus() {
        return CacheClusterStatus.fromValue(this.cacheClusterStatus);
    }

    public String cacheClusterStatusAsString() {
        return this.cacheClusterStatus;
    }

    public boolean hasMethodSettings() {
        return this.methodSettings != null && !(this.methodSettings instanceof SdkAutoConstructMap);
    }

    public Map<String, MethodSetting> methodSettings() {
        return this.methodSettings;
    }

    public boolean hasVariables() {
        return this.variables != null && !(this.variables instanceof SdkAutoConstructMap);
    }

    public Map<String, String> variables() {
        return this.variables;
    }

    public String documentationVersion() {
        return this.documentationVersion;
    }

    public AccessLogSettings accessLogSettings() {
        return this.accessLogSettings;
    }

    public CanarySettings canarySettings() {
        return this.canarySettings;
    }

    public Boolean tracingEnabled() {
        return this.tracingEnabled;
    }

    public String webAclArn() {
        return this.webAclArn;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public Instant createdDate() {
        return this.createdDate;
    }

    public Instant lastUpdatedDate() {
        return this.lastUpdatedDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientCertificateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheClusterEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheClusterSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheClusterStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.methodSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.variables());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentationVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessLogSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.canarySettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.tracingEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.webAclArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Stage)) {
            return false;
        }
        Stage other = (Stage)obj;
        return Objects.equals(this.deploymentId(), other.deploymentId()) && Objects.equals(this.clientCertificateId(), other.clientCertificateId()) && Objects.equals(this.stageName(), other.stageName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.cacheClusterEnabled(), other.cacheClusterEnabled()) && Objects.equals(this.cacheClusterSize(), other.cacheClusterSize()) && Objects.equals(this.cacheClusterStatusAsString(), other.cacheClusterStatusAsString()) && Objects.equals(this.methodSettings(), other.methodSettings()) && Objects.equals(this.variables(), other.variables()) && Objects.equals(this.documentationVersion(), other.documentationVersion()) && Objects.equals(this.accessLogSettings(), other.accessLogSettings()) && Objects.equals(this.canarySettings(), other.canarySettings()) && Objects.equals(this.tracingEnabled(), other.tracingEnabled()) && Objects.equals(this.webAclArn(), other.webAclArn()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.lastUpdatedDate(), other.lastUpdatedDate());
    }

    public String toString() {
        return ToString.builder((String)"Stage").add("DeploymentId", (Object)this.deploymentId()).add("ClientCertificateId", (Object)this.clientCertificateId()).add("StageName", (Object)this.stageName()).add("Description", (Object)this.description()).add("CacheClusterEnabled", (Object)this.cacheClusterEnabled()).add("CacheClusterSize", (Object)this.cacheClusterSize()).add("CacheClusterStatus", (Object)this.cacheClusterStatusAsString()).add("MethodSettings", this.methodSettings()).add("Variables", this.variables()).add("DocumentationVersion", (Object)this.documentationVersion()).add("AccessLogSettings", (Object)this.accessLogSettings()).add("CanarySettings", (Object)this.canarySettings()).add("TracingEnabled", (Object)this.tracingEnabled()).add("WebAclArn", (Object)this.webAclArn()).add("Tags", this.tags()).add("CreatedDate", (Object)this.createdDate()).add("LastUpdatedDate", (Object)this.lastUpdatedDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deploymentId": {
                return Optional.ofNullable(clazz.cast(this.deploymentId()));
            }
            case "clientCertificateId": {
                return Optional.ofNullable(clazz.cast(this.clientCertificateId()));
            }
            case "stageName": {
                return Optional.ofNullable(clazz.cast(this.stageName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "cacheClusterEnabled": {
                return Optional.ofNullable(clazz.cast(this.cacheClusterEnabled()));
            }
            case "cacheClusterSize": {
                return Optional.ofNullable(clazz.cast(this.cacheClusterSize()));
            }
            case "cacheClusterStatus": {
                return Optional.ofNullable(clazz.cast(this.cacheClusterStatusAsString()));
            }
            case "methodSettings": {
                return Optional.ofNullable(clazz.cast(this.methodSettings()));
            }
            case "variables": {
                return Optional.ofNullable(clazz.cast(this.variables()));
            }
            case "documentationVersion": {
                return Optional.ofNullable(clazz.cast(this.documentationVersion()));
            }
            case "accessLogSettings": {
                return Optional.ofNullable(clazz.cast(this.accessLogSettings()));
            }
            case "canarySettings": {
                return Optional.ofNullable(clazz.cast(this.canarySettings()));
            }
            case "tracingEnabled": {
                return Optional.ofNullable(clazz.cast(this.tracingEnabled()));
            }
            case "webAclArn": {
                return Optional.ofNullable(clazz.cast(this.webAclArn()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "createdDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
            case "lastUpdatedDate": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Stage, T> g) {
        return obj -> g.apply((Stage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String deploymentId;
        private String clientCertificateId;
        private String stageName;
        private String description;
        private Boolean cacheClusterEnabled;
        private String cacheClusterSize;
        private String cacheClusterStatus;
        private Map<String, MethodSetting> methodSettings = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> variables = DefaultSdkAutoConstructMap.getInstance();
        private String documentationVersion;
        private AccessLogSettings accessLogSettings;
        private CanarySettings canarySettings;
        private Boolean tracingEnabled;
        private String webAclArn;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Instant createdDate;
        private Instant lastUpdatedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(Stage model) {
            this.deploymentId(model.deploymentId);
            this.clientCertificateId(model.clientCertificateId);
            this.stageName(model.stageName);
            this.description(model.description);
            this.cacheClusterEnabled(model.cacheClusterEnabled);
            this.cacheClusterSize(model.cacheClusterSize);
            this.cacheClusterStatus(model.cacheClusterStatus);
            this.methodSettings(model.methodSettings);
            this.variables(model.variables);
            this.documentationVersion(model.documentationVersion);
            this.accessLogSettings(model.accessLogSettings);
            this.canarySettings(model.canarySettings);
            this.tracingEnabled(model.tracingEnabled);
            this.webAclArn(model.webAclArn);
            this.tags(model.tags);
            this.createdDate(model.createdDate);
            this.lastUpdatedDate(model.lastUpdatedDate);
        }

        public final String getDeploymentId() {
            return this.deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        public final String getClientCertificateId() {
            return this.clientCertificateId;
        }

        @Override
        public final Builder clientCertificateId(String clientCertificateId) {
            this.clientCertificateId = clientCertificateId;
            return this;
        }

        public final void setClientCertificateId(String clientCertificateId) {
            this.clientCertificateId = clientCertificateId;
        }

        public final String getStageName() {
            return this.stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Boolean getCacheClusterEnabled() {
            return this.cacheClusterEnabled;
        }

        @Override
        public final Builder cacheClusterEnabled(Boolean cacheClusterEnabled) {
            this.cacheClusterEnabled = cacheClusterEnabled;
            return this;
        }

        public final void setCacheClusterEnabled(Boolean cacheClusterEnabled) {
            this.cacheClusterEnabled = cacheClusterEnabled;
        }

        public final String getCacheClusterSize() {
            return this.cacheClusterSize;
        }

        @Override
        public final Builder cacheClusterSize(String cacheClusterSize) {
            this.cacheClusterSize = cacheClusterSize;
            return this;
        }

        public final void setCacheClusterSize(String cacheClusterSize) {
            this.cacheClusterSize = cacheClusterSize;
        }

        public final String getCacheClusterStatusAsString() {
            return this.cacheClusterStatus;
        }

        @Override
        public final Builder cacheClusterStatus(String cacheClusterStatus) {
            this.cacheClusterStatus = cacheClusterStatus;
            return this;
        }

        @Override
        public final Builder cacheClusterStatus(CacheClusterStatus cacheClusterStatus) {
            this.cacheClusterStatus(cacheClusterStatus == null ? null : cacheClusterStatus.toString());
            return this;
        }

        public final void setCacheClusterStatus(String cacheClusterStatus) {
            this.cacheClusterStatus = cacheClusterStatus;
        }

        public final Map<String, MethodSetting.Builder> getMethodSettings() {
            return this.methodSettings != null ? CollectionUtils.mapValues(this.methodSettings, MethodSetting::toBuilder) : null;
        }

        @Override
        public final Builder methodSettings(Map<String, MethodSetting> methodSettings) {
            this.methodSettings = MapOfMethodSettingsCopier.copy(methodSettings);
            return this;
        }

        public final void setMethodSettings(Map<String, MethodSetting.BuilderImpl> methodSettings) {
            this.methodSettings = MapOfMethodSettingsCopier.copyFromBuilder(methodSettings);
        }

        public final Map<String, String> getVariables() {
            return this.variables;
        }

        @Override
        public final Builder variables(Map<String, String> variables) {
            this.variables = MapOfStringToStringCopier.copy(variables);
            return this;
        }

        public final void setVariables(Map<String, String> variables) {
            this.variables = MapOfStringToStringCopier.copy(variables);
        }

        public final String getDocumentationVersion() {
            return this.documentationVersion;
        }

        @Override
        public final Builder documentationVersion(String documentationVersion) {
            this.documentationVersion = documentationVersion;
            return this;
        }

        public final void setDocumentationVersion(String documentationVersion) {
            this.documentationVersion = documentationVersion;
        }

        public final AccessLogSettings.Builder getAccessLogSettings() {
            return this.accessLogSettings != null ? this.accessLogSettings.toBuilder() : null;
        }

        @Override
        public final Builder accessLogSettings(AccessLogSettings accessLogSettings) {
            this.accessLogSettings = accessLogSettings;
            return this;
        }

        public final void setAccessLogSettings(AccessLogSettings.BuilderImpl accessLogSettings) {
            this.accessLogSettings = accessLogSettings != null ? accessLogSettings.build() : null;
        }

        public final CanarySettings.Builder getCanarySettings() {
            return this.canarySettings != null ? this.canarySettings.toBuilder() : null;
        }

        @Override
        public final Builder canarySettings(CanarySettings canarySettings) {
            this.canarySettings = canarySettings;
            return this;
        }

        public final void setCanarySettings(CanarySettings.BuilderImpl canarySettings) {
            this.canarySettings = canarySettings != null ? canarySettings.build() : null;
        }

        public final Boolean getTracingEnabled() {
            return this.tracingEnabled;
        }

        @Override
        public final Builder tracingEnabled(Boolean tracingEnabled) {
            this.tracingEnabled = tracingEnabled;
            return this;
        }

        public final void setTracingEnabled(Boolean tracingEnabled) {
            this.tracingEnabled = tracingEnabled;
        }

        public final String getWebAclArn() {
            return this.webAclArn;
        }

        @Override
        public final Builder webAclArn(String webAclArn) {
            this.webAclArn = webAclArn;
            return this;
        }

        public final void setWebAclArn(String webAclArn) {
            this.webAclArn = webAclArn;
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = MapOfStringToStringCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = MapOfStringToStringCopier.copy(tags);
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public final Instant getLastUpdatedDate() {
            return this.lastUpdatedDate;
        }

        @Override
        public final Builder lastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
            return this;
        }

        public final void setLastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
        }

        public Stage build() {
            return new Stage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Stage> {
        public Builder deploymentId(String var1);

        public Builder clientCertificateId(String var1);

        public Builder stageName(String var1);

        public Builder description(String var1);

        public Builder cacheClusterEnabled(Boolean var1);

        public Builder cacheClusterSize(String var1);

        public Builder cacheClusterStatus(String var1);

        public Builder cacheClusterStatus(CacheClusterStatus var1);

        public Builder methodSettings(Map<String, MethodSetting> var1);

        public Builder variables(Map<String, String> var1);

        public Builder documentationVersion(String var1);

        public Builder accessLogSettings(AccessLogSettings var1);

        default public Builder accessLogSettings(Consumer<AccessLogSettings.Builder> accessLogSettings) {
            return this.accessLogSettings((AccessLogSettings)((AccessLogSettings.Builder)AccessLogSettings.builder().applyMutation(accessLogSettings)).build());
        }

        public Builder canarySettings(CanarySettings var1);

        default public Builder canarySettings(Consumer<CanarySettings.Builder> canarySettings) {
            return this.canarySettings((CanarySettings)((CanarySettings.Builder)CanarySettings.builder().applyMutation(canarySettings)).build());
        }

        public Builder tracingEnabled(Boolean var1);

        public Builder webAclArn(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder createdDate(Instant var1);

        public Builder lastUpdatedDate(Instant var1);
    }
}

