/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.apigateway.ApiGatewayAsyncClient;
import software.amazon.awssdk.services.apigateway.model.GetUsagePlansRequest;
import software.amazon.awssdk.services.apigateway.model.GetUsagePlansResponse;
import software.amazon.awssdk.services.apigateway.model.UsagePlan;

public class GetUsagePlansPublisher
implements SdkPublisher<GetUsagePlansResponse> {
    private final ApiGatewayAsyncClient client;
    private final GetUsagePlansRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetUsagePlansPublisher(ApiGatewayAsyncClient client, GetUsagePlansRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetUsagePlansPublisher(ApiGatewayAsyncClient client, GetUsagePlansRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetUsagePlansResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetUsagePlansResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<UsagePlan> items() {
        Function<GetUsagePlansResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetUsagePlansResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final GetUsagePlansPublisher resume(GetUsagePlansResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetUsagePlansPublisher(this.client, (GetUsagePlansRequest)((Object)this.firstRequest.toBuilder().position(lastSuccessfulPage.position()).build()));
        }
        return new GetUsagePlansPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super GetUsagePlansResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class GetUsagePlansResponseFetcher
    implements AsyncPageFetcher<GetUsagePlansResponse> {
        private GetUsagePlansResponseFetcher() {
        }

        public boolean hasNextPage(GetUsagePlansResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.position());
        }

        public CompletableFuture<GetUsagePlansResponse> nextPage(GetUsagePlansResponse previousPage) {
            if (previousPage == null) {
                return GetUsagePlansPublisher.this.client.getUsagePlans(GetUsagePlansPublisher.this.firstRequest);
            }
            return GetUsagePlansPublisher.this.client.getUsagePlans((GetUsagePlansRequest)((Object)GetUsagePlansPublisher.this.firstRequest.toBuilder().position(previousPage.position()).build()));
        }
    }
}

