/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayRequest;
import software.amazon.awssdk.services.apigateway.model.DocumentationPartType;
import software.amazon.awssdk.services.apigateway.model.LocationStatusType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDocumentationPartsRequest
extends ApiGatewayRequest
implements ToCopyableBuilder<Builder, GetDocumentationPartsRequest> {
    private static final SdkField<String> REST_API_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetDocumentationPartsRequest.getter(GetDocumentationPartsRequest::restApiId)).setter(GetDocumentationPartsRequest.setter(Builder::restApiId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("restapi_id").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetDocumentationPartsRequest.getter(GetDocumentationPartsRequest::typeAsString)).setter(GetDocumentationPartsRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("type").build()}).build();
    private static final SdkField<String> NAME_QUERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetDocumentationPartsRequest.getter(GetDocumentationPartsRequest::nameQuery)).setter(GetDocumentationPartsRequest.setter(Builder::nameQuery)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("name").build()}).build();
    private static final SdkField<String> PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetDocumentationPartsRequest.getter(GetDocumentationPartsRequest::path)).setter(GetDocumentationPartsRequest.setter(Builder::path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("path").build()}).build();
    private static final SdkField<String> POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetDocumentationPartsRequest.getter(GetDocumentationPartsRequest::position)).setter(GetDocumentationPartsRequest.setter(Builder::position)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("position").build()}).build();
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(GetDocumentationPartsRequest.getter(GetDocumentationPartsRequest::limit)).setter(GetDocumentationPartsRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("limit").build()}).build();
    private static final SdkField<String> LOCATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetDocumentationPartsRequest.getter(GetDocumentationPartsRequest::locationStatusAsString)).setter(GetDocumentationPartsRequest.setter(Builder::locationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("locationStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REST_API_ID_FIELD, TYPE_FIELD, NAME_QUERY_FIELD, PATH_FIELD, POSITION_FIELD, LIMIT_FIELD, LOCATION_STATUS_FIELD));
    private final String restApiId;
    private final String type;
    private final String nameQuery;
    private final String path;
    private final String position;
    private final Integer limit;
    private final String locationStatus;

    private GetDocumentationPartsRequest(BuilderImpl builder) {
        super(builder);
        this.restApiId = builder.restApiId;
        this.type = builder.type;
        this.nameQuery = builder.nameQuery;
        this.path = builder.path;
        this.position = builder.position;
        this.limit = builder.limit;
        this.locationStatus = builder.locationStatus;
    }

    public String restApiId() {
        return this.restApiId;
    }

    public DocumentationPartType type() {
        return DocumentationPartType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String nameQuery() {
        return this.nameQuery;
    }

    public String path() {
        return this.path;
    }

    public String position() {
        return this.position;
    }

    public Integer limit() {
        return this.limit;
    }

    public LocationStatusType locationStatus() {
        return LocationStatusType.fromValue(this.locationStatus);
    }

    public String locationStatusAsString() {
        return this.locationStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.restApiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nameQuery());
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.position());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.locationStatusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDocumentationPartsRequest)) {
            return false;
        }
        GetDocumentationPartsRequest other = (GetDocumentationPartsRequest)((Object)obj);
        return Objects.equals(this.restApiId(), other.restApiId()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.nameQuery(), other.nameQuery()) && Objects.equals(this.path(), other.path()) && Objects.equals(this.position(), other.position()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.locationStatusAsString(), other.locationStatusAsString());
    }

    public String toString() {
        return ToString.builder((String)"GetDocumentationPartsRequest").add("RestApiId", (Object)this.restApiId()).add("Type", (Object)this.typeAsString()).add("NameQuery", (Object)this.nameQuery()).add("Path", (Object)this.path()).add("Position", (Object)this.position()).add("Limit", (Object)this.limit()).add("LocationStatus", (Object)this.locationStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "restApiId": {
                return Optional.ofNullable(clazz.cast(this.restApiId()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "nameQuery": {
                return Optional.ofNullable(clazz.cast(this.nameQuery()));
            }
            case "path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "position": {
                return Optional.ofNullable(clazz.cast(this.position()));
            }
            case "limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "locationStatus": {
                return Optional.ofNullable(clazz.cast(this.locationStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDocumentationPartsRequest, T> g) {
        return obj -> g.apply((GetDocumentationPartsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayRequest.BuilderImpl
    implements Builder {
        private String restApiId;
        private String type;
        private String nameQuery;
        private String path;
        private String position;
        private Integer limit;
        private String locationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDocumentationPartsRequest model) {
            super(model);
            this.restApiId(model.restApiId);
            this.type(model.type);
            this.nameQuery(model.nameQuery);
            this.path(model.path);
            this.position(model.position);
            this.limit(model.limit);
            this.locationStatus(model.locationStatus);
        }

        public final String getRestApiId() {
            return this.restApiId;
        }

        @Override
        public final Builder restApiId(String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        public final void setRestApiId(String restApiId) {
            this.restApiId = restApiId;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DocumentationPartType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getNameQuery() {
            return this.nameQuery;
        }

        @Override
        public final Builder nameQuery(String nameQuery) {
            this.nameQuery = nameQuery;
            return this;
        }

        public final void setNameQuery(String nameQuery) {
            this.nameQuery = nameQuery;
        }

        public final String getPath() {
            return this.path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final String getPosition() {
            return this.position;
        }

        @Override
        public final Builder position(String position) {
            this.position = position;
            return this;
        }

        public final void setPosition(String position) {
            this.position = position;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getLocationStatus() {
            return this.locationStatus;
        }

        @Override
        public final Builder locationStatus(String locationStatus) {
            this.locationStatus = locationStatus;
            return this;
        }

        @Override
        public final Builder locationStatus(LocationStatusType locationStatus) {
            this.locationStatus(locationStatus.toString());
            return this;
        }

        public final void setLocationStatus(String locationStatus) {
            this.locationStatus = locationStatus;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDocumentationPartsRequest build() {
            return new GetDocumentationPartsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApiGatewayRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDocumentationPartsRequest> {
        public Builder restApiId(String var1);

        public Builder type(String var1);

        public Builder type(DocumentationPartType var1);

        public Builder nameQuery(String var1);

        public Builder path(String var1);

        public Builder position(String var1);

        public Builder limit(Integer var1);

        public Builder locationStatus(String var1);

        public Builder locationStatus(LocationStatusType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

