/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.apache5.internal.conn;

import java.io.IOException;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.io.ConnectionEndpoint;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.io.LeaseRequest;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.apache5.internal.conn.ClientConnectionRequestFactory;

@SdkInternalApi
public final class ClientConnectionManagerFactory {
    private ClientConnectionManagerFactory() {
    }

    public static HttpClientConnectionManager wrap(HttpClientConnectionManager orig) {
        if (orig instanceof DelegatingHttpClientConnectionManager) {
            throw new IllegalArgumentException();
        }
        return new InstrumentedHttpClientConnectionManager(orig);
    }

    private static class DelegatingHttpClientConnectionManager
    implements HttpClientConnectionManager {
        private final HttpClientConnectionManager delegate;

        protected DelegatingHttpClientConnectionManager(HttpClientConnectionManager delegate) {
            this.delegate = delegate;
        }

        public LeaseRequest lease(String id, HttpRoute route, Timeout requestTimeout, Object state) {
            return this.delegate.lease(id, route, requestTimeout, state);
        }

        public void release(ConnectionEndpoint endpoint, Object newState, TimeValue validDuration) {
            this.delegate.release(endpoint, newState, validDuration);
        }

        public void connect(ConnectionEndpoint endpoint, TimeValue connectTimeout, HttpContext context) throws IOException {
            this.delegate.connect(endpoint, connectTimeout, context);
        }

        public void upgrade(ConnectionEndpoint endpoint, HttpContext context) throws IOException {
            this.delegate.upgrade(endpoint, context);
        }

        public void close(CloseMode closeMode) {
            this.delegate.close(closeMode);
        }

        public void close() throws IOException {
            this.delegate.close();
        }
    }

    private static class InstrumentedHttpClientConnectionManager
    extends DelegatingHttpClientConnectionManager {
        private InstrumentedHttpClientConnectionManager(HttpClientConnectionManager delegate) {
            super(delegate);
        }

        @Override
        public LeaseRequest lease(String id, HttpRoute route, Timeout requestTimeout, Object state) {
            LeaseRequest connectionRequest = super.lease(id, route, requestTimeout, state);
            return ClientConnectionRequestFactory.wrap(connectionRequest);
        }
    }
}

