/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.apache.internal.net;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.http.apache.internal.net.DelegateSocket;

public class SdkSocket
extends DelegateSocket {
    private static final Logger log = LoggerFactory.getLogger(SdkSocket.class);

    public SdkSocket(Socket sock) {
        super(sock);
        if (log.isDebugEnabled()) {
            log.debug("created: " + this.endpoint());
        }
    }

    private String endpoint() {
        return this.sock.getInetAddress() + ":" + this.sock.getPort();
    }

    @Override
    public void connect(SocketAddress endpoint) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("connecting to: {}", (Object)endpoint);
        }
        this.sock.connect(endpoint);
        if (log.isDebugEnabled()) {
            log.debug("connected to: {}", (Object)this.endpoint());
        }
    }

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("connecting to: {}", (Object)endpoint);
        }
        this.sock.connect(endpoint, timeout);
        if (log.isDebugEnabled()) {
            log.debug("connected to: {}", (Object)this.endpoint());
        }
    }

    @Override
    public void close() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("closing {}", (Object)this.endpoint());
        }
        this.sock.close();
    }

    @Override
    public void shutdownInput() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("shutting down input of {}", (Object)this.endpoint());
        }
        this.sock.shutdownInput();
    }

    @Override
    public void shutdownOutput() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("shutting down output of {}", (Object)this.endpoint());
        }
        this.sock.shutdownOutput();
    }
}

