/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.apache.internal.impl;

import java.net.URI;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import software.amazon.awssdk.http.SdkHttpFullRequest;

public class SdkHttpUtils {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final Pattern ENCODED_CHARACTERS_PATTERN;

    public static boolean isUsingNonDefaultPort(URI uri) {
        String scheme = uri.getScheme().toLowerCase(Locale.ENGLISH);
        int port = uri.getPort();
        if (port <= 0) {
            return false;
        }
        if (scheme.equals("http") && port == 80) {
            return false;
        }
        return !scheme.equals("https") || port != 443;
    }

    public static String encodeParameters(SdkHttpFullRequest request) {
        Map requestParams = request.getParameters();
        if (requestParams.isEmpty()) {
            return null;
        }
        List nameValuePairs = requestParams.entrySet().stream().flatMap(e -> ((List)e.getValue()).stream().map(v -> new BasicNameValuePair((String)e.getKey(), v))).collect(Collectors.toList());
        return URLEncodedUtils.format(nameValuePairs, (String)DEFAULT_ENCODING);
    }

    public static String appendUri(String baseUri, String path, boolean escapeDoubleSlash) {
        String resultUri = baseUri;
        if (path != null && path.length() > 0) {
            if (path.startsWith("/")) {
                if (resultUri.endsWith("/")) {
                    resultUri = resultUri.substring(0, resultUri.length() - 1);
                }
            } else if (!resultUri.endsWith("/")) {
                resultUri = resultUri + "/";
            }
            resultUri = escapeDoubleSlash ? resultUri + path.replace("//", "/%2F") : resultUri + path;
        } else if (!resultUri.endsWith("/")) {
            resultUri = resultUri + "/";
        }
        return resultUri;
    }

    static {
        StringBuilder pattern = new StringBuilder();
        pattern.append(Pattern.quote("+")).append("|").append(Pattern.quote("*")).append("|").append(Pattern.quote("%7E")).append("|").append(Pattern.quote("%2F"));
        ENCODED_CHARACTERS_PATTERN = Pattern.compile(pattern.toString());
    }
}

