/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.amplifyuibuilder.model.CodegenFeatureFlags;
import software.amazon.awssdk.services.amplifyuibuilder.model.CodegenJobGenericDataSchema;
import software.amazon.awssdk.services.amplifyuibuilder.model.CodegenJobRenderConfig;
import software.amazon.awssdk.services.amplifyuibuilder.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartCodegenJobData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StartCodegenJobData> {
    private static final SdkField<CodegenJobRenderConfig> RENDER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("renderConfig").getter(StartCodegenJobData.getter(StartCodegenJobData::renderConfig)).setter(StartCodegenJobData.setter(Builder::renderConfig)).constructor(CodegenJobRenderConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("renderConfig").build()}).build();
    private static final SdkField<CodegenJobGenericDataSchema> GENERIC_DATA_SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("genericDataSchema").getter(StartCodegenJobData.getter(StartCodegenJobData::genericDataSchema)).setter(StartCodegenJobData.setter(Builder::genericDataSchema)).constructor(CodegenJobGenericDataSchema::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("genericDataSchema").build()}).build();
    private static final SdkField<Boolean> AUTO_GENERATE_FORMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("autoGenerateForms").getter(StartCodegenJobData.getter(StartCodegenJobData::autoGenerateForms)).setter(StartCodegenJobData.setter(Builder::autoGenerateForms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoGenerateForms").build()}).build();
    private static final SdkField<CodegenFeatureFlags> FEATURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("features").getter(StartCodegenJobData.getter(StartCodegenJobData::features)).setter(StartCodegenJobData.setter(Builder::features)).constructor(CodegenFeatureFlags::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("features").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(StartCodegenJobData.getter(StartCodegenJobData::tags)).setter(StartCodegenJobData.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RENDER_CONFIG_FIELD, GENERIC_DATA_SCHEMA_FIELD, AUTO_GENERATE_FORMS_FIELD, FEATURES_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartCodegenJobData.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final CodegenJobRenderConfig renderConfig;
    private final CodegenJobGenericDataSchema genericDataSchema;
    private final Boolean autoGenerateForms;
    private final CodegenFeatureFlags features;
    private final Map<String, String> tags;

    private StartCodegenJobData(BuilderImpl builder) {
        this.renderConfig = builder.renderConfig;
        this.genericDataSchema = builder.genericDataSchema;
        this.autoGenerateForms = builder.autoGenerateForms;
        this.features = builder.features;
        this.tags = builder.tags;
    }

    public final CodegenJobRenderConfig renderConfig() {
        return this.renderConfig;
    }

    public final CodegenJobGenericDataSchema genericDataSchema() {
        return this.genericDataSchema;
    }

    public final Boolean autoGenerateForms() {
        return this.autoGenerateForms;
    }

    public final CodegenFeatureFlags features() {
        return this.features;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.renderConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.genericDataSchema());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoGenerateForms());
        hashCode = 31 * hashCode + Objects.hashCode(this.features());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartCodegenJobData)) {
            return false;
        }
        StartCodegenJobData other = (StartCodegenJobData)obj;
        return Objects.equals(this.renderConfig(), other.renderConfig()) && Objects.equals(this.genericDataSchema(), other.genericDataSchema()) && Objects.equals(this.autoGenerateForms(), other.autoGenerateForms()) && Objects.equals(this.features(), other.features()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"StartCodegenJobData").add("RenderConfig", (Object)this.renderConfig()).add("GenericDataSchema", (Object)this.genericDataSchema()).add("AutoGenerateForms", (Object)this.autoGenerateForms()).add("Features", (Object)this.features()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "renderConfig": {
                return Optional.ofNullable(clazz.cast(this.renderConfig()));
            }
            case "genericDataSchema": {
                return Optional.ofNullable(clazz.cast(this.genericDataSchema()));
            }
            case "autoGenerateForms": {
                return Optional.ofNullable(clazz.cast(this.autoGenerateForms()));
            }
            case "features": {
                return Optional.ofNullable(clazz.cast(this.features()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("renderConfig", RENDER_CONFIG_FIELD);
        map.put("genericDataSchema", GENERIC_DATA_SCHEMA_FIELD);
        map.put("autoGenerateForms", AUTO_GENERATE_FORMS_FIELD);
        map.put("features", FEATURES_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartCodegenJobData, T> g) {
        return obj -> g.apply((StartCodegenJobData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CodegenJobRenderConfig renderConfig;
        private CodegenJobGenericDataSchema genericDataSchema;
        private Boolean autoGenerateForms;
        private CodegenFeatureFlags features;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartCodegenJobData model) {
            this.renderConfig(model.renderConfig);
            this.genericDataSchema(model.genericDataSchema);
            this.autoGenerateForms(model.autoGenerateForms);
            this.features(model.features);
            this.tags(model.tags);
        }

        public final CodegenJobRenderConfig.Builder getRenderConfig() {
            return this.renderConfig != null ? this.renderConfig.toBuilder() : null;
        }

        public final void setRenderConfig(CodegenJobRenderConfig.BuilderImpl renderConfig) {
            this.renderConfig = renderConfig != null ? renderConfig.build() : null;
        }

        @Override
        public final Builder renderConfig(CodegenJobRenderConfig renderConfig) {
            this.renderConfig = renderConfig;
            return this;
        }

        public final CodegenJobGenericDataSchema.Builder getGenericDataSchema() {
            return this.genericDataSchema != null ? this.genericDataSchema.toBuilder() : null;
        }

        public final void setGenericDataSchema(CodegenJobGenericDataSchema.BuilderImpl genericDataSchema) {
            this.genericDataSchema = genericDataSchema != null ? genericDataSchema.build() : null;
        }

        @Override
        public final Builder genericDataSchema(CodegenJobGenericDataSchema genericDataSchema) {
            this.genericDataSchema = genericDataSchema;
            return this;
        }

        public final Boolean getAutoGenerateForms() {
            return this.autoGenerateForms;
        }

        public final void setAutoGenerateForms(Boolean autoGenerateForms) {
            this.autoGenerateForms = autoGenerateForms;
        }

        @Override
        public final Builder autoGenerateForms(Boolean autoGenerateForms) {
            this.autoGenerateForms = autoGenerateForms;
            return this;
        }

        public final CodegenFeatureFlags.Builder getFeatures() {
            return this.features != null ? this.features.toBuilder() : null;
        }

        public final void setFeatures(CodegenFeatureFlags.BuilderImpl features) {
            this.features = features != null ? features.build() : null;
        }

        @Override
        public final Builder features(CodegenFeatureFlags features) {
            this.features = features;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public StartCodegenJobData build() {
            return new StartCodegenJobData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StartCodegenJobData> {
        public Builder renderConfig(CodegenJobRenderConfig var1);

        default public Builder renderConfig(Consumer<CodegenJobRenderConfig.Builder> renderConfig) {
            return this.renderConfig((CodegenJobRenderConfig)((CodegenJobRenderConfig.Builder)CodegenJobRenderConfig.builder().applyMutation(renderConfig)).build());
        }

        public Builder genericDataSchema(CodegenJobGenericDataSchema var1);

        default public Builder genericDataSchema(Consumer<CodegenJobGenericDataSchema.Builder> genericDataSchema) {
            return this.genericDataSchema((CodegenJobGenericDataSchema)((CodegenJobGenericDataSchema.Builder)CodegenJobGenericDataSchema.builder().applyMutation(genericDataSchema)).build());
        }

        public Builder autoGenerateForms(Boolean var1);

        public Builder features(CodegenFeatureFlags var1);

        default public Builder features(Consumer<CodegenFeatureFlags.Builder> features) {
            return this.features((CodegenFeatureFlags)((CodegenFeatureFlags.Builder)CodegenFeatureFlags.builder().applyMutation(features)).build());
        }

        public Builder tags(Map<String, String> var1);
    }
}

