/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.amplifyuibuilder.model.AmplifyUiBuilderRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.UpdateComponentData;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateComponentRequest
extends AmplifyUiBuilderRequest
implements ToCopyableBuilder<Builder, UpdateComponentRequest> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appId").getter(UpdateComponentRequest.getter(UpdateComponentRequest::appId)).setter(UpdateComponentRequest.setter(Builder::appId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("appId").build()}).build();
    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentName").getter(UpdateComponentRequest.getter(UpdateComponentRequest::environmentName)).setter(UpdateComponentRequest.setter(Builder::environmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("environmentName").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(UpdateComponentRequest.getter(UpdateComponentRequest::id)).setter(UpdateComponentRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateComponentRequest.getter(UpdateComponentRequest::clientToken)).setter(UpdateComponentRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<UpdateComponentData> UPDATED_COMPONENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("updatedComponent").getter(UpdateComponentRequest.getter(UpdateComponentRequest::updatedComponent)).setter(UpdateComponentRequest.setter(Builder::updatedComponent)).constructor(UpdateComponentData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedComponent").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD, ENVIRONMENT_NAME_FIELD, ID_FIELD, CLIENT_TOKEN_FIELD, UPDATED_COMPONENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateComponentRequest.memberNameToFieldInitializer();
    private final String appId;
    private final String environmentName;
    private final String id;
    private final String clientToken;
    private final UpdateComponentData updatedComponent;

    private UpdateComponentRequest(BuilderImpl builder) {
        super(builder);
        this.appId = builder.appId;
        this.environmentName = builder.environmentName;
        this.id = builder.id;
        this.clientToken = builder.clientToken;
        this.updatedComponent = builder.updatedComponent;
    }

    public final String appId() {
        return this.appId;
    }

    public final String environmentName() {
        return this.environmentName;
    }

    public final String id() {
        return this.id;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final UpdateComponentData updatedComponent() {
        return this.updatedComponent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appId());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedComponent());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateComponentRequest)) {
            return false;
        }
        UpdateComponentRequest other = (UpdateComponentRequest)((Object)obj);
        return Objects.equals(this.appId(), other.appId()) && Objects.equals(this.environmentName(), other.environmentName()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.updatedComponent(), other.updatedComponent());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateComponentRequest").add("AppId", (Object)this.appId()).add("EnvironmentName", (Object)this.environmentName()).add("Id", (Object)this.id()).add("ClientToken", (Object)this.clientToken()).add("UpdatedComponent", (Object)this.updatedComponent()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appId": {
                return Optional.ofNullable(clazz.cast(this.appId()));
            }
            case "environmentName": {
                return Optional.ofNullable(clazz.cast(this.environmentName()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "updatedComponent": {
                return Optional.ofNullable(clazz.cast(this.updatedComponent()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appId", APP_ID_FIELD);
        map.put("environmentName", ENVIRONMENT_NAME_FIELD);
        map.put("id", ID_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("updatedComponent", UPDATED_COMPONENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateComponentRequest, T> g) {
        return obj -> g.apply((UpdateComponentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AmplifyUiBuilderRequest.BuilderImpl
    implements Builder {
        private String appId;
        private String environmentName;
        private String id;
        private String clientToken;
        private UpdateComponentData updatedComponent;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateComponentRequest model) {
            super(model);
            this.appId(model.appId);
            this.environmentName(model.environmentName);
            this.id(model.id);
            this.clientToken(model.clientToken);
            this.updatedComponent(model.updatedComponent);
        }

        public final String getAppId() {
            return this.appId;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final String getEnvironmentName() {
            return this.environmentName;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final UpdateComponentData.Builder getUpdatedComponent() {
            return this.updatedComponent != null ? this.updatedComponent.toBuilder() : null;
        }

        public final void setUpdatedComponent(UpdateComponentData.BuilderImpl updatedComponent) {
            this.updatedComponent = updatedComponent != null ? updatedComponent.build() : null;
        }

        @Override
        public final Builder updatedComponent(UpdateComponentData updatedComponent) {
            this.updatedComponent = updatedComponent;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateComponentRequest build() {
            return new UpdateComponentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AmplifyUiBuilderRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateComponentRequest> {
        public Builder appId(String var1);

        public Builder environmentName(String var1);

        public Builder id(String var1);

        public Builder clientToken(String var1);

        public Builder updatedComponent(UpdateComponentData var1);

        default public Builder updatedComponent(Consumer<UpdateComponentData.Builder> updatedComponent) {
            return this.updatedComponent((UpdateComponentData)((UpdateComponentData.Builder)UpdateComponentData.builder().applyMutation(updatedComponent)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

