/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.amplifyuibuilder.model.ComponentBindingPropertiesCopier;
import software.amazon.awssdk.services.amplifyuibuilder.model.ComponentBindingPropertiesValue;
import software.amazon.awssdk.services.amplifyuibuilder.model.ComponentChild;
import software.amazon.awssdk.services.amplifyuibuilder.model.ComponentChildListCopier;
import software.amazon.awssdk.services.amplifyuibuilder.model.ComponentCollectionPropertiesCopier;
import software.amazon.awssdk.services.amplifyuibuilder.model.ComponentDataConfiguration;
import software.amazon.awssdk.services.amplifyuibuilder.model.ComponentEvent;
import software.amazon.awssdk.services.amplifyuibuilder.model.ComponentEventsCopier;
import software.amazon.awssdk.services.amplifyuibuilder.model.ComponentOverridesCopier;
import software.amazon.awssdk.services.amplifyuibuilder.model.ComponentPropertiesCopier;
import software.amazon.awssdk.services.amplifyuibuilder.model.ComponentProperty;
import software.amazon.awssdk.services.amplifyuibuilder.model.ComponentVariant;
import software.amazon.awssdk.services.amplifyuibuilder.model.ComponentVariantsCopier;
import software.amazon.awssdk.services.amplifyuibuilder.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Component
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Component> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appId").getter(Component.getter(Component::appId)).setter(Component.setter(Builder::appId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appId").build()}).build();
    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentName").getter(Component.getter(Component::environmentName)).setter(Component.setter(Builder::environmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentName").build()}).build();
    private static final SdkField<String> SOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceId").getter(Component.getter(Component::sourceId)).setter(Component.setter(Builder::sourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceId").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(Component.getter(Component::id)).setter(Component.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Component.getter(Component::name)).setter(Component.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> COMPONENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("componentType").getter(Component.getter(Component::componentType)).setter(Component.setter(Builder::componentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentType").build()}).build();
    private static final SdkField<Map<String, ComponentProperty>> PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("properties").getter(Component.getter(Component::properties)).setter(Component.setter(Builder::properties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("properties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComponentProperty::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<ComponentChild>> CHILDREN_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("children").getter(Component.getter(Component::children)).setter(Component.setter(Builder::children)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("children").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComponentChild::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ComponentVariant>> VARIANTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("variants").getter(Component.getter(Component::variants)).setter(Component.setter(Builder::variants)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variants").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComponentVariant::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, Map<String, String>>> OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("overrides").getter(Component.getter(Component::overrides)).setter(Component.setter(Builder::overrides)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrides").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.MAP).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<Map<String, ComponentBindingPropertiesValue>> BINDING_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("bindingProperties").getter(Component.getter(Component::bindingProperties)).setter(Component.setter(Builder::bindingProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bindingProperties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComponentBindingPropertiesValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, ComponentDataConfiguration>> COLLECTION_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("collectionProperties").getter(Component.getter(Component::collectionProperties)).setter(Component.setter(Builder::collectionProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collectionProperties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComponentDataConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(Component.getter(Component::createdAt)).setter(Component.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("modifiedAt").getter(Component.getter(Component::modifiedAt)).setter(Component.setter(Builder::modifiedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(Component.getter(Component::tags)).setter(Component.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, ComponentEvent>> EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("events").getter(Component.getter(Component::events)).setter(Component.setter(Builder::events)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("events").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComponentEvent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> SCHEMA_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("schemaVersion").getter(Component.getter(Component::schemaVersion)).setter(Component.setter(Builder::schemaVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemaVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD, ENVIRONMENT_NAME_FIELD, SOURCE_ID_FIELD, ID_FIELD, NAME_FIELD, COMPONENT_TYPE_FIELD, PROPERTIES_FIELD, CHILDREN_FIELD, VARIANTS_FIELD, OVERRIDES_FIELD, BINDING_PROPERTIES_FIELD, COLLECTION_PROPERTIES_FIELD, CREATED_AT_FIELD, MODIFIED_AT_FIELD, TAGS_FIELD, EVENTS_FIELD, SCHEMA_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Component.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String appId;
    private final String environmentName;
    private final String sourceId;
    private final String id;
    private final String name;
    private final String componentType;
    private final Map<String, ComponentProperty> properties;
    private final List<ComponentChild> children;
    private final List<ComponentVariant> variants;
    private final Map<String, Map<String, String>> overrides;
    private final Map<String, ComponentBindingPropertiesValue> bindingProperties;
    private final Map<String, ComponentDataConfiguration> collectionProperties;
    private final Instant createdAt;
    private final Instant modifiedAt;
    private final Map<String, String> tags;
    private final Map<String, ComponentEvent> events;
    private final String schemaVersion;

    private Component(BuilderImpl builder) {
        this.appId = builder.appId;
        this.environmentName = builder.environmentName;
        this.sourceId = builder.sourceId;
        this.id = builder.id;
        this.name = builder.name;
        this.componentType = builder.componentType;
        this.properties = builder.properties;
        this.children = builder.children;
        this.variants = builder.variants;
        this.overrides = builder.overrides;
        this.bindingProperties = builder.bindingProperties;
        this.collectionProperties = builder.collectionProperties;
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
        this.tags = builder.tags;
        this.events = builder.events;
        this.schemaVersion = builder.schemaVersion;
    }

    public final String appId() {
        return this.appId;
    }

    public final String environmentName() {
        return this.environmentName;
    }

    public final String sourceId() {
        return this.sourceId;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final String componentType() {
        return this.componentType;
    }

    public final boolean hasProperties() {
        return this.properties != null && !(this.properties instanceof SdkAutoConstructMap);
    }

    public final Map<String, ComponentProperty> properties() {
        return this.properties;
    }

    public final boolean hasChildren() {
        return this.children != null && !(this.children instanceof SdkAutoConstructList);
    }

    public final List<ComponentChild> children() {
        return this.children;
    }

    public final boolean hasVariants() {
        return this.variants != null && !(this.variants instanceof SdkAutoConstructList);
    }

    public final List<ComponentVariant> variants() {
        return this.variants;
    }

    public final boolean hasOverrides() {
        return this.overrides != null && !(this.overrides instanceof SdkAutoConstructMap);
    }

    public final Map<String, Map<String, String>> overrides() {
        return this.overrides;
    }

    public final boolean hasBindingProperties() {
        return this.bindingProperties != null && !(this.bindingProperties instanceof SdkAutoConstructMap);
    }

    public final Map<String, ComponentBindingPropertiesValue> bindingProperties() {
        return this.bindingProperties;
    }

    public final boolean hasCollectionProperties() {
        return this.collectionProperties != null && !(this.collectionProperties instanceof SdkAutoConstructMap);
    }

    public final Map<String, ComponentDataConfiguration> collectionProperties() {
        return this.collectionProperties;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant modifiedAt() {
        return this.modifiedAt;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final boolean hasEvents() {
        return this.events != null && !(this.events instanceof SdkAutoConstructMap);
    }

    public final Map<String, ComponentEvent> events() {
        return this.events;
    }

    public final String schemaVersion() {
        return this.schemaVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.appId());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.componentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProperties() ? this.properties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChildren() ? this.children() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVariants() ? this.variants() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOverrides() ? this.overrides() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBindingProperties() ? this.bindingProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCollectionProperties() ? this.collectionProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEvents() ? this.events() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Component)) {
            return false;
        }
        Component other = (Component)obj;
        return Objects.equals(this.appId(), other.appId()) && Objects.equals(this.environmentName(), other.environmentName()) && Objects.equals(this.sourceId(), other.sourceId()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.componentType(), other.componentType()) && this.hasProperties() == other.hasProperties() && Objects.equals(this.properties(), other.properties()) && this.hasChildren() == other.hasChildren() && Objects.equals(this.children(), other.children()) && this.hasVariants() == other.hasVariants() && Objects.equals(this.variants(), other.variants()) && this.hasOverrides() == other.hasOverrides() && Objects.equals(this.overrides(), other.overrides()) && this.hasBindingProperties() == other.hasBindingProperties() && Objects.equals(this.bindingProperties(), other.bindingProperties()) && this.hasCollectionProperties() == other.hasCollectionProperties() && Objects.equals(this.collectionProperties(), other.collectionProperties()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.modifiedAt(), other.modifiedAt()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasEvents() == other.hasEvents() && Objects.equals(this.events(), other.events()) && Objects.equals(this.schemaVersion(), other.schemaVersion());
    }

    public final String toString() {
        return ToString.builder((String)"Component").add("AppId", (Object)this.appId()).add("EnvironmentName", (Object)this.environmentName()).add("SourceId", (Object)this.sourceId()).add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("ComponentType", (Object)this.componentType()).add("Properties", this.hasProperties() ? this.properties() : null).add("Children", this.hasChildren() ? this.children() : null).add("Variants", this.hasVariants() ? this.variants() : null).add("Overrides", this.hasOverrides() ? this.overrides() : null).add("BindingProperties", this.hasBindingProperties() ? this.bindingProperties() : null).add("CollectionProperties", this.hasCollectionProperties() ? this.collectionProperties() : null).add("CreatedAt", (Object)this.createdAt()).add("ModifiedAt", (Object)this.modifiedAt()).add("Tags", this.hasTags() ? this.tags() : null).add("Events", this.hasEvents() ? this.events() : null).add("SchemaVersion", (Object)this.schemaVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appId": {
                return Optional.ofNullable(clazz.cast(this.appId()));
            }
            case "environmentName": {
                return Optional.ofNullable(clazz.cast(this.environmentName()));
            }
            case "sourceId": {
                return Optional.ofNullable(clazz.cast(this.sourceId()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "componentType": {
                return Optional.ofNullable(clazz.cast(this.componentType()));
            }
            case "properties": {
                return Optional.ofNullable(clazz.cast(this.properties()));
            }
            case "children": {
                return Optional.ofNullable(clazz.cast(this.children()));
            }
            case "variants": {
                return Optional.ofNullable(clazz.cast(this.variants()));
            }
            case "overrides": {
                return Optional.ofNullable(clazz.cast(this.overrides()));
            }
            case "bindingProperties": {
                return Optional.ofNullable(clazz.cast(this.bindingProperties()));
            }
            case "collectionProperties": {
                return Optional.ofNullable(clazz.cast(this.collectionProperties()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "modifiedAt": {
                return Optional.ofNullable(clazz.cast(this.modifiedAt()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "events": {
                return Optional.ofNullable(clazz.cast(this.events()));
            }
            case "schemaVersion": {
                return Optional.ofNullable(clazz.cast(this.schemaVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appId", APP_ID_FIELD);
        map.put("environmentName", ENVIRONMENT_NAME_FIELD);
        map.put("sourceId", SOURCE_ID_FIELD);
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("componentType", COMPONENT_TYPE_FIELD);
        map.put("properties", PROPERTIES_FIELD);
        map.put("children", CHILDREN_FIELD);
        map.put("variants", VARIANTS_FIELD);
        map.put("overrides", OVERRIDES_FIELD);
        map.put("bindingProperties", BINDING_PROPERTIES_FIELD);
        map.put("collectionProperties", COLLECTION_PROPERTIES_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("modifiedAt", MODIFIED_AT_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("events", EVENTS_FIELD);
        map.put("schemaVersion", SCHEMA_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Component, T> g) {
        return obj -> g.apply((Component)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String appId;
        private String environmentName;
        private String sourceId;
        private String id;
        private String name;
        private String componentType;
        private Map<String, ComponentProperty> properties = DefaultSdkAutoConstructMap.getInstance();
        private List<ComponentChild> children = DefaultSdkAutoConstructList.getInstance();
        private List<ComponentVariant> variants = DefaultSdkAutoConstructList.getInstance();
        private Map<String, Map<String, String>> overrides = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, ComponentBindingPropertiesValue> bindingProperties = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, ComponentDataConfiguration> collectionProperties = DefaultSdkAutoConstructMap.getInstance();
        private Instant createdAt;
        private Instant modifiedAt;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, ComponentEvent> events = DefaultSdkAutoConstructMap.getInstance();
        private String schemaVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(Component model) {
            this.appId(model.appId);
            this.environmentName(model.environmentName);
            this.sourceId(model.sourceId);
            this.id(model.id);
            this.name(model.name);
            this.componentType(model.componentType);
            this.properties(model.properties);
            this.children(model.children);
            this.variants(model.variants);
            this.overrides(model.overrides);
            this.bindingProperties(model.bindingProperties);
            this.collectionProperties(model.collectionProperties);
            this.createdAt(model.createdAt);
            this.modifiedAt(model.modifiedAt);
            this.tags(model.tags);
            this.events(model.events);
            this.schemaVersion(model.schemaVersion);
        }

        public final String getAppId() {
            return this.appId;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final String getEnvironmentName() {
            return this.environmentName;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final String getSourceId() {
            return this.sourceId;
        }

        public final void setSourceId(String sourceId) {
            this.sourceId = sourceId;
        }

        @Override
        public final Builder sourceId(String sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getComponentType() {
            return this.componentType;
        }

        public final void setComponentType(String componentType) {
            this.componentType = componentType;
        }

        @Override
        public final Builder componentType(String componentType) {
            this.componentType = componentType;
            return this;
        }

        public final Map<String, ComponentProperty.Builder> getProperties() {
            Map<String, ComponentProperty.Builder> result = ComponentPropertiesCopier.copyToBuilder(this.properties);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setProperties(Map<String, ComponentProperty.BuilderImpl> properties) {
            this.properties = ComponentPropertiesCopier.copyFromBuilder(properties);
        }

        @Override
        public final Builder properties(Map<String, ComponentProperty> properties) {
            this.properties = ComponentPropertiesCopier.copy(properties);
            return this;
        }

        public final List<ComponentChild.Builder> getChildren() {
            List<ComponentChild.Builder> result = ComponentChildListCopier.copyToBuilder(this.children);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChildren(Collection<ComponentChild.BuilderImpl> children) {
            this.children = ComponentChildListCopier.copyFromBuilder(children);
        }

        @Override
        public final Builder children(Collection<ComponentChild> children) {
            this.children = ComponentChildListCopier.copy(children);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder children(ComponentChild ... children) {
            this.children(Arrays.asList(children));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder children(Consumer<ComponentChild.Builder> ... children) {
            this.children(Stream.of(children).map(c -> (ComponentChild)((ComponentChild.Builder)ComponentChild.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ComponentVariant.Builder> getVariants() {
            List<ComponentVariant.Builder> result = ComponentVariantsCopier.copyToBuilder(this.variants);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVariants(Collection<ComponentVariant.BuilderImpl> variants) {
            this.variants = ComponentVariantsCopier.copyFromBuilder(variants);
        }

        @Override
        public final Builder variants(Collection<ComponentVariant> variants) {
            this.variants = ComponentVariantsCopier.copy(variants);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variants(ComponentVariant ... variants) {
            this.variants(Arrays.asList(variants));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variants(Consumer<ComponentVariant.Builder> ... variants) {
            this.variants(Stream.of(variants).map(c -> (ComponentVariant)((ComponentVariant.Builder)ComponentVariant.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, ? extends Map<String, String>> getOverrides() {
            if (this.overrides instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.overrides;
        }

        public final void setOverrides(Map<String, ? extends Map<String, String>> overrides) {
            this.overrides = ComponentOverridesCopier.copy(overrides);
        }

        @Override
        public final Builder overrides(Map<String, ? extends Map<String, String>> overrides) {
            this.overrides = ComponentOverridesCopier.copy(overrides);
            return this;
        }

        public final Map<String, ComponentBindingPropertiesValue.Builder> getBindingProperties() {
            Map<String, ComponentBindingPropertiesValue.Builder> result = ComponentBindingPropertiesCopier.copyToBuilder(this.bindingProperties);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setBindingProperties(Map<String, ComponentBindingPropertiesValue.BuilderImpl> bindingProperties) {
            this.bindingProperties = ComponentBindingPropertiesCopier.copyFromBuilder(bindingProperties);
        }

        @Override
        public final Builder bindingProperties(Map<String, ComponentBindingPropertiesValue> bindingProperties) {
            this.bindingProperties = ComponentBindingPropertiesCopier.copy(bindingProperties);
            return this;
        }

        public final Map<String, ComponentDataConfiguration.Builder> getCollectionProperties() {
            Map<String, ComponentDataConfiguration.Builder> result = ComponentCollectionPropertiesCopier.copyToBuilder(this.collectionProperties);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setCollectionProperties(Map<String, ComponentDataConfiguration.BuilderImpl> collectionProperties) {
            this.collectionProperties = ComponentCollectionPropertiesCopier.copyFromBuilder(collectionProperties);
        }

        @Override
        public final Builder collectionProperties(Map<String, ComponentDataConfiguration> collectionProperties) {
            this.collectionProperties = ComponentCollectionPropertiesCopier.copy(collectionProperties);
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getModifiedAt() {
            return this.modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final Map<String, ComponentEvent.Builder> getEvents() {
            Map<String, ComponentEvent.Builder> result = ComponentEventsCopier.copyToBuilder(this.events);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setEvents(Map<String, ComponentEvent.BuilderImpl> events) {
            this.events = ComponentEventsCopier.copyFromBuilder(events);
        }

        @Override
        public final Builder events(Map<String, ComponentEvent> events) {
            this.events = ComponentEventsCopier.copy(events);
            return this;
        }

        public final String getSchemaVersion() {
            return this.schemaVersion;
        }

        public final void setSchemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
        }

        @Override
        public final Builder schemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        public Component build() {
            return new Component(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Component> {
        public Builder appId(String var1);

        public Builder environmentName(String var1);

        public Builder sourceId(String var1);

        public Builder id(String var1);

        public Builder name(String var1);

        public Builder componentType(String var1);

        public Builder properties(Map<String, ComponentProperty> var1);

        public Builder children(Collection<ComponentChild> var1);

        public Builder children(ComponentChild ... var1);

        public Builder children(Consumer<ComponentChild.Builder> ... var1);

        public Builder variants(Collection<ComponentVariant> var1);

        public Builder variants(ComponentVariant ... var1);

        public Builder variants(Consumer<ComponentVariant.Builder> ... var1);

        public Builder overrides(Map<String, ? extends Map<String, String>> var1);

        public Builder bindingProperties(Map<String, ComponentBindingPropertiesValue> var1);

        public Builder collectionProperties(Map<String, ComponentDataConfiguration> var1);

        public Builder createdAt(Instant var1);

        public Builder modifiedAt(Instant var1);

        public Builder tags(Map<String, String> var1);

        public Builder events(Map<String, ComponentEvent> var1);

        public Builder schemaVersion(String var1);
    }
}

