/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.amplifyuibuilder.model.FormInputValuePropertyBindingProperties;
import software.amazon.awssdk.services.amplifyuibuilder.model.FormInputValuePropertyListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FormInputValueProperty
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FormInputValueProperty> {
    private static final SdkField<String> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("value").getter(FormInputValueProperty.getter(FormInputValueProperty::value)).setter(FormInputValueProperty.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build();
    private static final SdkField<FormInputValuePropertyBindingProperties> BINDING_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("bindingProperties").getter(FormInputValueProperty.getter(FormInputValueProperty::bindingProperties)).setter(FormInputValueProperty.setter(Builder::bindingProperties)).constructor(FormInputValuePropertyBindingProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bindingProperties").build()}).build();
    private static final SdkField<List<FormInputValueProperty>> CONCAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("concat").getter(FormInputValueProperty.getter(FormInputValueProperty::concat)).setter(FormInputValueProperty.setter(Builder::concat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("concat").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FormInputValueProperty::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, BINDING_PROPERTIES_FIELD, CONCAT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FormInputValueProperty.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String value;
    private final FormInputValuePropertyBindingProperties bindingProperties;
    private final List<FormInputValueProperty> concat;

    private FormInputValueProperty(BuilderImpl builder) {
        this.value = builder.value;
        this.bindingProperties = builder.bindingProperties;
        this.concat = builder.concat;
    }

    public final String value() {
        return this.value;
    }

    public final FormInputValuePropertyBindingProperties bindingProperties() {
        return this.bindingProperties;
    }

    public final boolean hasConcat() {
        return this.concat != null && !(this.concat instanceof SdkAutoConstructList);
    }

    public final List<FormInputValueProperty> concat() {
        return this.concat;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.bindingProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConcat() ? this.concat() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FormInputValueProperty)) {
            return false;
        }
        FormInputValueProperty other = (FormInputValueProperty)obj;
        return Objects.equals(this.value(), other.value()) && Objects.equals(this.bindingProperties(), other.bindingProperties()) && this.hasConcat() == other.hasConcat() && Objects.equals(this.concat(), other.concat());
    }

    public final String toString() {
        return ToString.builder((String)"FormInputValueProperty").add("Value", (Object)this.value()).add("BindingProperties", (Object)this.bindingProperties()).add("Concat", this.hasConcat() ? this.concat() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "bindingProperties": {
                return Optional.ofNullable(clazz.cast(this.bindingProperties()));
            }
            case "concat": {
                return Optional.ofNullable(clazz.cast(this.concat()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("value", VALUE_FIELD);
        map.put("bindingProperties", BINDING_PROPERTIES_FIELD);
        map.put("concat", CONCAT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FormInputValueProperty, T> g) {
        return obj -> g.apply((FormInputValueProperty)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String value;
        private FormInputValuePropertyBindingProperties bindingProperties;
        private List<FormInputValueProperty> concat = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FormInputValueProperty model) {
            this.value(model.value);
            this.bindingProperties(model.bindingProperties);
            this.concat(model.concat);
        }

        public final String getValue() {
            return this.value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final FormInputValuePropertyBindingProperties.Builder getBindingProperties() {
            return this.bindingProperties != null ? this.bindingProperties.toBuilder() : null;
        }

        public final void setBindingProperties(FormInputValuePropertyBindingProperties.BuilderImpl bindingProperties) {
            this.bindingProperties = bindingProperties != null ? bindingProperties.build() : null;
        }

        @Override
        public final Builder bindingProperties(FormInputValuePropertyBindingProperties bindingProperties) {
            this.bindingProperties = bindingProperties;
            return this;
        }

        public final List<Builder> getConcat() {
            List<Builder> result = FormInputValuePropertyListCopier.copyToBuilder(this.concat);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConcat(Collection<BuilderImpl> concat) {
            this.concat = FormInputValuePropertyListCopier.copyFromBuilder(concat);
        }

        @Override
        public final Builder concat(Collection<FormInputValueProperty> concat) {
            this.concat = FormInputValuePropertyListCopier.copy(concat);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder concat(FormInputValueProperty ... concat) {
            this.concat(Arrays.asList(concat));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder concat(Consumer<Builder> ... concat) {
            this.concat(Stream.of(concat).map(c -> (FormInputValueProperty)((Builder)FormInputValueProperty.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public FormInputValueProperty build() {
            return new FormInputValueProperty(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FormInputValueProperty> {
        public Builder value(String var1);

        public Builder bindingProperties(FormInputValuePropertyBindingProperties var1);

        default public Builder bindingProperties(Consumer<FormInputValuePropertyBindingProperties.Builder> bindingProperties) {
            return this.bindingProperties((FormInputValuePropertyBindingProperties)((FormInputValuePropertyBindingProperties.Builder)FormInputValuePropertyBindingProperties.builder().applyMutation(bindingProperties)).build());
        }

        public Builder concat(Collection<FormInputValueProperty> var1);

        public Builder concat(FormInputValueProperty ... var1);

        public Builder concat(Consumer<Builder> ... var1);
    }
}

