/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.amplifyuibuilder.model.FormInputBindingPropertiesCopier;
import software.amazon.awssdk.services.amplifyuibuilder.model.FormInputBindingPropertiesValue;
import software.amazon.awssdk.services.amplifyuibuilder.model.ValueMapping;
import software.amazon.awssdk.services.amplifyuibuilder.model.ValueMappingListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ValueMappings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ValueMappings> {
    private static final SdkField<List<ValueMapping>> VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("values").getter(ValueMappings.getter(ValueMappings::values)).setter(ValueMappings.setter(Builder::values)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("values").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ValueMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, FormInputBindingPropertiesValue>> BINDING_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("bindingProperties").getter(ValueMappings.getter(ValueMappings::bindingProperties)).setter(ValueMappings.setter(Builder::bindingProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bindingProperties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FormInputBindingPropertiesValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUES_FIELD, BINDING_PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ValueMappings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<ValueMapping> values;
    private final Map<String, FormInputBindingPropertiesValue> bindingProperties;

    private ValueMappings(BuilderImpl builder) {
        this.values = builder.values;
        this.bindingProperties = builder.bindingProperties;
    }

    public final boolean hasValues() {
        return this.values != null && !(this.values instanceof SdkAutoConstructList);
    }

    public final List<ValueMapping> values() {
        return this.values;
    }

    public final boolean hasBindingProperties() {
        return this.bindingProperties != null && !(this.bindingProperties instanceof SdkAutoConstructMap);
    }

    public final Map<String, FormInputBindingPropertiesValue> bindingProperties() {
        return this.bindingProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValues() ? this.values() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBindingProperties() ? this.bindingProperties() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValueMappings)) {
            return false;
        }
        ValueMappings other = (ValueMappings)obj;
        return this.hasValues() == other.hasValues() && Objects.equals(this.values(), other.values()) && this.hasBindingProperties() == other.hasBindingProperties() && Objects.equals(this.bindingProperties(), other.bindingProperties());
    }

    public final String toString() {
        return ToString.builder((String)"ValueMappings").add("Values", this.hasValues() ? this.values() : null).add("BindingProperties", this.hasBindingProperties() ? this.bindingProperties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "values": {
                return Optional.ofNullable(clazz.cast(this.values()));
            }
            case "bindingProperties": {
                return Optional.ofNullable(clazz.cast(this.bindingProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("values", VALUES_FIELD);
        map.put("bindingProperties", BINDING_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ValueMappings, T> g) {
        return obj -> g.apply((ValueMappings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ValueMapping> values = DefaultSdkAutoConstructList.getInstance();
        private Map<String, FormInputBindingPropertiesValue> bindingProperties = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ValueMappings model) {
            this.values(model.values);
            this.bindingProperties(model.bindingProperties);
        }

        public final List<ValueMapping.Builder> getValues() {
            List<ValueMapping.Builder> result = ValueMappingListCopier.copyToBuilder(this.values);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValues(Collection<ValueMapping.BuilderImpl> values) {
            this.values = ValueMappingListCopier.copyFromBuilder(values);
        }

        @Override
        public final Builder values(Collection<ValueMapping> values) {
            this.values = ValueMappingListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(ValueMapping ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(Consumer<ValueMapping.Builder> ... values) {
            this.values(Stream.of(values).map(c -> (ValueMapping)((ValueMapping.Builder)ValueMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, FormInputBindingPropertiesValue.Builder> getBindingProperties() {
            Map<String, FormInputBindingPropertiesValue.Builder> result = FormInputBindingPropertiesCopier.copyToBuilder(this.bindingProperties);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setBindingProperties(Map<String, FormInputBindingPropertiesValue.BuilderImpl> bindingProperties) {
            this.bindingProperties = FormInputBindingPropertiesCopier.copyFromBuilder(bindingProperties);
        }

        @Override
        public final Builder bindingProperties(Map<String, FormInputBindingPropertiesValue> bindingProperties) {
            this.bindingProperties = FormInputBindingPropertiesCopier.copy(bindingProperties);
            return this;
        }

        public ValueMappings build() {
            return new ValueMappings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ValueMappings> {
        public Builder values(Collection<ValueMapping> var1);

        public Builder values(ValueMapping ... var1);

        public Builder values(Consumer<ValueMapping.Builder> ... var1);

        public Builder bindingProperties(Map<String, FormInputBindingPropertiesValue> var1);
    }
}

