/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum LabelDecorator {
    REQUIRED("required"),
    OPTIONAL("optional"),
    NONE("none"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, LabelDecorator> VALUE_MAP;
    private final String value;

    private LabelDecorator(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LabelDecorator fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LabelDecorator> knownValues() {
        EnumSet<LabelDecorator> knownValues = EnumSet.allOf(LabelDecorator.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(LabelDecorator.class, LabelDecorator::toString);
    }
}

