/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifyuibuilder;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.amplifyuibuilder.model.AmplifyUiBuilderException;
import software.amazon.awssdk.services.amplifyuibuilder.model.CreateComponentRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.CreateComponentResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.CreateFormRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.CreateFormResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.CreateThemeRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.CreateThemeResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.DeleteComponentRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.DeleteComponentResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.DeleteFormRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.DeleteFormResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.DeleteThemeRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.DeleteThemeResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.ExchangeCodeForTokenRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.ExchangeCodeForTokenResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.ExportComponentsRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.ExportComponentsResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.ExportFormsRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.ExportFormsResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.ExportThemesRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.ExportThemesResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.GetCodegenJobRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.GetCodegenJobResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.GetComponentRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.GetComponentResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.GetFormRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.GetFormResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.GetMetadataRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.GetMetadataResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.GetThemeRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.GetThemeResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.InternalServerException;
import software.amazon.awssdk.services.amplifyuibuilder.model.InvalidParameterException;
import software.amazon.awssdk.services.amplifyuibuilder.model.ListCodegenJobsRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.ListCodegenJobsResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.ListComponentsRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.ListComponentsResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.ListFormsRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.ListFormsResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.ListThemesRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.ListThemesResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.PutMetadataFlagRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.PutMetadataFlagResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.RefreshTokenRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.RefreshTokenResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.ResourceConflictException;
import software.amazon.awssdk.services.amplifyuibuilder.model.ResourceNotFoundException;
import software.amazon.awssdk.services.amplifyuibuilder.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.amplifyuibuilder.model.StartCodegenJobRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.StartCodegenJobResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.ThrottlingException;
import software.amazon.awssdk.services.amplifyuibuilder.model.UnauthorizedException;
import software.amazon.awssdk.services.amplifyuibuilder.model.UpdateComponentRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.UpdateComponentResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.UpdateFormRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.UpdateFormResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.UpdateThemeRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.UpdateThemeResponse;
import software.amazon.awssdk.services.amplifyuibuilder.transform.CreateComponentRequestMarshaller;
import software.amazon.awssdk.services.amplifyuibuilder.transform.CreateFormRequestMarshaller;
import software.amazon.awssdk.services.amplifyuibuilder.transform.CreateThemeRequestMarshaller;
import software.amazon.awssdk.services.amplifyuibuilder.transform.DeleteComponentRequestMarshaller;
import software.amazon.awssdk.services.amplifyuibuilder.transform.DeleteFormRequestMarshaller;
import software.amazon.awssdk.services.amplifyuibuilder.transform.DeleteThemeRequestMarshaller;
import software.amazon.awssdk.services.amplifyuibuilder.transform.ExchangeCodeForTokenRequestMarshaller;
import software.amazon.awssdk.services.amplifyuibuilder.transform.ExportComponentsRequestMarshaller;
import software.amazon.awssdk.services.amplifyuibuilder.transform.ExportFormsRequestMarshaller;
import software.amazon.awssdk.services.amplifyuibuilder.transform.ExportThemesRequestMarshaller;
import software.amazon.awssdk.services.amplifyuibuilder.transform.GetCodegenJobRequestMarshaller;
import software.amazon.awssdk.services.amplifyuibuilder.transform.GetComponentRequestMarshaller;
import software.amazon.awssdk.services.amplifyuibuilder.transform.GetFormRequestMarshaller;
import software.amazon.awssdk.services.amplifyuibuilder.transform.GetMetadataRequestMarshaller;
import software.amazon.awssdk.services.amplifyuibuilder.transform.GetThemeRequestMarshaller;
import software.amazon.awssdk.services.amplifyuibuilder.transform.ListCodegenJobsRequestMarshaller;
import software.amazon.awssdk.services.amplifyuibuilder.transform.ListComponentsRequestMarshaller;
import software.amazon.awssdk.services.amplifyuibuilder.transform.ListFormsRequestMarshaller;
import software.amazon.awssdk.services.amplifyuibuilder.transform.ListThemesRequestMarshaller;
import software.amazon.awssdk.services.amplifyuibuilder.transform.PutMetadataFlagRequestMarshaller;
import software.amazon.awssdk.services.amplifyuibuilder.transform.RefreshTokenRequestMarshaller;
import software.amazon.awssdk.services.amplifyuibuilder.transform.StartCodegenJobRequestMarshaller;
import software.amazon.awssdk.services.amplifyuibuilder.transform.UpdateComponentRequestMarshaller;
import software.amazon.awssdk.services.amplifyuibuilder.transform.UpdateFormRequestMarshaller;
import software.amazon.awssdk.services.amplifyuibuilder.transform.UpdateThemeRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link AmplifyUiBuilderClient}.
 *
 * @see AmplifyUiBuilderClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultAmplifyUiBuilderClient implements AmplifyUiBuilderClient {
    private static final Logger log = Logger.loggerFor(DefaultAmplifyUiBuilderClient.class);

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    private final AmplifyUiBuilderServiceClientConfiguration serviceClientConfiguration;

    protected DefaultAmplifyUiBuilderClient(AmplifyUiBuilderServiceClientConfiguration serviceClientConfiguration,
            SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Creates a new component for an Amplify app.
     * </p>
     *
     * @param createComponentRequest
     * @return Result of the CreateComponent operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         You exceeded your service quota. Service quotas, also referred to as limits, are the maximum number of
     *         service resources or operations for your Amazon Web Services account.
     * @throws ResourceConflictException
     *         The resource specified in the request conflicts with an existing resource.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.CreateComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/CreateComponent"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateComponentResponse createComponent(CreateComponentRequest createComponentRequest)
            throws ServiceQuotaExceededException, ResourceConflictException, InternalServerException, InvalidParameterException,
            AwsServiceException, SdkClientException, AmplifyUiBuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateComponentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateComponentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createComponentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AmplifyUIBuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateComponent");

            return clientHandler.execute(new ClientExecutionParams<CreateComponentRequest, CreateComponentResponse>()
                    .withOperationName("CreateComponent").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createComponentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateComponentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new form for an Amplify.
     * </p>
     *
     * @param createFormRequest
     * @return Result of the CreateForm operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         You exceeded your service quota. Service quotas, also referred to as limits, are the maximum number of
     *         service resources or operations for your Amazon Web Services account.
     * @throws ResourceConflictException
     *         The resource specified in the request conflicts with an existing resource.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.CreateForm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/CreateForm" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateFormResponse createForm(CreateFormRequest createFormRequest) throws ServiceQuotaExceededException,
            ResourceConflictException, InternalServerException, InvalidParameterException, AwsServiceException,
            SdkClientException, AmplifyUiBuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateFormResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateFormResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFormRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AmplifyUIBuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateForm");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateFormRequest, CreateFormResponse>().withOperationName("CreateForm")
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createFormRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateFormRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a theme to apply to the components in an Amplify app.
     * </p>
     *
     * @param createThemeRequest
     * @return Result of the CreateTheme operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         You exceeded your service quota. Service quotas, also referred to as limits, are the maximum number of
     *         service resources or operations for your Amazon Web Services account.
     * @throws ResourceConflictException
     *         The resource specified in the request conflicts with an existing resource.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.CreateTheme
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/CreateTheme" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateThemeResponse createTheme(CreateThemeRequest createThemeRequest) throws ServiceQuotaExceededException,
            ResourceConflictException, InternalServerException, InvalidParameterException, AwsServiceException,
            SdkClientException, AmplifyUiBuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateThemeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateThemeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createThemeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AmplifyUIBuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTheme");

            return clientHandler.execute(new ClientExecutionParams<CreateThemeRequest, CreateThemeResponse>()
                    .withOperationName("CreateTheme").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createThemeRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateThemeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a component from an Amplify app.
     * </p>
     *
     * @param deleteComponentRequest
     * @return Result of the DeleteComponent operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.DeleteComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/DeleteComponent"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteComponentResponse deleteComponent(DeleteComponentRequest deleteComponentRequest) throws InternalServerException,
            InvalidParameterException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            AmplifyUiBuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteComponentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteComponentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteComponentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AmplifyUIBuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteComponent");

            return clientHandler.execute(new ClientExecutionParams<DeleteComponentRequest, DeleteComponentResponse>()
                    .withOperationName("DeleteComponent").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteComponentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteComponentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a form from an Amplify app.
     * </p>
     *
     * @param deleteFormRequest
     * @return Result of the DeleteForm operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.DeleteForm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/DeleteForm" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteFormResponse deleteForm(DeleteFormRequest deleteFormRequest) throws InternalServerException,
            InvalidParameterException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            AmplifyUiBuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteFormResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteFormResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFormRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AmplifyUIBuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteForm");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteFormRequest, DeleteFormResponse>().withOperationName("DeleteForm")
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteFormRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteFormRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a theme from an Amplify app.
     * </p>
     *
     * @param deleteThemeRequest
     * @return Result of the DeleteTheme operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.DeleteTheme
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/DeleteTheme" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteThemeResponse deleteTheme(DeleteThemeRequest deleteThemeRequest) throws InternalServerException,
            InvalidParameterException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            AmplifyUiBuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteThemeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteThemeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteThemeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AmplifyUIBuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTheme");

            return clientHandler.execute(new ClientExecutionParams<DeleteThemeRequest, DeleteThemeResponse>()
                    .withOperationName("DeleteTheme").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteThemeRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteThemeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Exchanges an access code for a token.
     * </p>
     *
     * @param exchangeCodeForTokenRequest
     * @return Result of the ExchangeCodeForToken operation returned by the service.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.ExchangeCodeForToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ExchangeCodeForToken"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ExchangeCodeForTokenResponse exchangeCodeForToken(ExchangeCodeForTokenRequest exchangeCodeForTokenRequest)
            throws InvalidParameterException, AwsServiceException, SdkClientException, AmplifyUiBuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ExchangeCodeForTokenResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ExchangeCodeForTokenResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, exchangeCodeForTokenRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AmplifyUIBuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ExchangeCodeForToken");

            return clientHandler.execute(new ClientExecutionParams<ExchangeCodeForTokenRequest, ExchangeCodeForTokenResponse>()
                    .withOperationName("ExchangeCodeForToken").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(exchangeCodeForTokenRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ExchangeCodeForTokenRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Exports component configurations to code that is ready to integrate into an Amplify app.
     * </p>
     *
     * @param exportComponentsRequest
     * @return Result of the ExportComponents operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.ExportComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ExportComponents"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ExportComponentsResponse exportComponents(ExportComponentsRequest exportComponentsRequest)
            throws InternalServerException, InvalidParameterException, AwsServiceException, SdkClientException,
            AmplifyUiBuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ExportComponentsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ExportComponentsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, exportComponentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AmplifyUIBuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ExportComponents");

            return clientHandler.execute(new ClientExecutionParams<ExportComponentsRequest, ExportComponentsResponse>()
                    .withOperationName("ExportComponents").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(exportComponentsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ExportComponentsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Exports form configurations to code that is ready to integrate into an Amplify app.
     * </p>
     *
     * @param exportFormsRequest
     * @return Result of the ExportForms operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.ExportForms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ExportForms" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ExportFormsResponse exportForms(ExportFormsRequest exportFormsRequest) throws InternalServerException,
            InvalidParameterException, AwsServiceException, SdkClientException, AmplifyUiBuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ExportFormsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ExportFormsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, exportFormsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AmplifyUIBuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ExportForms");

            return clientHandler.execute(new ClientExecutionParams<ExportFormsRequest, ExportFormsResponse>()
                    .withOperationName("ExportForms").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(exportFormsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ExportFormsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Exports theme configurations to code that is ready to integrate into an Amplify app.
     * </p>
     *
     * @param exportThemesRequest
     * @return Result of the ExportThemes operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.ExportThemes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ExportThemes" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ExportThemesResponse exportThemes(ExportThemesRequest exportThemesRequest) throws InternalServerException,
            InvalidParameterException, AwsServiceException, SdkClientException, AmplifyUiBuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ExportThemesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ExportThemesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, exportThemesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AmplifyUIBuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ExportThemes");

            return clientHandler.execute(new ClientExecutionParams<ExportThemesRequest, ExportThemesResponse>()
                    .withOperationName("ExportThemes").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(exportThemesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ExportThemesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns an existing code generation job.
     * </p>
     *
     * @param getCodegenJobRequest
     * @return Result of the GetCodegenJob operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.GetCodegenJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/GetCodegenJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetCodegenJobResponse getCodegenJob(GetCodegenJobRequest getCodegenJobRequest) throws InternalServerException,
            InvalidParameterException, ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            AmplifyUiBuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetCodegenJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetCodegenJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCodegenJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AmplifyUIBuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCodegenJob");

            return clientHandler.execute(new ClientExecutionParams<GetCodegenJobRequest, GetCodegenJobResponse>()
                    .withOperationName("GetCodegenJob").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getCodegenJobRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetCodegenJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns an existing component for an Amplify app.
     * </p>
     *
     * @param getComponentRequest
     * @return Result of the GetComponent operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.GetComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/GetComponent" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetComponentResponse getComponent(GetComponentRequest getComponentRequest) throws InternalServerException,
            InvalidParameterException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            AmplifyUiBuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetComponentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetComponentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getComponentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AmplifyUIBuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetComponent");

            return clientHandler.execute(new ClientExecutionParams<GetComponentRequest, GetComponentResponse>()
                    .withOperationName("GetComponent").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getComponentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetComponentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns an existing form for an Amplify app.
     * </p>
     *
     * @param getFormRequest
     * @return Result of the GetForm operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.GetForm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/GetForm" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetFormResponse getForm(GetFormRequest getFormRequest) throws InternalServerException, InvalidParameterException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, AmplifyUiBuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetFormResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetFormResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getFormRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AmplifyUIBuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetForm");

            return clientHandler.execute(new ClientExecutionParams<GetFormRequest, GetFormResponse>()
                    .withOperationName("GetForm").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getFormRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new GetFormRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns existing metadata for an Amplify app.
     * </p>
     *
     * @param getMetadataRequest
     * @return Result of the GetMetadata operation returned by the service.
     * @throws UnauthorizedException
     *         You don't have permission to perform this operation.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.GetMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/GetMetadata" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetMetadataResponse getMetadata(GetMetadataRequest getMetadataRequest) throws UnauthorizedException,
            InvalidParameterException, AwsServiceException, SdkClientException, AmplifyUiBuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetMetadataResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetMetadataResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMetadataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AmplifyUIBuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMetadata");

            return clientHandler.execute(new ClientExecutionParams<GetMetadataRequest, GetMetadataResponse>()
                    .withOperationName("GetMetadata").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getMetadataRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetMetadataRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns an existing theme for an Amplify app.
     * </p>
     *
     * @param getThemeRequest
     * @return Result of the GetTheme operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.GetTheme
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/GetTheme" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetThemeResponse getTheme(GetThemeRequest getThemeRequest) throws InternalServerException, InvalidParameterException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, AmplifyUiBuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetThemeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetThemeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getThemeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AmplifyUIBuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTheme");

            return clientHandler.execute(new ClientExecutionParams<GetThemeRequest, GetThemeResponse>()
                    .withOperationName("GetTheme").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getThemeRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new GetThemeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of code generation jobs for a specified Amplify app and backend environment.
     * </p>
     *
     * @param listCodegenJobsRequest
     * @return Result of the ListCodegenJobs operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.ListCodegenJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ListCodegenJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListCodegenJobsResponse listCodegenJobs(ListCodegenJobsRequest listCodegenJobsRequest) throws InternalServerException,
            InvalidParameterException, ThrottlingException, AwsServiceException, SdkClientException, AmplifyUiBuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListCodegenJobsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListCodegenJobsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCodegenJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AmplifyUIBuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCodegenJobs");

            return clientHandler.execute(new ClientExecutionParams<ListCodegenJobsRequest, ListCodegenJobsResponse>()
                    .withOperationName("ListCodegenJobs").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listCodegenJobsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListCodegenJobsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of components for a specified Amplify app and backend environment.
     * </p>
     *
     * @param listComponentsRequest
     * @return Result of the ListComponents operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.ListComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ListComponents"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListComponentsResponse listComponents(ListComponentsRequest listComponentsRequest) throws InternalServerException,
            InvalidParameterException, AwsServiceException, SdkClientException, AmplifyUiBuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListComponentsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListComponentsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listComponentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AmplifyUIBuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListComponents");

            return clientHandler.execute(new ClientExecutionParams<ListComponentsRequest, ListComponentsResponse>()
                    .withOperationName("ListComponents").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listComponentsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListComponentsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of forms for a specified Amplify app and backend environment.
     * </p>
     *
     * @param listFormsRequest
     * @return Result of the ListForms operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.ListForms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ListForms" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListFormsResponse listForms(ListFormsRequest listFormsRequest) throws InternalServerException,
            InvalidParameterException, AwsServiceException, SdkClientException, AmplifyUiBuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListFormsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListFormsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFormsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AmplifyUIBuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListForms");

            return clientHandler.execute(new ClientExecutionParams<ListFormsRequest, ListFormsResponse>()
                    .withOperationName("ListForms").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listFormsRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new ListFormsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of themes for a specified Amplify app and backend environment.
     * </p>
     *
     * @param listThemesRequest
     * @return Result of the ListThemes operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.ListThemes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ListThemes" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListThemesResponse listThemes(ListThemesRequest listThemesRequest) throws InternalServerException,
            InvalidParameterException, AwsServiceException, SdkClientException, AmplifyUiBuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListThemesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListThemesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listThemesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AmplifyUIBuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListThemes");

            return clientHandler
                    .execute(new ClientExecutionParams<ListThemesRequest, ListThemesResponse>().withOperationName("ListThemes")
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listThemesRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListThemesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Stores the metadata information about a feature on a form.
     * </p>
     *
     * @param putMetadataFlagRequest
     * @return Result of the PutMetadataFlag operation returned by the service.
     * @throws UnauthorizedException
     *         You don't have permission to perform this operation.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.PutMetadataFlag
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/PutMetadataFlag"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PutMetadataFlagResponse putMetadataFlag(PutMetadataFlagRequest putMetadataFlagRequest) throws UnauthorizedException,
            InvalidParameterException, AwsServiceException, SdkClientException, AmplifyUiBuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutMetadataFlagResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                PutMetadataFlagResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putMetadataFlagRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AmplifyUIBuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutMetadataFlag");

            return clientHandler.execute(new ClientExecutionParams<PutMetadataFlagRequest, PutMetadataFlagResponse>()
                    .withOperationName("PutMetadataFlag").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(putMetadataFlagRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PutMetadataFlagRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Refreshes a previously issued access token that might have expired.
     * </p>
     *
     * @param refreshTokenRequest
     * @return Result of the RefreshToken operation returned by the service.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.RefreshToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/RefreshToken" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public RefreshTokenResponse refreshToken(RefreshTokenRequest refreshTokenRequest) throws InvalidParameterException,
            AwsServiceException, SdkClientException, AmplifyUiBuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RefreshTokenResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                RefreshTokenResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, refreshTokenRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AmplifyUIBuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RefreshToken");

            return clientHandler.execute(new ClientExecutionParams<RefreshTokenRequest, RefreshTokenResponse>()
                    .withOperationName("RefreshToken").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(refreshTokenRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new RefreshTokenRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts a code generation job for for a specified Amplify app and backend environment.
     * </p>
     *
     * @param startCodegenJobRequest
     * @return Result of the StartCodegenJob operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.StartCodegenJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/StartCodegenJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartCodegenJobResponse startCodegenJob(StartCodegenJobRequest startCodegenJobRequest) throws InternalServerException,
            InvalidParameterException, ThrottlingException, AwsServiceException, SdkClientException, AmplifyUiBuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartCodegenJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                StartCodegenJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startCodegenJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AmplifyUIBuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartCodegenJob");

            return clientHandler.execute(new ClientExecutionParams<StartCodegenJobRequest, StartCodegenJobResponse>()
                    .withOperationName("StartCodegenJob").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(startCodegenJobRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StartCodegenJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an existing component.
     * </p>
     *
     * @param updateComponentRequest
     * @return Result of the UpdateComponent operation returned by the service.
     * @throws ResourceConflictException
     *         The resource specified in the request conflicts with an existing resource.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.UpdateComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/UpdateComponent"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateComponentResponse updateComponent(UpdateComponentRequest updateComponentRequest)
            throws ResourceConflictException, InternalServerException, InvalidParameterException, AwsServiceException,
            SdkClientException, AmplifyUiBuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateComponentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateComponentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateComponentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AmplifyUIBuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateComponent");

            return clientHandler.execute(new ClientExecutionParams<UpdateComponentRequest, UpdateComponentResponse>()
                    .withOperationName("UpdateComponent").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateComponentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateComponentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an existing form.
     * </p>
     *
     * @param updateFormRequest
     * @return Result of the UpdateForm operation returned by the service.
     * @throws ResourceConflictException
     *         The resource specified in the request conflicts with an existing resource.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.UpdateForm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/UpdateForm" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateFormResponse updateForm(UpdateFormRequest updateFormRequest) throws ResourceConflictException,
            InternalServerException, InvalidParameterException, AwsServiceException, SdkClientException,
            AmplifyUiBuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateFormResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateFormResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateFormRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AmplifyUIBuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateForm");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateFormRequest, UpdateFormResponse>().withOperationName("UpdateForm")
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateFormRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateFormRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an existing theme.
     * </p>
     *
     * @param updateThemeRequest
     * @return Result of the UpdateTheme operation returned by the service.
     * @throws ResourceConflictException
     *         The resource specified in the request conflicts with an existing resource.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.UpdateTheme
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/UpdateTheme" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateThemeResponse updateTheme(UpdateThemeRequest updateThemeRequest) throws ResourceConflictException,
            InternalServerException, InvalidParameterException, AwsServiceException, SdkClientException,
            AmplifyUiBuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateThemeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateThemeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateThemeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AmplifyUIBuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateTheme");

            return clientHandler.execute(new ClientExecutionParams<UpdateThemeRequest, UpdateThemeResponse>()
                    .withOperationName("UpdateTheme").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateThemeRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateThemeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(AmplifyUiBuilderException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidParameterException")
                                .exceptionBuilderSupplier(InvalidParameterException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnauthorizedException")
                                .exceptionBuilderSupplier(UnauthorizedException::builder).httpStatusCode(401).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException")
                                .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(402).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerException")
                                .exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceConflictException")
                                .exceptionBuilderSupplier(ResourceConflictException::builder).httpStatusCode(409).build());
    }

    @Override
    public final AmplifyUiBuilderServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
