/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifyuibuilder.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.amplifyuibuilder.AmplifyUiBuilderClient;
import software.amazon.awssdk.services.amplifyuibuilder.model.ExportThemesRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.ExportThemesResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.Theme;

public class ExportThemesIterable
implements SdkIterable<ExportThemesResponse> {
    private final AmplifyUiBuilderClient client;
    private final ExportThemesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ExportThemesIterable(AmplifyUiBuilderClient client, ExportThemesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ExportThemesResponseFetcher();
    }

    public Iterator<ExportThemesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Theme> entities() {
        Function<ExportThemesResponse, Iterator> getIterator = response -> {
            if (response != null && response.entities() != null) {
                return response.entities().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ExportThemesResponseFetcher
    implements SyncPageFetcher<ExportThemesResponse> {
        private ExportThemesResponseFetcher() {
        }

        public boolean hasNextPage(ExportThemesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ExportThemesResponse nextPage(ExportThemesResponse previousPage) {
            if (previousPage == null) {
                return ExportThemesIterable.this.client.exportThemes(ExportThemesIterable.this.firstRequest);
            }
            return ExportThemesIterable.this.client.exportThemes((ExportThemesRequest)((Object)ExportThemesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

