/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.amplifyuibuilder.model.ActionParameters;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ComponentEvent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ComponentEvent> {
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("action").getter(ComponentEvent.getter(ComponentEvent::action)).setter(ComponentEvent.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()}).build();
    private static final SdkField<ActionParameters> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("parameters").getter(ComponentEvent.getter(ComponentEvent::parameters)).setter(ComponentEvent.setter(Builder::parameters)).constructor(ActionParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build()}).build();
    private static final SdkField<String> BINDING_EVENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("bindingEvent").getter(ComponentEvent.getter(ComponentEvent::bindingEvent)).setter(ComponentEvent.setter(Builder::bindingEvent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bindingEvent").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, PARAMETERS_FIELD, BINDING_EVENT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String action;
    private final ActionParameters parameters;
    private final String bindingEvent;

    private ComponentEvent(BuilderImpl builder) {
        this.action = builder.action;
        this.parameters = builder.parameters;
        this.bindingEvent = builder.bindingEvent;
    }

    public final String action() {
        return this.action;
    }

    public final ActionParameters parameters() {
        return this.parameters;
    }

    public final String bindingEvent() {
        return this.bindingEvent;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.action());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.bindingEvent());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentEvent)) {
            return false;
        }
        ComponentEvent other = (ComponentEvent)obj;
        return Objects.equals(this.action(), other.action()) && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.bindingEvent(), other.bindingEvent());
    }

    public final String toString() {
        return ToString.builder((String)"ComponentEvent").add("Action", (Object)this.action()).add("Parameters", (Object)this.parameters()).add("BindingEvent", (Object)this.bindingEvent()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "action": {
                return Optional.ofNullable(clazz.cast(this.action()));
            }
            case "parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "bindingEvent": {
                return Optional.ofNullable(clazz.cast(this.bindingEvent()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComponentEvent, T> g) {
        return obj -> g.apply((ComponentEvent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String action;
        private ActionParameters parameters;
        private String bindingEvent;

        private BuilderImpl() {
        }

        private BuilderImpl(ComponentEvent model) {
            this.action(model.action);
            this.parameters(model.parameters);
            this.bindingEvent(model.bindingEvent);
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        public final ActionParameters.Builder getParameters() {
            return this.parameters != null ? this.parameters.toBuilder() : null;
        }

        public final void setParameters(ActionParameters.BuilderImpl parameters) {
            this.parameters = parameters != null ? parameters.build() : null;
        }

        @Override
        public final Builder parameters(ActionParameters parameters) {
            this.parameters = parameters;
            return this;
        }

        public final String getBindingEvent() {
            return this.bindingEvent;
        }

        public final void setBindingEvent(String bindingEvent) {
            this.bindingEvent = bindingEvent;
        }

        @Override
        public final Builder bindingEvent(String bindingEvent) {
            this.bindingEvent = bindingEvent;
            return this;
        }

        public ComponentEvent build() {
            return new ComponentEvent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ComponentEvent> {
        public Builder action(String var1);

        public Builder parameters(ActionParameters var1);

        default public Builder parameters(Consumer<ActionParameters.Builder> parameters) {
            return this.parameters((ActionParameters)((ActionParameters.Builder)ActionParameters.builder().applyMutation(parameters)).build());
        }

        public Builder bindingEvent(String var1);
    }
}

