/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the data binding configuration for a value map.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ValueMappings implements SdkPojo, Serializable, ToCopyableBuilder<ValueMappings.Builder, ValueMappings> {
    private static final SdkField<List<ValueMapping>> VALUES_FIELD = SdkField
            .<List<ValueMapping>> builder(MarshallingType.LIST)
            .memberName("values")
            .getter(getter(ValueMappings::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("values").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ValueMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(ValueMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, FormInputBindingPropertiesValue>> BINDING_PROPERTIES_FIELD = SdkField
            .<Map<String, FormInputBindingPropertiesValue>> builder(MarshallingType.MAP)
            .memberName("bindingProperties")
            .getter(getter(ValueMappings::bindingProperties))
            .setter(setter(Builder::bindingProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bindingProperties").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<FormInputBindingPropertiesValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(FormInputBindingPropertiesValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUES_FIELD,
            BINDING_PROPERTIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<ValueMapping> values;

    private final Map<String, FormInputBindingPropertiesValue> bindingProperties;

    private ValueMappings(BuilderImpl builder) {
        this.values = builder.values;
        this.bindingProperties = builder.bindingProperties;
    }

    /**
     * For responses, this returns true if the service returned a value for the Values property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasValues() {
        return values != null && !(values instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The value and display value pairs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValues} method.
     * </p>
     * 
     * @return The value and display value pairs.
     */
    public final List<ValueMapping> values() {
        return values;
    }

    /**
     * For responses, this returns true if the service returned a value for the BindingProperties property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBindingProperties() {
        return bindingProperties != null && !(bindingProperties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The information to bind fields to data at runtime.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBindingProperties} method.
     * </p>
     * 
     * @return The information to bind fields to data at runtime.
     */
    public final Map<String, FormInputBindingPropertiesValue> bindingProperties() {
        return bindingProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasValues() ? values() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasBindingProperties() ? bindingProperties() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValueMappings)) {
            return false;
        }
        ValueMappings other = (ValueMappings) obj;
        return hasValues() == other.hasValues() && Objects.equals(values(), other.values())
                && hasBindingProperties() == other.hasBindingProperties()
                && Objects.equals(bindingProperties(), other.bindingProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ValueMappings").add("Values", hasValues() ? values() : null)
                .add("BindingProperties", hasBindingProperties() ? bindingProperties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "values":
            return Optional.ofNullable(clazz.cast(values()));
        case "bindingProperties":
            return Optional.ofNullable(clazz.cast(bindingProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ValueMappings, T> g) {
        return obj -> g.apply((ValueMappings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ValueMappings> {
        /**
         * <p>
         * The value and display value pairs.
         * </p>
         * 
         * @param values
         *        The value and display value pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<ValueMapping> values);

        /**
         * <p>
         * The value and display value pairs.
         * </p>
         * 
         * @param values
         *        The value and display value pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(ValueMapping... values);

        /**
         * <p>
         * The value and display value pairs.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.amplifyuibuilder.model.ValueMapping.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.amplifyuibuilder.model.ValueMapping#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.amplifyuibuilder.model.ValueMapping.Builder#build()} is called
         * immediately and its result is passed to {@link #values(List<ValueMapping>)}.
         * 
         * @param values
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.amplifyuibuilder.model.ValueMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #values(java.util.Collection<ValueMapping>)
         */
        Builder values(Consumer<ValueMapping.Builder>... values);

        /**
         * <p>
         * The information to bind fields to data at runtime.
         * </p>
         * 
         * @param bindingProperties
         *        The information to bind fields to data at runtime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bindingProperties(Map<String, FormInputBindingPropertiesValue> bindingProperties);
    }

    static final class BuilderImpl implements Builder {
        private List<ValueMapping> values = DefaultSdkAutoConstructList.getInstance();

        private Map<String, FormInputBindingPropertiesValue> bindingProperties = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ValueMappings model) {
            values(model.values);
            bindingProperties(model.bindingProperties);
        }

        public final List<ValueMapping.Builder> getValues() {
            List<ValueMapping.Builder> result = ValueMappingListCopier.copyToBuilder(this.values);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValues(Collection<ValueMapping.BuilderImpl> values) {
            this.values = ValueMappingListCopier.copyFromBuilder(values);
        }

        @Override
        public final Builder values(Collection<ValueMapping> values) {
            this.values = ValueMappingListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(ValueMapping... values) {
            values(Arrays.asList(values));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(Consumer<ValueMapping.Builder>... values) {
            values(Stream.of(values).map(c -> ValueMapping.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, FormInputBindingPropertiesValue.Builder> getBindingProperties() {
            Map<String, FormInputBindingPropertiesValue.Builder> result = FormInputBindingPropertiesCopier
                    .copyToBuilder(this.bindingProperties);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setBindingProperties(Map<String, FormInputBindingPropertiesValue.BuilderImpl> bindingProperties) {
            this.bindingProperties = FormInputBindingPropertiesCopier.copyFromBuilder(bindingProperties);
        }

        @Override
        public final Builder bindingProperties(Map<String, FormInputBindingPropertiesValue> bindingProperties) {
            this.bindingProperties = FormInputBindingPropertiesCopier.copy(bindingProperties);
            return this;
        }

        @Override
        public ValueMappings build() {
            return new ValueMappings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
