/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMetadataResponse extends AmplifyUiBuilderResponse implements
        ToCopyableBuilder<GetMetadataResponse.Builder, GetMetadataResponse> {
    private static final SdkField<Map<String, String>> FEATURES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("features")
            .getter(getter(GetMetadataResponse::features))
            .setter(setter(Builder::features))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("features").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FEATURES_FIELD));

    private final Map<String, String> features;

    private GetMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.features = builder.features;
    }

    /**
     * For responses, this returns true if the service returned a value for the Features property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFeatures() {
        return features != null && !(features instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Represents the configuration settings for the features metadata.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFeatures} method.
     * </p>
     * 
     * @return Represents the configuration settings for the features metadata.
     */
    public final Map<String, String> features() {
        return features;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFeatures() ? features() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMetadataResponse)) {
            return false;
        }
        GetMetadataResponse other = (GetMetadataResponse) obj;
        return hasFeatures() == other.hasFeatures() && Objects.equals(features(), other.features());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMetadataResponse").add("Features", hasFeatures() ? features() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "features":
            return Optional.ofNullable(clazz.cast(features()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMetadataResponse, T> g) {
        return obj -> g.apply((GetMetadataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AmplifyUiBuilderResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetMetadataResponse> {
        /**
         * <p>
         * Represents the configuration settings for the features metadata.
         * </p>
         * 
         * @param features
         *        Represents the configuration settings for the features metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder features(Map<String, String> features);
    }

    static final class BuilderImpl extends AmplifyUiBuilderResponse.BuilderImpl implements Builder {
        private Map<String, String> features = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetMetadataResponse model) {
            super(model);
            features(model.features);
        }

        public final Map<String, String> getFeatures() {
            if (features instanceof SdkAutoConstructMap) {
                return null;
            }
            return features;
        }

        public final void setFeatures(Map<String, String> features) {
            this.features = FeaturesMapCopier.copy(features);
        }

        @Override
        public final Builder features(Map<String, String> features) {
            this.features = FeaturesMapCopier.copy(features);
            return this;
        }

        @Override
        public GetMetadataResponse build() {
            return new GetMetadataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
