/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifyuibuilder.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.amplifyuibuilder.AmplifyUiBuilderAsyncClient;
import software.amazon.awssdk.services.amplifyuibuilder.model.ExportThemesRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.ExportThemesResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.Theme;

public class ExportThemesPublisher
implements SdkPublisher<ExportThemesResponse> {
    private final AmplifyUiBuilderAsyncClient client;
    private final ExportThemesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ExportThemesPublisher(AmplifyUiBuilderAsyncClient client, ExportThemesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ExportThemesPublisher(AmplifyUiBuilderAsyncClient client, ExportThemesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ExportThemesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ExportThemesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Theme> entities() {
        Function<ExportThemesResponse, Iterator> getIterator = response -> {
            if (response != null && response.entities() != null) {
                return response.entities().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ExportThemesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ExportThemesResponseFetcher
    implements AsyncPageFetcher<ExportThemesResponse> {
        private ExportThemesResponseFetcher() {
        }

        public boolean hasNextPage(ExportThemesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ExportThemesResponse> nextPage(ExportThemesResponse previousPage) {
            if (previousPage == null) {
                return ExportThemesPublisher.this.client.exportThemes(ExportThemesPublisher.this.firstRequest);
            }
            return ExportThemesPublisher.this.client.exportThemes((ExportThemesRequest)((Object)ExportThemesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

