/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FormDataSourceType {
    DATA_STORE("DataStore"),
    CUSTOM("Custom"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FormDataSourceType> VALUE_MAP;
    private final String value;

    private FormDataSourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FormDataSourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FormDataSourceType> knownValues() {
        EnumSet<FormDataSourceType> knownValues = EnumSet.allOf(FormDataSourceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FormDataSourceType.class, FormDataSourceType::toString);
    }
}

