/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.amplifyuibuilder.model.AmplifyUiBuilderRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.CreateThemeData;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateThemeRequest
extends AmplifyUiBuilderRequest
implements ToCopyableBuilder<Builder, CreateThemeRequest> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appId").getter(CreateThemeRequest.getter(CreateThemeRequest::appId)).setter(CreateThemeRequest.setter(Builder::appId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("appId").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateThemeRequest.getter(CreateThemeRequest::clientToken)).setter(CreateThemeRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentName").getter(CreateThemeRequest.getter(CreateThemeRequest::environmentName)).setter(CreateThemeRequest.setter(Builder::environmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("environmentName").build()}).build();
    private static final SdkField<CreateThemeData> THEME_TO_CREATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("themeToCreate").getter(CreateThemeRequest.getter(CreateThemeRequest::themeToCreate)).setter(CreateThemeRequest.setter(Builder::themeToCreate)).constructor(CreateThemeData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("themeToCreate").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD, CLIENT_TOKEN_FIELD, ENVIRONMENT_NAME_FIELD, THEME_TO_CREATE_FIELD));
    private final String appId;
    private final String clientToken;
    private final String environmentName;
    private final CreateThemeData themeToCreate;

    private CreateThemeRequest(BuilderImpl builder) {
        super(builder);
        this.appId = builder.appId;
        this.clientToken = builder.clientToken;
        this.environmentName = builder.environmentName;
        this.themeToCreate = builder.themeToCreate;
    }

    public final String appId() {
        return this.appId;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String environmentName() {
        return this.environmentName;
    }

    public final CreateThemeData themeToCreate() {
        return this.themeToCreate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.themeToCreate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateThemeRequest)) {
            return false;
        }
        CreateThemeRequest other = (CreateThemeRequest)((Object)obj);
        return Objects.equals(this.appId(), other.appId()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.environmentName(), other.environmentName()) && Objects.equals(this.themeToCreate(), other.themeToCreate());
    }

    public final String toString() {
        return ToString.builder((String)"CreateThemeRequest").add("AppId", (Object)this.appId()).add("ClientToken", (Object)this.clientToken()).add("EnvironmentName", (Object)this.environmentName()).add("ThemeToCreate", (Object)this.themeToCreate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appId": {
                return Optional.ofNullable(clazz.cast(this.appId()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "environmentName": {
                return Optional.ofNullable(clazz.cast(this.environmentName()));
            }
            case "themeToCreate": {
                return Optional.ofNullable(clazz.cast(this.themeToCreate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateThemeRequest, T> g) {
        return obj -> g.apply((CreateThemeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AmplifyUiBuilderRequest.BuilderImpl
    implements Builder {
        private String appId;
        private String clientToken;
        private String environmentName;
        private CreateThemeData themeToCreate;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateThemeRequest model) {
            super(model);
            this.appId(model.appId);
            this.clientToken(model.clientToken);
            this.environmentName(model.environmentName);
            this.themeToCreate(model.themeToCreate);
        }

        public final String getAppId() {
            return this.appId;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getEnvironmentName() {
            return this.environmentName;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final CreateThemeData.Builder getThemeToCreate() {
            return this.themeToCreate != null ? this.themeToCreate.toBuilder() : null;
        }

        public final void setThemeToCreate(CreateThemeData.BuilderImpl themeToCreate) {
            this.themeToCreate = themeToCreate != null ? themeToCreate.build() : null;
        }

        @Override
        public final Builder themeToCreate(CreateThemeData themeToCreate) {
            this.themeToCreate = themeToCreate;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateThemeRequest build() {
            return new CreateThemeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AmplifyUiBuilderRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateThemeRequest> {
        public Builder appId(String var1);

        public Builder clientToken(String var1);

        public Builder environmentName(String var1);

        public Builder themeToCreate(CreateThemeData var1);

        default public Builder themeToCreate(Consumer<CreateThemeData.Builder> themeToCreate) {
            return this.themeToCreate((CreateThemeData)((CreateThemeData.Builder)CreateThemeData.builder().applyMutation(themeToCreate)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

