/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.amplifyuibuilder.model.AmplifyUiBuilderRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.RefreshTokenRequestBody;
import software.amazon.awssdk.services.amplifyuibuilder.model.TokenProviders;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RefreshTokenRequest
extends AmplifyUiBuilderRequest
implements ToCopyableBuilder<Builder, RefreshTokenRequest> {
    private static final SdkField<String> PROVIDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("provider").getter(RefreshTokenRequest.getter(RefreshTokenRequest::providerAsString)).setter(RefreshTokenRequest.setter(Builder::provider)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("provider").build()}).build();
    private static final SdkField<RefreshTokenRequestBody> REFRESH_TOKEN_BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("refreshTokenBody").getter(RefreshTokenRequest.getter(RefreshTokenRequest::refreshTokenBody)).setter(RefreshTokenRequest.setter(Builder::refreshTokenBody)).constructor(RefreshTokenRequestBody::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("refreshTokenBody").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVIDER_FIELD, REFRESH_TOKEN_BODY_FIELD));
    private final String provider;
    private final RefreshTokenRequestBody refreshTokenBody;

    private RefreshTokenRequest(BuilderImpl builder) {
        super(builder);
        this.provider = builder.provider;
        this.refreshTokenBody = builder.refreshTokenBody;
    }

    public final TokenProviders provider() {
        return TokenProviders.fromValue(this.provider);
    }

    public final String providerAsString() {
        return this.provider;
    }

    public final RefreshTokenRequestBody refreshTokenBody() {
        return this.refreshTokenBody;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.providerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.refreshTokenBody());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RefreshTokenRequest)) {
            return false;
        }
        RefreshTokenRequest other = (RefreshTokenRequest)((Object)obj);
        return Objects.equals(this.providerAsString(), other.providerAsString()) && Objects.equals(this.refreshTokenBody(), other.refreshTokenBody());
    }

    public final String toString() {
        return ToString.builder((String)"RefreshTokenRequest").add("Provider", (Object)this.providerAsString()).add("RefreshTokenBody", (Object)this.refreshTokenBody()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "provider": {
                return Optional.ofNullable(clazz.cast(this.providerAsString()));
            }
            case "refreshTokenBody": {
                return Optional.ofNullable(clazz.cast(this.refreshTokenBody()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RefreshTokenRequest, T> g) {
        return obj -> g.apply((RefreshTokenRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AmplifyUiBuilderRequest.BuilderImpl
    implements Builder {
        private String provider;
        private RefreshTokenRequestBody refreshTokenBody;

        private BuilderImpl() {
        }

        private BuilderImpl(RefreshTokenRequest model) {
            super(model);
            this.provider(model.provider);
            this.refreshTokenBody(model.refreshTokenBody);
        }

        public final String getProvider() {
            return this.provider;
        }

        public final void setProvider(String provider) {
            this.provider = provider;
        }

        @Override
        @Transient
        public final Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        @Override
        @Transient
        public final Builder provider(TokenProviders provider) {
            this.provider(provider == null ? null : provider.toString());
            return this;
        }

        public final RefreshTokenRequestBody.Builder getRefreshTokenBody() {
            return this.refreshTokenBody != null ? this.refreshTokenBody.toBuilder() : null;
        }

        public final void setRefreshTokenBody(RefreshTokenRequestBody.BuilderImpl refreshTokenBody) {
            this.refreshTokenBody = refreshTokenBody != null ? refreshTokenBody.build() : null;
        }

        @Override
        @Transient
        public final Builder refreshTokenBody(RefreshTokenRequestBody refreshTokenBody) {
            this.refreshTokenBody = refreshTokenBody;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RefreshTokenRequest build() {
            return new RefreshTokenRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AmplifyUiBuilderRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RefreshTokenRequest> {
        public Builder provider(String var1);

        public Builder provider(TokenProviders var1);

        public Builder refreshTokenBody(RefreshTokenRequestBody var1);

        default public Builder refreshTokenBody(Consumer<RefreshTokenRequestBody.Builder> refreshTokenBody) {
            return this.refreshTokenBody((RefreshTokenRequestBody)((RefreshTokenRequestBody.Builder)RefreshTokenRequestBody.builder().applyMutation(refreshTokenBody)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

