/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifybackend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.amplifybackend.model.DeliveryMethod;
import software.amazon.awssdk.services.amplifybackend.model.EmailSettings;
import software.amazon.awssdk.services.amplifybackend.model.SmsSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateBackendAuthForgotPasswordConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UpdateBackendAuthForgotPasswordConfig> {
    private static final SdkField<String> DELIVERY_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeliveryMethod").getter(UpdateBackendAuthForgotPasswordConfig.getter(UpdateBackendAuthForgotPasswordConfig::deliveryMethodAsString)).setter(UpdateBackendAuthForgotPasswordConfig.setter(Builder::deliveryMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deliveryMethod").build()}).build();
    private static final SdkField<EmailSettings> EMAIL_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EmailSettings").getter(UpdateBackendAuthForgotPasswordConfig.getter(UpdateBackendAuthForgotPasswordConfig::emailSettings)).setter(UpdateBackendAuthForgotPasswordConfig.setter(Builder::emailSettings)).constructor(EmailSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("emailSettings").build()}).build();
    private static final SdkField<SmsSettings> SMS_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SmsSettings").getter(UpdateBackendAuthForgotPasswordConfig.getter(UpdateBackendAuthForgotPasswordConfig::smsSettings)).setter(UpdateBackendAuthForgotPasswordConfig.setter(Builder::smsSettings)).constructor(SmsSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("smsSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELIVERY_METHOD_FIELD, EMAIL_SETTINGS_FIELD, SMS_SETTINGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String deliveryMethod;
    private final EmailSettings emailSettings;
    private final SmsSettings smsSettings;

    private UpdateBackendAuthForgotPasswordConfig(BuilderImpl builder) {
        this.deliveryMethod = builder.deliveryMethod;
        this.emailSettings = builder.emailSettings;
        this.smsSettings = builder.smsSettings;
    }

    public final DeliveryMethod deliveryMethod() {
        return DeliveryMethod.fromValue(this.deliveryMethod);
    }

    public final String deliveryMethodAsString() {
        return this.deliveryMethod;
    }

    public final EmailSettings emailSettings() {
        return this.emailSettings;
    }

    public final SmsSettings smsSettings() {
        return this.smsSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.smsSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBackendAuthForgotPasswordConfig)) {
            return false;
        }
        UpdateBackendAuthForgotPasswordConfig other = (UpdateBackendAuthForgotPasswordConfig)obj;
        return Objects.equals(this.deliveryMethodAsString(), other.deliveryMethodAsString()) && Objects.equals(this.emailSettings(), other.emailSettings()) && Objects.equals(this.smsSettings(), other.smsSettings());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateBackendAuthForgotPasswordConfig").add("DeliveryMethod", (Object)this.deliveryMethodAsString()).add("EmailSettings", (Object)this.emailSettings()).add("SmsSettings", (Object)this.smsSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeliveryMethod": {
                return Optional.ofNullable(clazz.cast(this.deliveryMethodAsString()));
            }
            case "EmailSettings": {
                return Optional.ofNullable(clazz.cast(this.emailSettings()));
            }
            case "SmsSettings": {
                return Optional.ofNullable(clazz.cast(this.smsSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateBackendAuthForgotPasswordConfig, T> g) {
        return obj -> g.apply((UpdateBackendAuthForgotPasswordConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String deliveryMethod;
        private EmailSettings emailSettings;
        private SmsSettings smsSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBackendAuthForgotPasswordConfig model) {
            this.deliveryMethod(model.deliveryMethod);
            this.emailSettings(model.emailSettings);
            this.smsSettings(model.smsSettings);
        }

        public final String getDeliveryMethod() {
            return this.deliveryMethod;
        }

        public final void setDeliveryMethod(String deliveryMethod) {
            this.deliveryMethod = deliveryMethod;
        }

        @Override
        public final Builder deliveryMethod(String deliveryMethod) {
            this.deliveryMethod = deliveryMethod;
            return this;
        }

        @Override
        public final Builder deliveryMethod(DeliveryMethod deliveryMethod) {
            this.deliveryMethod(deliveryMethod == null ? null : deliveryMethod.toString());
            return this;
        }

        public final EmailSettings.Builder getEmailSettings() {
            return this.emailSettings != null ? this.emailSettings.toBuilder() : null;
        }

        public final void setEmailSettings(EmailSettings.BuilderImpl emailSettings) {
            this.emailSettings = emailSettings != null ? emailSettings.build() : null;
        }

        @Override
        public final Builder emailSettings(EmailSettings emailSettings) {
            this.emailSettings = emailSettings;
            return this;
        }

        public final SmsSettings.Builder getSmsSettings() {
            return this.smsSettings != null ? this.smsSettings.toBuilder() : null;
        }

        public final void setSmsSettings(SmsSettings.BuilderImpl smsSettings) {
            this.smsSettings = smsSettings != null ? smsSettings.build() : null;
        }

        @Override
        public final Builder smsSettings(SmsSettings smsSettings) {
            this.smsSettings = smsSettings;
            return this;
        }

        public UpdateBackendAuthForgotPasswordConfig build() {
            return new UpdateBackendAuthForgotPasswordConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UpdateBackendAuthForgotPasswordConfig> {
        public Builder deliveryMethod(String var1);

        public Builder deliveryMethod(DeliveryMethod var1);

        public Builder emailSettings(EmailSettings var1);

        default public Builder emailSettings(Consumer<EmailSettings.Builder> emailSettings) {
            return this.emailSettings((EmailSettings)((EmailSettings.Builder)EmailSettings.builder().applyMutation(emailSettings)).build());
        }

        public Builder smsSettings(SmsSettings var1);

        default public Builder smsSettings(Consumer<SmsSettings.Builder> smsSettings) {
            return this.smsSettings((SmsSettings)((SmsSettings.Builder)SmsSettings.builder().applyMutation(smsSettings)).build());
        }
    }
}

