/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifybackend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.amplifybackend.model.AmplifyBackendResponse;
import software.amazon.awssdk.services.amplifybackend.model.ListOfS3BucketInfoCopier;
import software.amazon.awssdk.services.amplifybackend.model.S3BucketInfo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListS3BucketsResponse
extends AmplifyBackendResponse
implements ToCopyableBuilder<Builder, ListS3BucketsResponse> {
    private static final SdkField<List<S3BucketInfo>> BUCKETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Buckets").getter(ListS3BucketsResponse.getter(ListS3BucketsResponse::buckets)).setter(ListS3BucketsResponse.setter(Builder::buckets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buckets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(S3BucketInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListS3BucketsResponse.getter(ListS3BucketsResponse::nextToken)).setter(ListS3BucketsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKETS_FIELD, NEXT_TOKEN_FIELD));
    private final List<S3BucketInfo> buckets;
    private final String nextToken;

    private ListS3BucketsResponse(BuilderImpl builder) {
        super(builder);
        this.buckets = builder.buckets;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasBuckets() {
        return this.buckets != null && !(this.buckets instanceof SdkAutoConstructList);
    }

    public final List<S3BucketInfo> buckets() {
        return this.buckets;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBuckets() ? this.buckets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListS3BucketsResponse)) {
            return false;
        }
        ListS3BucketsResponse other = (ListS3BucketsResponse)((Object)obj);
        return this.hasBuckets() == other.hasBuckets() && Objects.equals(this.buckets(), other.buckets()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListS3BucketsResponse").add("Buckets", this.hasBuckets() ? this.buckets() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Buckets": {
                return Optional.ofNullable(clazz.cast(this.buckets()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListS3BucketsResponse, T> g) {
        return obj -> g.apply((ListS3BucketsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AmplifyBackendResponse.BuilderImpl
    implements Builder {
        private List<S3BucketInfo> buckets = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListS3BucketsResponse model) {
            super(model);
            this.buckets(model.buckets);
            this.nextToken(model.nextToken);
        }

        public final List<S3BucketInfo.Builder> getBuckets() {
            List<S3BucketInfo.Builder> result = ListOfS3BucketInfoCopier.copyToBuilder(this.buckets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBuckets(Collection<S3BucketInfo.BuilderImpl> buckets) {
            this.buckets = ListOfS3BucketInfoCopier.copyFromBuilder(buckets);
        }

        @Override
        public final Builder buckets(Collection<S3BucketInfo> buckets) {
            this.buckets = ListOfS3BucketInfoCopier.copy(buckets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder buckets(S3BucketInfo ... buckets) {
            this.buckets(Arrays.asList(buckets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder buckets(Consumer<S3BucketInfo.Builder> ... buckets) {
            this.buckets(Stream.of(buckets).map(c -> (S3BucketInfo)((S3BucketInfo.Builder)S3BucketInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListS3BucketsResponse build() {
            return new ListS3BucketsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AmplifyBackendResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListS3BucketsResponse> {
        public Builder buckets(Collection<S3BucketInfo> var1);

        public Builder buckets(S3BucketInfo ... var1);

        public Builder buckets(Consumer<S3BucketInfo.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

