/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplify.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.amplify.model.AmplifyRequest;
import software.amazon.awssdk.services.amplify.model.JobType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartJobRequest
extends AmplifyRequest
implements ToCopyableBuilder<Builder, StartJobRequest> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartJobRequest.getter(StartJobRequest::appId)).setter(StartJobRequest.setter(Builder::appId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("appId").build()}).build();
    private static final SdkField<String> BRANCH_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartJobRequest.getter(StartJobRequest::branchName)).setter(StartJobRequest.setter(Builder::branchName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("branchName").build()}).build();
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartJobRequest.getter(StartJobRequest::jobId)).setter(StartJobRequest.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()}).build();
    private static final SdkField<String> JOB_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartJobRequest.getter(StartJobRequest::jobTypeAsString)).setter(StartJobRequest.setter(Builder::jobType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobType").build()}).build();
    private static final SdkField<String> JOB_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartJobRequest.getter(StartJobRequest::jobReason)).setter(StartJobRequest.setter(Builder::jobReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobReason").build()}).build();
    private static final SdkField<String> COMMIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartJobRequest.getter(StartJobRequest::commitId)).setter(StartJobRequest.setter(Builder::commitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitId").build()}).build();
    private static final SdkField<String> COMMIT_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartJobRequest.getter(StartJobRequest::commitMessage)).setter(StartJobRequest.setter(Builder::commitMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitMessage").build()}).build();
    private static final SdkField<Instant> COMMIT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(StartJobRequest.getter(StartJobRequest::commitTime)).setter(StartJobRequest.setter(Builder::commitTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD, BRANCH_NAME_FIELD, JOB_ID_FIELD, JOB_TYPE_FIELD, JOB_REASON_FIELD, COMMIT_ID_FIELD, COMMIT_MESSAGE_FIELD, COMMIT_TIME_FIELD));
    private final String appId;
    private final String branchName;
    private final String jobId;
    private final String jobType;
    private final String jobReason;
    private final String commitId;
    private final String commitMessage;
    private final Instant commitTime;

    private StartJobRequest(BuilderImpl builder) {
        super(builder);
        this.appId = builder.appId;
        this.branchName = builder.branchName;
        this.jobId = builder.jobId;
        this.jobType = builder.jobType;
        this.jobReason = builder.jobReason;
        this.commitId = builder.commitId;
        this.commitMessage = builder.commitMessage;
        this.commitTime = builder.commitTime;
    }

    public String appId() {
        return this.appId;
    }

    public String branchName() {
        return this.branchName;
    }

    public String jobId() {
        return this.jobId;
    }

    public JobType jobType() {
        return JobType.fromValue(this.jobType);
    }

    public String jobTypeAsString() {
        return this.jobType;
    }

    public String jobReason() {
        return this.jobReason;
    }

    public String commitId() {
        return this.commitId;
    }

    public String commitMessage() {
        return this.commitMessage;
    }

    public Instant commitTime() {
        return this.commitTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.appId());
        hashCode = 31 * hashCode + Objects.hashCode(this.branchName());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.commitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.commitMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.commitTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartJobRequest)) {
            return false;
        }
        StartJobRequest other = (StartJobRequest)((Object)obj);
        return Objects.equals(this.appId(), other.appId()) && Objects.equals(this.branchName(), other.branchName()) && Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.jobTypeAsString(), other.jobTypeAsString()) && Objects.equals(this.jobReason(), other.jobReason()) && Objects.equals(this.commitId(), other.commitId()) && Objects.equals(this.commitMessage(), other.commitMessage()) && Objects.equals(this.commitTime(), other.commitTime());
    }

    public String toString() {
        return ToString.builder((String)"StartJobRequest").add("AppId", (Object)this.appId()).add("BranchName", (Object)this.branchName()).add("JobId", (Object)this.jobId()).add("JobType", (Object)this.jobTypeAsString()).add("JobReason", (Object)this.jobReason()).add("CommitId", (Object)this.commitId()).add("CommitMessage", (Object)this.commitMessage()).add("CommitTime", (Object)this.commitTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appId": {
                return Optional.ofNullable(clazz.cast(this.appId()));
            }
            case "branchName": {
                return Optional.ofNullable(clazz.cast(this.branchName()));
            }
            case "jobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "jobType": {
                return Optional.ofNullable(clazz.cast(this.jobTypeAsString()));
            }
            case "jobReason": {
                return Optional.ofNullable(clazz.cast(this.jobReason()));
            }
            case "commitId": {
                return Optional.ofNullable(clazz.cast(this.commitId()));
            }
            case "commitMessage": {
                return Optional.ofNullable(clazz.cast(this.commitMessage()));
            }
            case "commitTime": {
                return Optional.ofNullable(clazz.cast(this.commitTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartJobRequest, T> g) {
        return obj -> g.apply((StartJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AmplifyRequest.BuilderImpl
    implements Builder {
        private String appId;
        private String branchName;
        private String jobId;
        private String jobType;
        private String jobReason;
        private String commitId;
        private String commitMessage;
        private Instant commitTime;

        private BuilderImpl() {
        }

        private BuilderImpl(StartJobRequest model) {
            super(model);
            this.appId(model.appId);
            this.branchName(model.branchName);
            this.jobId(model.jobId);
            this.jobType(model.jobType);
            this.jobReason(model.jobReason);
            this.commitId(model.commitId);
            this.commitMessage(model.commitMessage);
            this.commitTime(model.commitTime);
        }

        public final String getAppId() {
            return this.appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        public final String getBranchName() {
            return this.branchName;
        }

        @Override
        public final Builder branchName(String branchName) {
            this.branchName = branchName;
            return this;
        }

        public final void setBranchName(String branchName) {
            this.branchName = branchName;
        }

        public final String getJobId() {
            return this.jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final String getJobTypeAsString() {
            return this.jobType;
        }

        @Override
        public final Builder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        @Override
        public final Builder jobType(JobType jobType) {
            this.jobType(jobType.toString());
            return this;
        }

        public final void setJobType(String jobType) {
            this.jobType = jobType;
        }

        public final String getJobReason() {
            return this.jobReason;
        }

        @Override
        public final Builder jobReason(String jobReason) {
            this.jobReason = jobReason;
            return this;
        }

        public final void setJobReason(String jobReason) {
            this.jobReason = jobReason;
        }

        public final String getCommitId() {
            return this.commitId;
        }

        @Override
        public final Builder commitId(String commitId) {
            this.commitId = commitId;
            return this;
        }

        public final void setCommitId(String commitId) {
            this.commitId = commitId;
        }

        public final String getCommitMessage() {
            return this.commitMessage;
        }

        @Override
        public final Builder commitMessage(String commitMessage) {
            this.commitMessage = commitMessage;
            return this;
        }

        public final void setCommitMessage(String commitMessage) {
            this.commitMessage = commitMessage;
        }

        public final Instant getCommitTime() {
            return this.commitTime;
        }

        @Override
        public final Builder commitTime(Instant commitTime) {
            this.commitTime = commitTime;
            return this;
        }

        public final void setCommitTime(Instant commitTime) {
            this.commitTime = commitTime;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartJobRequest build() {
            return new StartJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AmplifyRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartJobRequest> {
        public Builder appId(String var1);

        public Builder branchName(String var1);

        public Builder jobId(String var1);

        public Builder jobType(String var1);

        public Builder jobType(JobType var1);

        public Builder jobReason(String var1);

        public Builder commitId(String var1);

        public Builder commitMessage(String var1);

        public Builder commitTime(Instant var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

