/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplify.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum WafStatus {
    ASSOCIATING("ASSOCIATING"),
    ASSOCIATION_FAILED("ASSOCIATION_FAILED"),
    ASSOCIATION_SUCCESS("ASSOCIATION_SUCCESS"),
    DISASSOCIATING("DISASSOCIATING"),
    DISASSOCIATION_FAILED("DISASSOCIATION_FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, WafStatus> VALUE_MAP;
    private final String value;

    private WafStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static WafStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<WafStatus> knownValues() {
        EnumSet<WafStatus> knownValues = EnumSet.allOf(WafStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(WafStatus.class, WafStatus::toString);
    }
}

