/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplify.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.amplify.model.AmplifyRequest;
import software.amazon.awssdk.services.amplify.model.AutoBranchCreationConfig;
import software.amazon.awssdk.services.amplify.model.AutoBranchCreationPatternsCopier;
import software.amazon.awssdk.services.amplify.model.CacheConfig;
import software.amazon.awssdk.services.amplify.model.CustomRule;
import software.amazon.awssdk.services.amplify.model.CustomRulesCopier;
import software.amazon.awssdk.services.amplify.model.EnvironmentVariablesCopier;
import software.amazon.awssdk.services.amplify.model.Platform;
import software.amazon.awssdk.services.amplify.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAppRequest
extends AmplifyRequest
implements ToCopyableBuilder<Builder, CreateAppRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateAppRequest.getter(CreateAppRequest::name)).setter(CreateAppRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateAppRequest.getter(CreateAppRequest::description)).setter(CreateAppRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> REPOSITORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repository").getter(CreateAppRequest.getter(CreateAppRequest::repository)).setter(CreateAppRequest.setter(Builder::repository)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repository").build()}).build();
    private static final SdkField<String> PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("platform").getter(CreateAppRequest.getter(CreateAppRequest::platformAsString)).setter(CreateAppRequest.setter(Builder::platform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()}).build();
    private static final SdkField<String> IAM_SERVICE_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("iamServiceRoleArn").getter(CreateAppRequest.getter(CreateAppRequest::iamServiceRoleArn)).setter(CreateAppRequest.setter(Builder::iamServiceRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamServiceRoleArn").build()}).build();
    private static final SdkField<String> OAUTH_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("oauthToken").getter(CreateAppRequest.getter(CreateAppRequest::oauthToken)).setter(CreateAppRequest.setter(Builder::oauthToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oauthToken").build()}).build();
    private static final SdkField<String> ACCESS_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accessToken").getter(CreateAppRequest.getter(CreateAppRequest::accessToken)).setter(CreateAppRequest.setter(Builder::accessToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessToken").build()}).build();
    private static final SdkField<Map<String, String>> ENVIRONMENT_VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("environmentVariables").getter(CreateAppRequest.getter(CreateAppRequest::environmentVariables)).setter(CreateAppRequest.setter(Builder::environmentVariables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentVariables").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ENABLE_BRANCH_AUTO_BUILD_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enableBranchAutoBuild").getter(CreateAppRequest.getter(CreateAppRequest::enableBranchAutoBuild)).setter(CreateAppRequest.setter(Builder::enableBranchAutoBuild)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableBranchAutoBuild").build()}).build();
    private static final SdkField<Boolean> ENABLE_BRANCH_AUTO_DELETION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enableBranchAutoDeletion").getter(CreateAppRequest.getter(CreateAppRequest::enableBranchAutoDeletion)).setter(CreateAppRequest.setter(Builder::enableBranchAutoDeletion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableBranchAutoDeletion").build()}).build();
    private static final SdkField<Boolean> ENABLE_BASIC_AUTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enableBasicAuth").getter(CreateAppRequest.getter(CreateAppRequest::enableBasicAuth)).setter(CreateAppRequest.setter(Builder::enableBasicAuth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableBasicAuth").build()}).build();
    private static final SdkField<String> BASIC_AUTH_CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("basicAuthCredentials").getter(CreateAppRequest.getter(CreateAppRequest::basicAuthCredentials)).setter(CreateAppRequest.setter(Builder::basicAuthCredentials)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("basicAuthCredentials").build()}).build();
    private static final SdkField<List<CustomRule>> CUSTOM_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("customRules").getter(CreateAppRequest.getter(CreateAppRequest::customRules)).setter(CreateAppRequest.setter(Builder::customRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CustomRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateAppRequest.getter(CreateAppRequest::tags)).setter(CreateAppRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> BUILD_SPEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("buildSpec").getter(CreateAppRequest.getter(CreateAppRequest::buildSpec)).setter(CreateAppRequest.setter(Builder::buildSpec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildSpec").build()}).build();
    private static final SdkField<String> CUSTOM_HEADERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customHeaders").getter(CreateAppRequest.getter(CreateAppRequest::customHeaders)).setter(CreateAppRequest.setter(Builder::customHeaders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customHeaders").build()}).build();
    private static final SdkField<Boolean> ENABLE_AUTO_BRANCH_CREATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enableAutoBranchCreation").getter(CreateAppRequest.getter(CreateAppRequest::enableAutoBranchCreation)).setter(CreateAppRequest.setter(Builder::enableAutoBranchCreation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableAutoBranchCreation").build()}).build();
    private static final SdkField<List<String>> AUTO_BRANCH_CREATION_PATTERNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("autoBranchCreationPatterns").getter(CreateAppRequest.getter(CreateAppRequest::autoBranchCreationPatterns)).setter(CreateAppRequest.setter(Builder::autoBranchCreationPatterns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoBranchCreationPatterns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AutoBranchCreationConfig> AUTO_BRANCH_CREATION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("autoBranchCreationConfig").getter(CreateAppRequest.getter(CreateAppRequest::autoBranchCreationConfig)).setter(CreateAppRequest.setter(Builder::autoBranchCreationConfig)).constructor(AutoBranchCreationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoBranchCreationConfig").build()}).build();
    private static final SdkField<CacheConfig> CACHE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("cacheConfig").getter(CreateAppRequest.getter(CreateAppRequest::cacheConfig)).setter(CreateAppRequest.setter(Builder::cacheConfig)).constructor(CacheConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, REPOSITORY_FIELD, PLATFORM_FIELD, IAM_SERVICE_ROLE_ARN_FIELD, OAUTH_TOKEN_FIELD, ACCESS_TOKEN_FIELD, ENVIRONMENT_VARIABLES_FIELD, ENABLE_BRANCH_AUTO_BUILD_FIELD, ENABLE_BRANCH_AUTO_DELETION_FIELD, ENABLE_BASIC_AUTH_FIELD, BASIC_AUTH_CREDENTIALS_FIELD, CUSTOM_RULES_FIELD, TAGS_FIELD, BUILD_SPEC_FIELD, CUSTOM_HEADERS_FIELD, ENABLE_AUTO_BRANCH_CREATION_FIELD, AUTO_BRANCH_CREATION_PATTERNS_FIELD, AUTO_BRANCH_CREATION_CONFIG_FIELD, CACHE_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateAppRequest.memberNameToFieldInitializer();
    private final String name;
    private final String description;
    private final String repository;
    private final String platform;
    private final String iamServiceRoleArn;
    private final String oauthToken;
    private final String accessToken;
    private final Map<String, String> environmentVariables;
    private final Boolean enableBranchAutoBuild;
    private final Boolean enableBranchAutoDeletion;
    private final Boolean enableBasicAuth;
    private final String basicAuthCredentials;
    private final List<CustomRule> customRules;
    private final Map<String, String> tags;
    private final String buildSpec;
    private final String customHeaders;
    private final Boolean enableAutoBranchCreation;
    private final List<String> autoBranchCreationPatterns;
    private final AutoBranchCreationConfig autoBranchCreationConfig;
    private final CacheConfig cacheConfig;

    private CreateAppRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.repository = builder.repository;
        this.platform = builder.platform;
        this.iamServiceRoleArn = builder.iamServiceRoleArn;
        this.oauthToken = builder.oauthToken;
        this.accessToken = builder.accessToken;
        this.environmentVariables = builder.environmentVariables;
        this.enableBranchAutoBuild = builder.enableBranchAutoBuild;
        this.enableBranchAutoDeletion = builder.enableBranchAutoDeletion;
        this.enableBasicAuth = builder.enableBasicAuth;
        this.basicAuthCredentials = builder.basicAuthCredentials;
        this.customRules = builder.customRules;
        this.tags = builder.tags;
        this.buildSpec = builder.buildSpec;
        this.customHeaders = builder.customHeaders;
        this.enableAutoBranchCreation = builder.enableAutoBranchCreation;
        this.autoBranchCreationPatterns = builder.autoBranchCreationPatterns;
        this.autoBranchCreationConfig = builder.autoBranchCreationConfig;
        this.cacheConfig = builder.cacheConfig;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String repository() {
        return this.repository;
    }

    public final Platform platform() {
        return Platform.fromValue(this.platform);
    }

    public final String platformAsString() {
        return this.platform;
    }

    public final String iamServiceRoleArn() {
        return this.iamServiceRoleArn;
    }

    public final String oauthToken() {
        return this.oauthToken;
    }

    public final String accessToken() {
        return this.accessToken;
    }

    public final boolean hasEnvironmentVariables() {
        return this.environmentVariables != null && !(this.environmentVariables instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> environmentVariables() {
        return this.environmentVariables;
    }

    public final Boolean enableBranchAutoBuild() {
        return this.enableBranchAutoBuild;
    }

    public final Boolean enableBranchAutoDeletion() {
        return this.enableBranchAutoDeletion;
    }

    public final Boolean enableBasicAuth() {
        return this.enableBasicAuth;
    }

    public final String basicAuthCredentials() {
        return this.basicAuthCredentials;
    }

    public final boolean hasCustomRules() {
        return this.customRules != null && !(this.customRules instanceof SdkAutoConstructList);
    }

    public final List<CustomRule> customRules() {
        return this.customRules;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String buildSpec() {
        return this.buildSpec;
    }

    public final String customHeaders() {
        return this.customHeaders;
    }

    public final Boolean enableAutoBranchCreation() {
        return this.enableAutoBranchCreation;
    }

    public final boolean hasAutoBranchCreationPatterns() {
        return this.autoBranchCreationPatterns != null && !(this.autoBranchCreationPatterns instanceof SdkAutoConstructList);
    }

    public final List<String> autoBranchCreationPatterns() {
        return this.autoBranchCreationPatterns;
    }

    public final AutoBranchCreationConfig autoBranchCreationConfig() {
        return this.autoBranchCreationConfig;
    }

    public final CacheConfig cacheConfig() {
        return this.cacheConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.repository());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamServiceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.oauthToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironmentVariables() ? this.environmentVariables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.enableBranchAutoBuild());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableBranchAutoDeletion());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableBasicAuth());
        hashCode = 31 * hashCode + Objects.hashCode(this.basicAuthCredentials());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomRules() ? this.customRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.buildSpec());
        hashCode = 31 * hashCode + Objects.hashCode(this.customHeaders());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableAutoBranchCreation());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAutoBranchCreationPatterns() ? this.autoBranchCreationPatterns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.autoBranchCreationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAppRequest)) {
            return false;
        }
        CreateAppRequest other = (CreateAppRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.repository(), other.repository()) && Objects.equals(this.platformAsString(), other.platformAsString()) && Objects.equals(this.iamServiceRoleArn(), other.iamServiceRoleArn()) && Objects.equals(this.oauthToken(), other.oauthToken()) && Objects.equals(this.accessToken(), other.accessToken()) && this.hasEnvironmentVariables() == other.hasEnvironmentVariables() && Objects.equals(this.environmentVariables(), other.environmentVariables()) && Objects.equals(this.enableBranchAutoBuild(), other.enableBranchAutoBuild()) && Objects.equals(this.enableBranchAutoDeletion(), other.enableBranchAutoDeletion()) && Objects.equals(this.enableBasicAuth(), other.enableBasicAuth()) && Objects.equals(this.basicAuthCredentials(), other.basicAuthCredentials()) && this.hasCustomRules() == other.hasCustomRules() && Objects.equals(this.customRules(), other.customRules()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.buildSpec(), other.buildSpec()) && Objects.equals(this.customHeaders(), other.customHeaders()) && Objects.equals(this.enableAutoBranchCreation(), other.enableAutoBranchCreation()) && this.hasAutoBranchCreationPatterns() == other.hasAutoBranchCreationPatterns() && Objects.equals(this.autoBranchCreationPatterns(), other.autoBranchCreationPatterns()) && Objects.equals(this.autoBranchCreationConfig(), other.autoBranchCreationConfig()) && Objects.equals(this.cacheConfig(), other.cacheConfig());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAppRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Repository", (Object)this.repository()).add("Platform", (Object)this.platformAsString()).add("IamServiceRoleArn", (Object)this.iamServiceRoleArn()).add("OauthToken", (Object)(this.oauthToken() == null ? null : "*** Sensitive Data Redacted ***")).add("AccessToken", (Object)(this.accessToken() == null ? null : "*** Sensitive Data Redacted ***")).add("EnvironmentVariables", this.hasEnvironmentVariables() ? this.environmentVariables() : null).add("EnableBranchAutoBuild", (Object)this.enableBranchAutoBuild()).add("EnableBranchAutoDeletion", (Object)this.enableBranchAutoDeletion()).add("EnableBasicAuth", (Object)this.enableBasicAuth()).add("BasicAuthCredentials", (Object)(this.basicAuthCredentials() == null ? null : "*** Sensitive Data Redacted ***")).add("CustomRules", this.hasCustomRules() ? this.customRules() : null).add("Tags", this.hasTags() ? this.tags() : null).add("BuildSpec", (Object)(this.buildSpec() == null ? null : "*** Sensitive Data Redacted ***")).add("CustomHeaders", (Object)this.customHeaders()).add("EnableAutoBranchCreation", (Object)this.enableAutoBranchCreation()).add("AutoBranchCreationPatterns", this.hasAutoBranchCreationPatterns() ? this.autoBranchCreationPatterns() : null).add("AutoBranchCreationConfig", (Object)this.autoBranchCreationConfig()).add("CacheConfig", (Object)this.cacheConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "repository": {
                return Optional.ofNullable(clazz.cast(this.repository()));
            }
            case "platform": {
                return Optional.ofNullable(clazz.cast(this.platformAsString()));
            }
            case "iamServiceRoleArn": {
                return Optional.ofNullable(clazz.cast(this.iamServiceRoleArn()));
            }
            case "oauthToken": {
                return Optional.ofNullable(clazz.cast(this.oauthToken()));
            }
            case "accessToken": {
                return Optional.ofNullable(clazz.cast(this.accessToken()));
            }
            case "environmentVariables": {
                return Optional.ofNullable(clazz.cast(this.environmentVariables()));
            }
            case "enableBranchAutoBuild": {
                return Optional.ofNullable(clazz.cast(this.enableBranchAutoBuild()));
            }
            case "enableBranchAutoDeletion": {
                return Optional.ofNullable(clazz.cast(this.enableBranchAutoDeletion()));
            }
            case "enableBasicAuth": {
                return Optional.ofNullable(clazz.cast(this.enableBasicAuth()));
            }
            case "basicAuthCredentials": {
                return Optional.ofNullable(clazz.cast(this.basicAuthCredentials()));
            }
            case "customRules": {
                return Optional.ofNullable(clazz.cast(this.customRules()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "buildSpec": {
                return Optional.ofNullable(clazz.cast(this.buildSpec()));
            }
            case "customHeaders": {
                return Optional.ofNullable(clazz.cast(this.customHeaders()));
            }
            case "enableAutoBranchCreation": {
                return Optional.ofNullable(clazz.cast(this.enableAutoBranchCreation()));
            }
            case "autoBranchCreationPatterns": {
                return Optional.ofNullable(clazz.cast(this.autoBranchCreationPatterns()));
            }
            case "autoBranchCreationConfig": {
                return Optional.ofNullable(clazz.cast(this.autoBranchCreationConfig()));
            }
            case "cacheConfig": {
                return Optional.ofNullable(clazz.cast(this.cacheConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("repository", REPOSITORY_FIELD);
        map.put("platform", PLATFORM_FIELD);
        map.put("iamServiceRoleArn", IAM_SERVICE_ROLE_ARN_FIELD);
        map.put("oauthToken", OAUTH_TOKEN_FIELD);
        map.put("accessToken", ACCESS_TOKEN_FIELD);
        map.put("environmentVariables", ENVIRONMENT_VARIABLES_FIELD);
        map.put("enableBranchAutoBuild", ENABLE_BRANCH_AUTO_BUILD_FIELD);
        map.put("enableBranchAutoDeletion", ENABLE_BRANCH_AUTO_DELETION_FIELD);
        map.put("enableBasicAuth", ENABLE_BASIC_AUTH_FIELD);
        map.put("basicAuthCredentials", BASIC_AUTH_CREDENTIALS_FIELD);
        map.put("customRules", CUSTOM_RULES_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("buildSpec", BUILD_SPEC_FIELD);
        map.put("customHeaders", CUSTOM_HEADERS_FIELD);
        map.put("enableAutoBranchCreation", ENABLE_AUTO_BRANCH_CREATION_FIELD);
        map.put("autoBranchCreationPatterns", AUTO_BRANCH_CREATION_PATTERNS_FIELD);
        map.put("autoBranchCreationConfig", AUTO_BRANCH_CREATION_CONFIG_FIELD);
        map.put("cacheConfig", CACHE_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAppRequest, T> g) {
        return obj -> g.apply((CreateAppRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AmplifyRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String repository;
        private String platform;
        private String iamServiceRoleArn;
        private String oauthToken;
        private String accessToken;
        private Map<String, String> environmentVariables = DefaultSdkAutoConstructMap.getInstance();
        private Boolean enableBranchAutoBuild;
        private Boolean enableBranchAutoDeletion;
        private Boolean enableBasicAuth;
        private String basicAuthCredentials;
        private List<CustomRule> customRules = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String buildSpec;
        private String customHeaders;
        private Boolean enableAutoBranchCreation;
        private List<String> autoBranchCreationPatterns = DefaultSdkAutoConstructList.getInstance();
        private AutoBranchCreationConfig autoBranchCreationConfig;
        private CacheConfig cacheConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAppRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.repository(model.repository);
            this.platform(model.platform);
            this.iamServiceRoleArn(model.iamServiceRoleArn);
            this.oauthToken(model.oauthToken);
            this.accessToken(model.accessToken);
            this.environmentVariables(model.environmentVariables);
            this.enableBranchAutoBuild(model.enableBranchAutoBuild);
            this.enableBranchAutoDeletion(model.enableBranchAutoDeletion);
            this.enableBasicAuth(model.enableBasicAuth);
            this.basicAuthCredentials(model.basicAuthCredentials);
            this.customRules(model.customRules);
            this.tags(model.tags);
            this.buildSpec(model.buildSpec);
            this.customHeaders(model.customHeaders);
            this.enableAutoBranchCreation(model.enableAutoBranchCreation);
            this.autoBranchCreationPatterns(model.autoBranchCreationPatterns);
            this.autoBranchCreationConfig(model.autoBranchCreationConfig);
            this.cacheConfig(model.cacheConfig);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getRepository() {
            return this.repository;
        }

        public final void setRepository(String repository) {
            this.repository = repository;
        }

        @Override
        public final Builder repository(String repository) {
            this.repository = repository;
            return this;
        }

        public final String getPlatform() {
            return this.platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(Platform platform) {
            this.platform(platform == null ? null : platform.toString());
            return this;
        }

        public final String getIamServiceRoleArn() {
            return this.iamServiceRoleArn;
        }

        public final void setIamServiceRoleArn(String iamServiceRoleArn) {
            this.iamServiceRoleArn = iamServiceRoleArn;
        }

        @Override
        public final Builder iamServiceRoleArn(String iamServiceRoleArn) {
            this.iamServiceRoleArn = iamServiceRoleArn;
            return this;
        }

        public final String getOauthToken() {
            return this.oauthToken;
        }

        public final void setOauthToken(String oauthToken) {
            this.oauthToken = oauthToken;
        }

        @Override
        public final Builder oauthToken(String oauthToken) {
            this.oauthToken = oauthToken;
            return this;
        }

        public final String getAccessToken() {
            return this.accessToken;
        }

        public final void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        @Override
        public final Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public final Map<String, String> getEnvironmentVariables() {
            if (this.environmentVariables instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.environmentVariables;
        }

        public final void setEnvironmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariablesCopier.copy(environmentVariables);
        }

        @Override
        public final Builder environmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariablesCopier.copy(environmentVariables);
            return this;
        }

        public final Boolean getEnableBranchAutoBuild() {
            return this.enableBranchAutoBuild;
        }

        public final void setEnableBranchAutoBuild(Boolean enableBranchAutoBuild) {
            this.enableBranchAutoBuild = enableBranchAutoBuild;
        }

        @Override
        public final Builder enableBranchAutoBuild(Boolean enableBranchAutoBuild) {
            this.enableBranchAutoBuild = enableBranchAutoBuild;
            return this;
        }

        public final Boolean getEnableBranchAutoDeletion() {
            return this.enableBranchAutoDeletion;
        }

        public final void setEnableBranchAutoDeletion(Boolean enableBranchAutoDeletion) {
            this.enableBranchAutoDeletion = enableBranchAutoDeletion;
        }

        @Override
        public final Builder enableBranchAutoDeletion(Boolean enableBranchAutoDeletion) {
            this.enableBranchAutoDeletion = enableBranchAutoDeletion;
            return this;
        }

        public final Boolean getEnableBasicAuth() {
            return this.enableBasicAuth;
        }

        public final void setEnableBasicAuth(Boolean enableBasicAuth) {
            this.enableBasicAuth = enableBasicAuth;
        }

        @Override
        public final Builder enableBasicAuth(Boolean enableBasicAuth) {
            this.enableBasicAuth = enableBasicAuth;
            return this;
        }

        public final String getBasicAuthCredentials() {
            return this.basicAuthCredentials;
        }

        public final void setBasicAuthCredentials(String basicAuthCredentials) {
            this.basicAuthCredentials = basicAuthCredentials;
        }

        @Override
        public final Builder basicAuthCredentials(String basicAuthCredentials) {
            this.basicAuthCredentials = basicAuthCredentials;
            return this;
        }

        public final List<CustomRule.Builder> getCustomRules() {
            List<CustomRule.Builder> result = CustomRulesCopier.copyToBuilder(this.customRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomRules(Collection<CustomRule.BuilderImpl> customRules) {
            this.customRules = CustomRulesCopier.copyFromBuilder(customRules);
        }

        @Override
        public final Builder customRules(Collection<CustomRule> customRules) {
            this.customRules = CustomRulesCopier.copy(customRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customRules(CustomRule ... customRules) {
            this.customRules(Arrays.asList(customRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customRules(Consumer<CustomRule.Builder> ... customRules) {
            this.customRules(Stream.of(customRules).map(c -> (CustomRule)((CustomRule.Builder)CustomRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getBuildSpec() {
            return this.buildSpec;
        }

        public final void setBuildSpec(String buildSpec) {
            this.buildSpec = buildSpec;
        }

        @Override
        public final Builder buildSpec(String buildSpec) {
            this.buildSpec = buildSpec;
            return this;
        }

        public final String getCustomHeaders() {
            return this.customHeaders;
        }

        public final void setCustomHeaders(String customHeaders) {
            this.customHeaders = customHeaders;
        }

        @Override
        public final Builder customHeaders(String customHeaders) {
            this.customHeaders = customHeaders;
            return this;
        }

        public final Boolean getEnableAutoBranchCreation() {
            return this.enableAutoBranchCreation;
        }

        public final void setEnableAutoBranchCreation(Boolean enableAutoBranchCreation) {
            this.enableAutoBranchCreation = enableAutoBranchCreation;
        }

        @Override
        public final Builder enableAutoBranchCreation(Boolean enableAutoBranchCreation) {
            this.enableAutoBranchCreation = enableAutoBranchCreation;
            return this;
        }

        public final Collection<String> getAutoBranchCreationPatterns() {
            if (this.autoBranchCreationPatterns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.autoBranchCreationPatterns;
        }

        public final void setAutoBranchCreationPatterns(Collection<String> autoBranchCreationPatterns) {
            this.autoBranchCreationPatterns = AutoBranchCreationPatternsCopier.copy(autoBranchCreationPatterns);
        }

        @Override
        public final Builder autoBranchCreationPatterns(Collection<String> autoBranchCreationPatterns) {
            this.autoBranchCreationPatterns = AutoBranchCreationPatternsCopier.copy(autoBranchCreationPatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoBranchCreationPatterns(String ... autoBranchCreationPatterns) {
            this.autoBranchCreationPatterns(Arrays.asList(autoBranchCreationPatterns));
            return this;
        }

        public final AutoBranchCreationConfig.Builder getAutoBranchCreationConfig() {
            return this.autoBranchCreationConfig != null ? this.autoBranchCreationConfig.toBuilder() : null;
        }

        public final void setAutoBranchCreationConfig(AutoBranchCreationConfig.BuilderImpl autoBranchCreationConfig) {
            this.autoBranchCreationConfig = autoBranchCreationConfig != null ? autoBranchCreationConfig.build() : null;
        }

        @Override
        public final Builder autoBranchCreationConfig(AutoBranchCreationConfig autoBranchCreationConfig) {
            this.autoBranchCreationConfig = autoBranchCreationConfig;
            return this;
        }

        public final CacheConfig.Builder getCacheConfig() {
            return this.cacheConfig != null ? this.cacheConfig.toBuilder() : null;
        }

        public final void setCacheConfig(CacheConfig.BuilderImpl cacheConfig) {
            this.cacheConfig = cacheConfig != null ? cacheConfig.build() : null;
        }

        @Override
        public final Builder cacheConfig(CacheConfig cacheConfig) {
            this.cacheConfig = cacheConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAppRequest build() {
            return new CreateAppRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AmplifyRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAppRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder repository(String var1);

        public Builder platform(String var1);

        public Builder platform(Platform var1);

        public Builder iamServiceRoleArn(String var1);

        public Builder oauthToken(String var1);

        public Builder accessToken(String var1);

        public Builder environmentVariables(Map<String, String> var1);

        public Builder enableBranchAutoBuild(Boolean var1);

        public Builder enableBranchAutoDeletion(Boolean var1);

        public Builder enableBasicAuth(Boolean var1);

        public Builder basicAuthCredentials(String var1);

        public Builder customRules(Collection<CustomRule> var1);

        public Builder customRules(CustomRule ... var1);

        public Builder customRules(Consumer<CustomRule.Builder> ... var1);

        public Builder tags(Map<String, String> var1);

        public Builder buildSpec(String var1);

        public Builder customHeaders(String var1);

        public Builder enableAutoBranchCreation(Boolean var1);

        public Builder autoBranchCreationPatterns(Collection<String> var1);

        public Builder autoBranchCreationPatterns(String ... var1);

        public Builder autoBranchCreationConfig(AutoBranchCreationConfig var1);

        default public Builder autoBranchCreationConfig(Consumer<AutoBranchCreationConfig.Builder> autoBranchCreationConfig) {
            return this.autoBranchCreationConfig((AutoBranchCreationConfig)((AutoBranchCreationConfig.Builder)AutoBranchCreationConfig.builder().applyMutation(autoBranchCreationConfig)).build());
        }

        public Builder cacheConfig(CacheConfig var1);

        default public Builder cacheConfig(Consumer<CacheConfig.Builder> cacheConfig) {
            return this.cacheConfig((CacheConfig)((CacheConfig.Builder)CacheConfig.builder().applyMutation(cacheConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

