/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplify.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Stage {
    PRODUCTION("PRODUCTION"),
    BETA("BETA"),
    DEVELOPMENT("DEVELOPMENT"),
    EXPERIMENTAL("EXPERIMENTAL"),
    PULL_REQUEST("PULL_REQUEST"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Stage> VALUE_MAP;
    private final String value;

    private Stage(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Stage fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Stage> knownValues() {
        EnumSet<Stage> knownValues = EnumSet.allOf(Stage.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Stage.class, Stage::toString);
    }
}

