/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplify.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBranchResponse extends AmplifyResponse implements
        ToCopyableBuilder<GetBranchResponse.Builder, GetBranchResponse> {
    private static final SdkField<Branch> BRANCH_FIELD = SdkField.<Branch> builder(MarshallingType.SDK_POJO).memberName("branch")
            .getter(getter(GetBranchResponse::branch)).setter(setter(Builder::branch)).constructor(Branch::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("branch").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRANCH_FIELD));

    private final Branch branch;

    private GetBranchResponse(BuilderImpl builder) {
        super(builder);
        this.branch = builder.branch;
    }

    /**
     * Returns the value of the Branch property for this object.
     * 
     * @return The value of the Branch property for this object.
     */
    public final Branch branch() {
        return branch;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(branch());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBranchResponse)) {
            return false;
        }
        GetBranchResponse other = (GetBranchResponse) obj;
        return Objects.equals(branch(), other.branch());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetBranchResponse").add("Branch", branch()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "branch":
            return Optional.ofNullable(clazz.cast(branch()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBranchResponse, T> g) {
        return obj -> g.apply((GetBranchResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AmplifyResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetBranchResponse> {
        /**
         * Sets the value of the Branch property for this object.
         *
         * @param branch
         *        The new value for the Branch property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder branch(Branch branch);

        /**
         * Sets the value of the Branch property for this object.
         *
         * This is a convenience that creates an instance of the {@link Branch.Builder} avoiding the need to create one
         * manually via {@link Branch#builder()}.
         *
         * When the {@link Consumer} completes, {@link Branch.Builder#build()} is called immediately and its result is
         * passed to {@link #branch(Branch)}.
         * 
         * @param branch
         *        a consumer that will call methods on {@link Branch.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #branch(Branch)
         */
        default Builder branch(Consumer<Branch.Builder> branch) {
            return branch(Branch.builder().applyMutation(branch).build());
        }
    }

    static final class BuilderImpl extends AmplifyResponse.BuilderImpl implements Builder {
        private Branch branch;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBranchResponse model) {
            super(model);
            branch(model.branch);
        }

        public final Branch.Builder getBranch() {
            return branch != null ? branch.toBuilder() : null;
        }

        @Override
        public final Builder branch(Branch branch) {
            this.branch = branch;
            return this;
        }

        public final void setBranch(Branch.BuilderImpl branch) {
            this.branch = branch != null ? branch.build() : null;
        }

        @Override
        public GetBranchResponse build() {
            return new GetBranchResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
