/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplify.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum JobType {
    RELEASE("RELEASE"),
    RETRY("RETRY"),
    MANUAL("MANUAL"),
    WEB_HOOK("WEB_HOOK"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private JobType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static JobType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(JobType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<JobType> knownValues() {
        return Stream.of(JobType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

