/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplify.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.amplify.model.AssociatedResourcesCopier;
import software.amazon.awssdk.services.amplify.model.CustomDomainsCopier;
import software.amazon.awssdk.services.amplify.model.EnvironmentVariablesCopier;
import software.amazon.awssdk.services.amplify.model.Stage;
import software.amazon.awssdk.services.amplify.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Branch
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Branch> {
    private static final SdkField<String> BRANCH_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("branchArn").getter(Branch.getter(Branch::branchArn)).setter(Branch.setter(Builder::branchArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("branchArn").build()}).build();
    private static final SdkField<String> BRANCH_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("branchName").getter(Branch.getter(Branch::branchName)).setter(Branch.setter(Builder::branchName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("branchName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(Branch.getter(Branch::description)).setter(Branch.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(Branch.getter(Branch::tags)).setter(Branch.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> STAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stage").getter(Branch.getter(Branch::stageAsString)).setter(Branch.setter(Builder::stage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stage").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(Branch.getter(Branch::displayName)).setter(Branch.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<Boolean> ENABLE_NOTIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enableNotification").getter(Branch.getter(Branch::enableNotification)).setter(Branch.setter(Builder::enableNotification)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableNotification").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createTime").getter(Branch.getter(Branch::createTime)).setter(Branch.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updateTime").getter(Branch.getter(Branch::updateTime)).setter(Branch.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build()}).build();
    private static final SdkField<Map<String, String>> ENVIRONMENT_VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("environmentVariables").getter(Branch.getter(Branch::environmentVariables)).setter(Branch.setter(Builder::environmentVariables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentVariables").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ENABLE_AUTO_BUILD_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enableAutoBuild").getter(Branch.getter(Branch::enableAutoBuild)).setter(Branch.setter(Builder::enableAutoBuild)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableAutoBuild").build()}).build();
    private static final SdkField<List<String>> CUSTOM_DOMAINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("customDomains").getter(Branch.getter(Branch::customDomains)).setter(Branch.setter(Builder::customDomains)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customDomains").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> FRAMEWORK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("framework").getter(Branch.getter(Branch::framework)).setter(Branch.setter(Builder::framework)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framework").build()}).build();
    private static final SdkField<String> ACTIVE_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("activeJobId").getter(Branch.getter(Branch::activeJobId)).setter(Branch.setter(Builder::activeJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeJobId").build()}).build();
    private static final SdkField<String> TOTAL_NUMBER_OF_JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("totalNumberOfJobs").getter(Branch.getter(Branch::totalNumberOfJobs)).setter(Branch.setter(Builder::totalNumberOfJobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalNumberOfJobs").build()}).build();
    private static final SdkField<Boolean> ENABLE_BASIC_AUTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enableBasicAuth").getter(Branch.getter(Branch::enableBasicAuth)).setter(Branch.setter(Builder::enableBasicAuth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableBasicAuth").build()}).build();
    private static final SdkField<Boolean> ENABLE_PERFORMANCE_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enablePerformanceMode").getter(Branch.getter(Branch::enablePerformanceMode)).setter(Branch.setter(Builder::enablePerformanceMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enablePerformanceMode").build()}).build();
    private static final SdkField<String> THUMBNAIL_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("thumbnailUrl").getter(Branch.getter(Branch::thumbnailUrl)).setter(Branch.setter(Builder::thumbnailUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thumbnailUrl").build()}).build();
    private static final SdkField<String> BASIC_AUTH_CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("basicAuthCredentials").getter(Branch.getter(Branch::basicAuthCredentials)).setter(Branch.setter(Builder::basicAuthCredentials)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("basicAuthCredentials").build()}).build();
    private static final SdkField<String> BUILD_SPEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("buildSpec").getter(Branch.getter(Branch::buildSpec)).setter(Branch.setter(Builder::buildSpec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildSpec").build()}).build();
    private static final SdkField<String> TTL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ttl").getter(Branch.getter(Branch::ttl)).setter(Branch.setter(Builder::ttl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ttl").build()}).build();
    private static final SdkField<List<String>> ASSOCIATED_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("associatedResources").getter(Branch.getter(Branch::associatedResources)).setter(Branch.setter(Builder::associatedResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ENABLE_PULL_REQUEST_PREVIEW_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enablePullRequestPreview").getter(Branch.getter(Branch::enablePullRequestPreview)).setter(Branch.setter(Builder::enablePullRequestPreview)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enablePullRequestPreview").build()}).build();
    private static final SdkField<String> PULL_REQUEST_ENVIRONMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pullRequestEnvironmentName").getter(Branch.getter(Branch::pullRequestEnvironmentName)).setter(Branch.setter(Builder::pullRequestEnvironmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullRequestEnvironmentName").build()}).build();
    private static final SdkField<String> DESTINATION_BRANCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destinationBranch").getter(Branch.getter(Branch::destinationBranch)).setter(Branch.setter(Builder::destinationBranch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationBranch").build()}).build();
    private static final SdkField<String> SOURCE_BRANCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceBranch").getter(Branch.getter(Branch::sourceBranch)).setter(Branch.setter(Builder::sourceBranch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceBranch").build()}).build();
    private static final SdkField<String> BACKEND_ENVIRONMENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("backendEnvironmentArn").getter(Branch.getter(Branch::backendEnvironmentArn)).setter(Branch.setter(Builder::backendEnvironmentArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("backendEnvironmentArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRANCH_ARN_FIELD, BRANCH_NAME_FIELD, DESCRIPTION_FIELD, TAGS_FIELD, STAGE_FIELD, DISPLAY_NAME_FIELD, ENABLE_NOTIFICATION_FIELD, CREATE_TIME_FIELD, UPDATE_TIME_FIELD, ENVIRONMENT_VARIABLES_FIELD, ENABLE_AUTO_BUILD_FIELD, CUSTOM_DOMAINS_FIELD, FRAMEWORK_FIELD, ACTIVE_JOB_ID_FIELD, TOTAL_NUMBER_OF_JOBS_FIELD, ENABLE_BASIC_AUTH_FIELD, ENABLE_PERFORMANCE_MODE_FIELD, THUMBNAIL_URL_FIELD, BASIC_AUTH_CREDENTIALS_FIELD, BUILD_SPEC_FIELD, TTL_FIELD, ASSOCIATED_RESOURCES_FIELD, ENABLE_PULL_REQUEST_PREVIEW_FIELD, PULL_REQUEST_ENVIRONMENT_NAME_FIELD, DESTINATION_BRANCH_FIELD, SOURCE_BRANCH_FIELD, BACKEND_ENVIRONMENT_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String branchArn;
    private final String branchName;
    private final String description;
    private final Map<String, String> tags;
    private final String stage;
    private final String displayName;
    private final Boolean enableNotification;
    private final Instant createTime;
    private final Instant updateTime;
    private final Map<String, String> environmentVariables;
    private final Boolean enableAutoBuild;
    private final List<String> customDomains;
    private final String framework;
    private final String activeJobId;
    private final String totalNumberOfJobs;
    private final Boolean enableBasicAuth;
    private final Boolean enablePerformanceMode;
    private final String thumbnailUrl;
    private final String basicAuthCredentials;
    private final String buildSpec;
    private final String ttl;
    private final List<String> associatedResources;
    private final Boolean enablePullRequestPreview;
    private final String pullRequestEnvironmentName;
    private final String destinationBranch;
    private final String sourceBranch;
    private final String backendEnvironmentArn;

    private Branch(BuilderImpl builder) {
        this.branchArn = builder.branchArn;
        this.branchName = builder.branchName;
        this.description = builder.description;
        this.tags = builder.tags;
        this.stage = builder.stage;
        this.displayName = builder.displayName;
        this.enableNotification = builder.enableNotification;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.environmentVariables = builder.environmentVariables;
        this.enableAutoBuild = builder.enableAutoBuild;
        this.customDomains = builder.customDomains;
        this.framework = builder.framework;
        this.activeJobId = builder.activeJobId;
        this.totalNumberOfJobs = builder.totalNumberOfJobs;
        this.enableBasicAuth = builder.enableBasicAuth;
        this.enablePerformanceMode = builder.enablePerformanceMode;
        this.thumbnailUrl = builder.thumbnailUrl;
        this.basicAuthCredentials = builder.basicAuthCredentials;
        this.buildSpec = builder.buildSpec;
        this.ttl = builder.ttl;
        this.associatedResources = builder.associatedResources;
        this.enablePullRequestPreview = builder.enablePullRequestPreview;
        this.pullRequestEnvironmentName = builder.pullRequestEnvironmentName;
        this.destinationBranch = builder.destinationBranch;
        this.sourceBranch = builder.sourceBranch;
        this.backendEnvironmentArn = builder.backendEnvironmentArn;
    }

    public String branchArn() {
        return this.branchArn;
    }

    public String branchName() {
        return this.branchName;
    }

    public String description() {
        return this.description;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public Stage stage() {
        return Stage.fromValue(this.stage);
    }

    public String stageAsString() {
        return this.stage;
    }

    public String displayName() {
        return this.displayName;
    }

    public Boolean enableNotification() {
        return this.enableNotification;
    }

    public Instant createTime() {
        return this.createTime;
    }

    public Instant updateTime() {
        return this.updateTime;
    }

    public boolean hasEnvironmentVariables() {
        return this.environmentVariables != null && !(this.environmentVariables instanceof SdkAutoConstructMap);
    }

    public Map<String, String> environmentVariables() {
        return this.environmentVariables;
    }

    public Boolean enableAutoBuild() {
        return this.enableAutoBuild;
    }

    public boolean hasCustomDomains() {
        return this.customDomains != null && !(this.customDomains instanceof SdkAutoConstructList);
    }

    public List<String> customDomains() {
        return this.customDomains;
    }

    public String framework() {
        return this.framework;
    }

    public String activeJobId() {
        return this.activeJobId;
    }

    public String totalNumberOfJobs() {
        return this.totalNumberOfJobs;
    }

    public Boolean enableBasicAuth() {
        return this.enableBasicAuth;
    }

    public Boolean enablePerformanceMode() {
        return this.enablePerformanceMode;
    }

    public String thumbnailUrl() {
        return this.thumbnailUrl;
    }

    public String basicAuthCredentials() {
        return this.basicAuthCredentials;
    }

    public String buildSpec() {
        return this.buildSpec;
    }

    public String ttl() {
        return this.ttl;
    }

    public boolean hasAssociatedResources() {
        return this.associatedResources != null && !(this.associatedResources instanceof SdkAutoConstructList);
    }

    public List<String> associatedResources() {
        return this.associatedResources;
    }

    public Boolean enablePullRequestPreview() {
        return this.enablePullRequestPreview;
    }

    public String pullRequestEnvironmentName() {
        return this.pullRequestEnvironmentName;
    }

    public String destinationBranch() {
        return this.destinationBranch;
    }

    public String sourceBranch() {
        return this.sourceBranch;
    }

    public String backendEnvironmentArn() {
        return this.backendEnvironmentArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.branchArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.branchName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.stageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableNotification());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironmentVariables() ? this.environmentVariables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.enableAutoBuild());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomDomains() ? this.customDomains() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.framework());
        hashCode = 31 * hashCode + Objects.hashCode(this.activeJobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalNumberOfJobs());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableBasicAuth());
        hashCode = 31 * hashCode + Objects.hashCode(this.enablePerformanceMode());
        hashCode = 31 * hashCode + Objects.hashCode(this.thumbnailUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.basicAuthCredentials());
        hashCode = 31 * hashCode + Objects.hashCode(this.buildSpec());
        hashCode = 31 * hashCode + Objects.hashCode(this.ttl());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociatedResources() ? this.associatedResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.enablePullRequestPreview());
        hashCode = 31 * hashCode + Objects.hashCode(this.pullRequestEnvironmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationBranch());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceBranch());
        hashCode = 31 * hashCode + Objects.hashCode(this.backendEnvironmentArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Branch)) {
            return false;
        }
        Branch other = (Branch)obj;
        return Objects.equals(this.branchArn(), other.branchArn()) && Objects.equals(this.branchName(), other.branchName()) && Objects.equals(this.description(), other.description()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.stageAsString(), other.stageAsString()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.enableNotification(), other.enableNotification()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.updateTime(), other.updateTime()) && this.hasEnvironmentVariables() == other.hasEnvironmentVariables() && Objects.equals(this.environmentVariables(), other.environmentVariables()) && Objects.equals(this.enableAutoBuild(), other.enableAutoBuild()) && this.hasCustomDomains() == other.hasCustomDomains() && Objects.equals(this.customDomains(), other.customDomains()) && Objects.equals(this.framework(), other.framework()) && Objects.equals(this.activeJobId(), other.activeJobId()) && Objects.equals(this.totalNumberOfJobs(), other.totalNumberOfJobs()) && Objects.equals(this.enableBasicAuth(), other.enableBasicAuth()) && Objects.equals(this.enablePerformanceMode(), other.enablePerformanceMode()) && Objects.equals(this.thumbnailUrl(), other.thumbnailUrl()) && Objects.equals(this.basicAuthCredentials(), other.basicAuthCredentials()) && Objects.equals(this.buildSpec(), other.buildSpec()) && Objects.equals(this.ttl(), other.ttl()) && this.hasAssociatedResources() == other.hasAssociatedResources() && Objects.equals(this.associatedResources(), other.associatedResources()) && Objects.equals(this.enablePullRequestPreview(), other.enablePullRequestPreview()) && Objects.equals(this.pullRequestEnvironmentName(), other.pullRequestEnvironmentName()) && Objects.equals(this.destinationBranch(), other.destinationBranch()) && Objects.equals(this.sourceBranch(), other.sourceBranch()) && Objects.equals(this.backendEnvironmentArn(), other.backendEnvironmentArn());
    }

    public String toString() {
        return ToString.builder((String)"Branch").add("BranchArn", (Object)this.branchArn()).add("BranchName", (Object)this.branchName()).add("Description", (Object)this.description()).add("Tags", this.hasTags() ? this.tags() : null).add("Stage", (Object)this.stageAsString()).add("DisplayName", (Object)this.displayName()).add("EnableNotification", (Object)this.enableNotification()).add("CreateTime", (Object)this.createTime()).add("UpdateTime", (Object)this.updateTime()).add("EnvironmentVariables", this.hasEnvironmentVariables() ? this.environmentVariables() : null).add("EnableAutoBuild", (Object)this.enableAutoBuild()).add("CustomDomains", this.hasCustomDomains() ? this.customDomains() : null).add("Framework", (Object)this.framework()).add("ActiveJobId", (Object)this.activeJobId()).add("TotalNumberOfJobs", (Object)this.totalNumberOfJobs()).add("EnableBasicAuth", (Object)this.enableBasicAuth()).add("EnablePerformanceMode", (Object)this.enablePerformanceMode()).add("ThumbnailUrl", (Object)this.thumbnailUrl()).add("BasicAuthCredentials", (Object)(this.basicAuthCredentials() == null ? null : "*** Sensitive Data Redacted ***")).add("BuildSpec", (Object)this.buildSpec()).add("Ttl", (Object)this.ttl()).add("AssociatedResources", this.hasAssociatedResources() ? this.associatedResources() : null).add("EnablePullRequestPreview", (Object)this.enablePullRequestPreview()).add("PullRequestEnvironmentName", (Object)this.pullRequestEnvironmentName()).add("DestinationBranch", (Object)this.destinationBranch()).add("SourceBranch", (Object)this.sourceBranch()).add("BackendEnvironmentArn", (Object)this.backendEnvironmentArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "branchArn": {
                return Optional.ofNullable(clazz.cast(this.branchArn()));
            }
            case "branchName": {
                return Optional.ofNullable(clazz.cast(this.branchName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "stage": {
                return Optional.ofNullable(clazz.cast(this.stageAsString()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "enableNotification": {
                return Optional.ofNullable(clazz.cast(this.enableNotification()));
            }
            case "createTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "updateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
            case "environmentVariables": {
                return Optional.ofNullable(clazz.cast(this.environmentVariables()));
            }
            case "enableAutoBuild": {
                return Optional.ofNullable(clazz.cast(this.enableAutoBuild()));
            }
            case "customDomains": {
                return Optional.ofNullable(clazz.cast(this.customDomains()));
            }
            case "framework": {
                return Optional.ofNullable(clazz.cast(this.framework()));
            }
            case "activeJobId": {
                return Optional.ofNullable(clazz.cast(this.activeJobId()));
            }
            case "totalNumberOfJobs": {
                return Optional.ofNullable(clazz.cast(this.totalNumberOfJobs()));
            }
            case "enableBasicAuth": {
                return Optional.ofNullable(clazz.cast(this.enableBasicAuth()));
            }
            case "enablePerformanceMode": {
                return Optional.ofNullable(clazz.cast(this.enablePerformanceMode()));
            }
            case "thumbnailUrl": {
                return Optional.ofNullable(clazz.cast(this.thumbnailUrl()));
            }
            case "basicAuthCredentials": {
                return Optional.ofNullable(clazz.cast(this.basicAuthCredentials()));
            }
            case "buildSpec": {
                return Optional.ofNullable(clazz.cast(this.buildSpec()));
            }
            case "ttl": {
                return Optional.ofNullable(clazz.cast(this.ttl()));
            }
            case "associatedResources": {
                return Optional.ofNullable(clazz.cast(this.associatedResources()));
            }
            case "enablePullRequestPreview": {
                return Optional.ofNullable(clazz.cast(this.enablePullRequestPreview()));
            }
            case "pullRequestEnvironmentName": {
                return Optional.ofNullable(clazz.cast(this.pullRequestEnvironmentName()));
            }
            case "destinationBranch": {
                return Optional.ofNullable(clazz.cast(this.destinationBranch()));
            }
            case "sourceBranch": {
                return Optional.ofNullable(clazz.cast(this.sourceBranch()));
            }
            case "backendEnvironmentArn": {
                return Optional.ofNullable(clazz.cast(this.backendEnvironmentArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Branch, T> g) {
        return obj -> g.apply((Branch)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String branchArn;
        private String branchName;
        private String description;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String stage;
        private String displayName;
        private Boolean enableNotification;
        private Instant createTime;
        private Instant updateTime;
        private Map<String, String> environmentVariables = DefaultSdkAutoConstructMap.getInstance();
        private Boolean enableAutoBuild;
        private List<String> customDomains = DefaultSdkAutoConstructList.getInstance();
        private String framework;
        private String activeJobId;
        private String totalNumberOfJobs;
        private Boolean enableBasicAuth;
        private Boolean enablePerformanceMode;
        private String thumbnailUrl;
        private String basicAuthCredentials;
        private String buildSpec;
        private String ttl;
        private List<String> associatedResources = DefaultSdkAutoConstructList.getInstance();
        private Boolean enablePullRequestPreview;
        private String pullRequestEnvironmentName;
        private String destinationBranch;
        private String sourceBranch;
        private String backendEnvironmentArn;

        private BuilderImpl() {
        }

        private BuilderImpl(Branch model) {
            this.branchArn(model.branchArn);
            this.branchName(model.branchName);
            this.description(model.description);
            this.tags(model.tags);
            this.stage(model.stage);
            this.displayName(model.displayName);
            this.enableNotification(model.enableNotification);
            this.createTime(model.createTime);
            this.updateTime(model.updateTime);
            this.environmentVariables(model.environmentVariables);
            this.enableAutoBuild(model.enableAutoBuild);
            this.customDomains(model.customDomains);
            this.framework(model.framework);
            this.activeJobId(model.activeJobId);
            this.totalNumberOfJobs(model.totalNumberOfJobs);
            this.enableBasicAuth(model.enableBasicAuth);
            this.enablePerformanceMode(model.enablePerformanceMode);
            this.thumbnailUrl(model.thumbnailUrl);
            this.basicAuthCredentials(model.basicAuthCredentials);
            this.buildSpec(model.buildSpec);
            this.ttl(model.ttl);
            this.associatedResources(model.associatedResources);
            this.enablePullRequestPreview(model.enablePullRequestPreview);
            this.pullRequestEnvironmentName(model.pullRequestEnvironmentName);
            this.destinationBranch(model.destinationBranch);
            this.sourceBranch(model.sourceBranch);
            this.backendEnvironmentArn(model.backendEnvironmentArn);
        }

        public final String getBranchArn() {
            return this.branchArn;
        }

        @Override
        public final Builder branchArn(String branchArn) {
            this.branchArn = branchArn;
            return this;
        }

        public final void setBranchArn(String branchArn) {
            this.branchArn = branchArn;
        }

        public final String getBranchName() {
            return this.branchName;
        }

        @Override
        public final Builder branchName(String branchName) {
            this.branchName = branchName;
            return this;
        }

        public final void setBranchName(String branchName) {
            this.branchName = branchName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        public final String getStage() {
            return this.stage;
        }

        @Override
        public final Builder stage(String stage) {
            this.stage = stage;
            return this;
        }

        @Override
        public final Builder stage(Stage stage) {
            this.stage(stage == null ? null : stage.toString());
            return this;
        }

        public final void setStage(String stage) {
            this.stage = stage;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final Boolean getEnableNotification() {
            return this.enableNotification;
        }

        @Override
        public final Builder enableNotification(Boolean enableNotification) {
            this.enableNotification = enableNotification;
            return this;
        }

        public final void setEnableNotification(Boolean enableNotification) {
            this.enableNotification = enableNotification;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        public final Map<String, String> getEnvironmentVariables() {
            if (this.environmentVariables instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.environmentVariables;
        }

        @Override
        public final Builder environmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariablesCopier.copy(environmentVariables);
            return this;
        }

        public final void setEnvironmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariablesCopier.copy(environmentVariables);
        }

        public final Boolean getEnableAutoBuild() {
            return this.enableAutoBuild;
        }

        @Override
        public final Builder enableAutoBuild(Boolean enableAutoBuild) {
            this.enableAutoBuild = enableAutoBuild;
            return this;
        }

        public final void setEnableAutoBuild(Boolean enableAutoBuild) {
            this.enableAutoBuild = enableAutoBuild;
        }

        public final Collection<String> getCustomDomains() {
            if (this.customDomains instanceof SdkAutoConstructList) {
                return null;
            }
            return this.customDomains;
        }

        @Override
        public final Builder customDomains(Collection<String> customDomains) {
            this.customDomains = CustomDomainsCopier.copy(customDomains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customDomains(String ... customDomains) {
            this.customDomains(Arrays.asList(customDomains));
            return this;
        }

        public final void setCustomDomains(Collection<String> customDomains) {
            this.customDomains = CustomDomainsCopier.copy(customDomains);
        }

        public final String getFramework() {
            return this.framework;
        }

        @Override
        public final Builder framework(String framework) {
            this.framework = framework;
            return this;
        }

        public final void setFramework(String framework) {
            this.framework = framework;
        }

        public final String getActiveJobId() {
            return this.activeJobId;
        }

        @Override
        public final Builder activeJobId(String activeJobId) {
            this.activeJobId = activeJobId;
            return this;
        }

        public final void setActiveJobId(String activeJobId) {
            this.activeJobId = activeJobId;
        }

        public final String getTotalNumberOfJobs() {
            return this.totalNumberOfJobs;
        }

        @Override
        public final Builder totalNumberOfJobs(String totalNumberOfJobs) {
            this.totalNumberOfJobs = totalNumberOfJobs;
            return this;
        }

        public final void setTotalNumberOfJobs(String totalNumberOfJobs) {
            this.totalNumberOfJobs = totalNumberOfJobs;
        }

        public final Boolean getEnableBasicAuth() {
            return this.enableBasicAuth;
        }

        @Override
        public final Builder enableBasicAuth(Boolean enableBasicAuth) {
            this.enableBasicAuth = enableBasicAuth;
            return this;
        }

        public final void setEnableBasicAuth(Boolean enableBasicAuth) {
            this.enableBasicAuth = enableBasicAuth;
        }

        public final Boolean getEnablePerformanceMode() {
            return this.enablePerformanceMode;
        }

        @Override
        public final Builder enablePerformanceMode(Boolean enablePerformanceMode) {
            this.enablePerformanceMode = enablePerformanceMode;
            return this;
        }

        public final void setEnablePerformanceMode(Boolean enablePerformanceMode) {
            this.enablePerformanceMode = enablePerformanceMode;
        }

        public final String getThumbnailUrl() {
            return this.thumbnailUrl;
        }

        @Override
        public final Builder thumbnailUrl(String thumbnailUrl) {
            this.thumbnailUrl = thumbnailUrl;
            return this;
        }

        public final void setThumbnailUrl(String thumbnailUrl) {
            this.thumbnailUrl = thumbnailUrl;
        }

        public final String getBasicAuthCredentials() {
            return this.basicAuthCredentials;
        }

        @Override
        public final Builder basicAuthCredentials(String basicAuthCredentials) {
            this.basicAuthCredentials = basicAuthCredentials;
            return this;
        }

        public final void setBasicAuthCredentials(String basicAuthCredentials) {
            this.basicAuthCredentials = basicAuthCredentials;
        }

        public final String getBuildSpec() {
            return this.buildSpec;
        }

        @Override
        public final Builder buildSpec(String buildSpec) {
            this.buildSpec = buildSpec;
            return this;
        }

        public final void setBuildSpec(String buildSpec) {
            this.buildSpec = buildSpec;
        }

        public final String getTtl() {
            return this.ttl;
        }

        @Override
        public final Builder ttl(String ttl) {
            this.ttl = ttl;
            return this;
        }

        public final void setTtl(String ttl) {
            this.ttl = ttl;
        }

        public final Collection<String> getAssociatedResources() {
            if (this.associatedResources instanceof SdkAutoConstructList) {
                return null;
            }
            return this.associatedResources;
        }

        @Override
        public final Builder associatedResources(Collection<String> associatedResources) {
            this.associatedResources = AssociatedResourcesCopier.copy(associatedResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedResources(String ... associatedResources) {
            this.associatedResources(Arrays.asList(associatedResources));
            return this;
        }

        public final void setAssociatedResources(Collection<String> associatedResources) {
            this.associatedResources = AssociatedResourcesCopier.copy(associatedResources);
        }

        public final Boolean getEnablePullRequestPreview() {
            return this.enablePullRequestPreview;
        }

        @Override
        public final Builder enablePullRequestPreview(Boolean enablePullRequestPreview) {
            this.enablePullRequestPreview = enablePullRequestPreview;
            return this;
        }

        public final void setEnablePullRequestPreview(Boolean enablePullRequestPreview) {
            this.enablePullRequestPreview = enablePullRequestPreview;
        }

        public final String getPullRequestEnvironmentName() {
            return this.pullRequestEnvironmentName;
        }

        @Override
        public final Builder pullRequestEnvironmentName(String pullRequestEnvironmentName) {
            this.pullRequestEnvironmentName = pullRequestEnvironmentName;
            return this;
        }

        public final void setPullRequestEnvironmentName(String pullRequestEnvironmentName) {
            this.pullRequestEnvironmentName = pullRequestEnvironmentName;
        }

        public final String getDestinationBranch() {
            return this.destinationBranch;
        }

        @Override
        public final Builder destinationBranch(String destinationBranch) {
            this.destinationBranch = destinationBranch;
            return this;
        }

        public final void setDestinationBranch(String destinationBranch) {
            this.destinationBranch = destinationBranch;
        }

        public final String getSourceBranch() {
            return this.sourceBranch;
        }

        @Override
        public final Builder sourceBranch(String sourceBranch) {
            this.sourceBranch = sourceBranch;
            return this;
        }

        public final void setSourceBranch(String sourceBranch) {
            this.sourceBranch = sourceBranch;
        }

        public final String getBackendEnvironmentArn() {
            return this.backendEnvironmentArn;
        }

        @Override
        public final Builder backendEnvironmentArn(String backendEnvironmentArn) {
            this.backendEnvironmentArn = backendEnvironmentArn;
            return this;
        }

        public final void setBackendEnvironmentArn(String backendEnvironmentArn) {
            this.backendEnvironmentArn = backendEnvironmentArn;
        }

        public Branch build() {
            return new Branch(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Branch> {
        public Builder branchArn(String var1);

        public Builder branchName(String var1);

        public Builder description(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder stage(String var1);

        public Builder stage(Stage var1);

        public Builder displayName(String var1);

        public Builder enableNotification(Boolean var1);

        public Builder createTime(Instant var1);

        public Builder updateTime(Instant var1);

        public Builder environmentVariables(Map<String, String> var1);

        public Builder enableAutoBuild(Boolean var1);

        public Builder customDomains(Collection<String> var1);

        public Builder customDomains(String ... var1);

        public Builder framework(String var1);

        public Builder activeJobId(String var1);

        public Builder totalNumberOfJobs(String var1);

        public Builder enableBasicAuth(Boolean var1);

        public Builder enablePerformanceMode(Boolean var1);

        public Builder thumbnailUrl(String var1);

        public Builder basicAuthCredentials(String var1);

        public Builder buildSpec(String var1);

        public Builder ttl(String var1);

        public Builder associatedResources(Collection<String> var1);

        public Builder associatedResources(String ... var1);

        public Builder enablePullRequestPreview(Boolean var1);

        public Builder pullRequestEnvironmentName(String var1);

        public Builder destinationBranch(String var1);

        public Builder sourceBranch(String var1);

        public Builder backendEnvironmentArn(String var1);
    }
}

