/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplify.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.amplify.model.JobSummary;
import software.amazon.awssdk.services.amplify.model.Step;
import software.amazon.awssdk.services.amplify.model.StepsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Job
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Job> {
    private static final SdkField<JobSummary> SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("summary").getter(Job.getter(Job::summary)).setter(Job.setter(Builder::summary)).constructor(JobSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("summary").build()}).build();
    private static final SdkField<List<Step>> STEPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("steps").getter(Job.getter(Job::steps)).setter(Job.setter(Builder::steps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("steps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Step::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUMMARY_FIELD, STEPS_FIELD));
    private static final long serialVersionUID = 1L;
    private final JobSummary summary;
    private final List<Step> steps;

    private Job(BuilderImpl builder) {
        this.summary = builder.summary;
        this.steps = builder.steps;
    }

    public JobSummary summary() {
        return this.summary;
    }

    public boolean hasSteps() {
        return this.steps != null && !(this.steps instanceof SdkAutoConstructList);
    }

    public List<Step> steps() {
        return this.steps;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.summary());
        hashCode = 31 * hashCode + Objects.hashCode(this.steps());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Job)) {
            return false;
        }
        Job other = (Job)obj;
        return Objects.equals(this.summary(), other.summary()) && Objects.equals(this.steps(), other.steps());
    }

    public String toString() {
        return ToString.builder((String)"Job").add("Summary", (Object)this.summary()).add("Steps", this.steps()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "summary": {
                return Optional.ofNullable(clazz.cast(this.summary()));
            }
            case "steps": {
                return Optional.ofNullable(clazz.cast(this.steps()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Job, T> g) {
        return obj -> g.apply((Job)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private JobSummary summary;
        private List<Step> steps = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Job model) {
            this.summary(model.summary);
            this.steps(model.steps);
        }

        public final JobSummary.Builder getSummary() {
            return this.summary != null ? this.summary.toBuilder() : null;
        }

        @Override
        public final Builder summary(JobSummary summary) {
            this.summary = summary;
            return this;
        }

        public final void setSummary(JobSummary.BuilderImpl summary) {
            this.summary = summary != null ? summary.build() : null;
        }

        public final Collection<Step.Builder> getSteps() {
            return this.steps != null ? (Collection)this.steps.stream().map(Step::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder steps(Collection<Step> steps) {
            this.steps = StepsCopier.copy(steps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(Step ... steps) {
            this.steps(Arrays.asList(steps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(Consumer<Step.Builder> ... steps) {
            this.steps(Stream.of(steps).map(c -> (Step)((Step.Builder)Step.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSteps(Collection<Step.BuilderImpl> steps) {
            this.steps = StepsCopier.copyFromBuilder(steps);
        }

        public Job build() {
            return new Job(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Job> {
        public Builder summary(JobSummary var1);

        default public Builder summary(Consumer<JobSummary.Builder> summary) {
            return this.summary((JobSummary)((JobSummary.Builder)JobSummary.builder().applyMutation(summary)).build());
        }

        public Builder steps(Collection<Step> var1);

        public Builder steps(Step ... var1);

        public Builder steps(Consumer<Step.Builder> ... var1);
    }
}

