/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplify.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Subdomain for the Domain Association.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SubDomain implements SdkPojo, Serializable, ToCopyableBuilder<SubDomain.Builder, SubDomain> {
    private static final SdkField<SubDomainSetting> SUB_DOMAIN_SETTING_FIELD = SdkField
            .<SubDomainSetting> builder(MarshallingType.SDK_POJO).getter(getter(SubDomain::subDomainSetting))
            .setter(setter(Builder::subDomainSetting)).constructor(SubDomainSetting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subDomainSetting").build()).build();

    private static final SdkField<Boolean> VERIFIED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(SubDomain::verified)).setter(setter(Builder::verified))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("verified").build()).build();

    private static final SdkField<String> DNS_RECORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SubDomain::dnsRecord)).setter(setter(Builder::dnsRecord))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dnsRecord").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUB_DOMAIN_SETTING_FIELD,
            VERIFIED_FIELD, DNS_RECORD_FIELD));

    private static final long serialVersionUID = 1L;

    private final SubDomainSetting subDomainSetting;

    private final Boolean verified;

    private final String dnsRecord;

    private SubDomain(BuilderImpl builder) {
        this.subDomainSetting = builder.subDomainSetting;
        this.verified = builder.verified;
        this.dnsRecord = builder.dnsRecord;
    }

    /**
     * <p>
     * Setting structure for the Subdomain.
     * </p>
     * 
     * @return Setting structure for the Subdomain.
     */
    public SubDomainSetting subDomainSetting() {
        return subDomainSetting;
    }

    /**
     * <p>
     * Verified status of the Subdomain
     * </p>
     * 
     * @return Verified status of the Subdomain
     */
    public Boolean verified() {
        return verified;
    }

    /**
     * <p>
     * DNS record for the Subdomain.
     * </p>
     * 
     * @return DNS record for the Subdomain.
     */
    public String dnsRecord() {
        return dnsRecord;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(subDomainSetting());
        hashCode = 31 * hashCode + Objects.hashCode(verified());
        hashCode = 31 * hashCode + Objects.hashCode(dnsRecord());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubDomain)) {
            return false;
        }
        SubDomain other = (SubDomain) obj;
        return Objects.equals(subDomainSetting(), other.subDomainSetting()) && Objects.equals(verified(), other.verified())
                && Objects.equals(dnsRecord(), other.dnsRecord());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SubDomain").add("SubDomainSetting", subDomainSetting()).add("Verified", verified())
                .add("DnsRecord", dnsRecord()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "subDomainSetting":
            return Optional.ofNullable(clazz.cast(subDomainSetting()));
        case "verified":
            return Optional.ofNullable(clazz.cast(verified()));
        case "dnsRecord":
            return Optional.ofNullable(clazz.cast(dnsRecord()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SubDomain, T> g) {
        return obj -> g.apply((SubDomain) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SubDomain> {
        /**
         * <p>
         * Setting structure for the Subdomain.
         * </p>
         * 
         * @param subDomainSetting
         *        Setting structure for the Subdomain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subDomainSetting(SubDomainSetting subDomainSetting);

        /**
         * <p>
         * Setting structure for the Subdomain.
         * </p>
         * This is a convenience that creates an instance of the {@link SubDomainSetting.Builder} avoiding the need to
         * create one manually via {@link SubDomainSetting#builder()}.
         *
         * When the {@link Consumer} completes, {@link SubDomainSetting.Builder#build()} is called immediately and its
         * result is passed to {@link #subDomainSetting(SubDomainSetting)}.
         * 
         * @param subDomainSetting
         *        a consumer that will call methods on {@link SubDomainSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subDomainSetting(SubDomainSetting)
         */
        default Builder subDomainSetting(Consumer<SubDomainSetting.Builder> subDomainSetting) {
            return subDomainSetting(SubDomainSetting.builder().applyMutation(subDomainSetting).build());
        }

        /**
         * <p>
         * Verified status of the Subdomain
         * </p>
         * 
         * @param verified
         *        Verified status of the Subdomain
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verified(Boolean verified);

        /**
         * <p>
         * DNS record for the Subdomain.
         * </p>
         * 
         * @param dnsRecord
         *        DNS record for the Subdomain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsRecord(String dnsRecord);
    }

    static final class BuilderImpl implements Builder {
        private SubDomainSetting subDomainSetting;

        private Boolean verified;

        private String dnsRecord;

        private BuilderImpl() {
        }

        private BuilderImpl(SubDomain model) {
            subDomainSetting(model.subDomainSetting);
            verified(model.verified);
            dnsRecord(model.dnsRecord);
        }

        public final SubDomainSetting.Builder getSubDomainSetting() {
            return subDomainSetting != null ? subDomainSetting.toBuilder() : null;
        }

        @Override
        public final Builder subDomainSetting(SubDomainSetting subDomainSetting) {
            this.subDomainSetting = subDomainSetting;
            return this;
        }

        public final void setSubDomainSetting(SubDomainSetting.BuilderImpl subDomainSetting) {
            this.subDomainSetting = subDomainSetting != null ? subDomainSetting.build() : null;
        }

        public final Boolean getVerified() {
            return verified;
        }

        @Override
        public final Builder verified(Boolean verified) {
            this.verified = verified;
            return this;
        }

        public final void setVerified(Boolean verified) {
            this.verified = verified;
        }

        public final String getDnsRecord() {
            return dnsRecord;
        }

        @Override
        public final Builder dnsRecord(String dnsRecord) {
            this.dnsRecord = dnsRecord;
            return this;
        }

        public final void setDnsRecord(String dnsRecord) {
            this.dnsRecord = dnsRecord;
        }

        @Override
        public SubDomain build() {
            return new SubDomain(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
