/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplify.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Structure with auto branch creation config.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoBranchCreationConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<AutoBranchCreationConfig.Builder, AutoBranchCreationConfig> {
    private static final SdkField<String> STAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AutoBranchCreationConfig::stageAsString)).setter(setter(Builder::stage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stage").build()).build();

    private static final SdkField<String> FRAMEWORK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AutoBranchCreationConfig::framework)).setter(setter(Builder::framework))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framework").build()).build();

    private static final SdkField<Boolean> ENABLE_AUTO_BUILD_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(AutoBranchCreationConfig::enableAutoBuild)).setter(setter(Builder::enableAutoBuild))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableAutoBuild").build()).build();

    private static final SdkField<Map<String, String>> ENVIRONMENT_VARIABLES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(AutoBranchCreationConfig::environmentVariables))
            .setter(setter(Builder::environmentVariables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentVariables").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> BASIC_AUTH_CREDENTIALS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AutoBranchCreationConfig::basicAuthCredentials)).setter(setter(Builder::basicAuthCredentials))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("basicAuthCredentials").build())
            .build();

    private static final SdkField<Boolean> ENABLE_BASIC_AUTH_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(AutoBranchCreationConfig::enableBasicAuth)).setter(setter(Builder::enableBasicAuth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableBasicAuth").build()).build();

    private static final SdkField<String> BUILD_SPEC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AutoBranchCreationConfig::buildSpec)).setter(setter(Builder::buildSpec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildSpec").build()).build();

    private static final SdkField<Boolean> ENABLE_PULL_REQUEST_PREVIEW_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).getter(getter(AutoBranchCreationConfig::enablePullRequestPreview))
            .setter(setter(Builder::enablePullRequestPreview))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enablePullRequestPreview").build())
            .build();

    private static final SdkField<String> PULL_REQUEST_ENVIRONMENT_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(AutoBranchCreationConfig::pullRequestEnvironmentName))
            .setter(setter(Builder::pullRequestEnvironmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullRequestEnvironmentName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STAGE_FIELD, FRAMEWORK_FIELD,
            ENABLE_AUTO_BUILD_FIELD, ENVIRONMENT_VARIABLES_FIELD, BASIC_AUTH_CREDENTIALS_FIELD, ENABLE_BASIC_AUTH_FIELD,
            BUILD_SPEC_FIELD, ENABLE_PULL_REQUEST_PREVIEW_FIELD, PULL_REQUEST_ENVIRONMENT_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String stage;

    private final String framework;

    private final Boolean enableAutoBuild;

    private final Map<String, String> environmentVariables;

    private final String basicAuthCredentials;

    private final Boolean enableBasicAuth;

    private final String buildSpec;

    private final Boolean enablePullRequestPreview;

    private final String pullRequestEnvironmentName;

    private AutoBranchCreationConfig(BuilderImpl builder) {
        this.stage = builder.stage;
        this.framework = builder.framework;
        this.enableAutoBuild = builder.enableAutoBuild;
        this.environmentVariables = builder.environmentVariables;
        this.basicAuthCredentials = builder.basicAuthCredentials;
        this.enableBasicAuth = builder.enableBasicAuth;
        this.buildSpec = builder.buildSpec;
        this.enablePullRequestPreview = builder.enablePullRequestPreview;
        this.pullRequestEnvironmentName = builder.pullRequestEnvironmentName;
    }

    /**
     * <p>
     * Stage for the auto created branch.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stage} will return
     * {@link Stage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stageAsString}.
     * </p>
     * 
     * @return Stage for the auto created branch.
     * @see Stage
     */
    public Stage stage() {
        return Stage.fromValue(stage);
    }

    /**
     * <p>
     * Stage for the auto created branch.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stage} will return
     * {@link Stage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stageAsString}.
     * </p>
     * 
     * @return Stage for the auto created branch.
     * @see Stage
     */
    public String stageAsString() {
        return stage;
    }

    /**
     * <p>
     * Framework for the auto created branch.
     * </p>
     * 
     * @return Framework for the auto created branch.
     */
    public String framework() {
        return framework;
    }

    /**
     * <p>
     * Enables auto building for the auto created branch.
     * </p>
     * 
     * @return Enables auto building for the auto created branch.
     */
    public Boolean enableAutoBuild() {
        return enableAutoBuild;
    }

    /**
     * Returns true if the EnvironmentVariables property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasEnvironmentVariables() {
        return environmentVariables != null && !(environmentVariables instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Environment Variables for the auto created branch.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEnvironmentVariables()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Environment Variables for the auto created branch.
     */
    public Map<String, String> environmentVariables() {
        return environmentVariables;
    }

    /**
     * <p>
     * Basic Authorization credentials for the auto created branch.
     * </p>
     * 
     * @return Basic Authorization credentials for the auto created branch.
     */
    public String basicAuthCredentials() {
        return basicAuthCredentials;
    }

    /**
     * <p>
     * Enables Basic Auth for the auto created branch.
     * </p>
     * 
     * @return Enables Basic Auth for the auto created branch.
     */
    public Boolean enableBasicAuth() {
        return enableBasicAuth;
    }

    /**
     * <p>
     * BuildSpec for the auto created branch.
     * </p>
     * 
     * @return BuildSpec for the auto created branch.
     */
    public String buildSpec() {
        return buildSpec;
    }

    /**
     * <p>
     * Enables Pull Request Preview for auto created branch.
     * </p>
     * 
     * @return Enables Pull Request Preview for auto created branch.
     */
    public Boolean enablePullRequestPreview() {
        return enablePullRequestPreview;
    }

    /**
     * <p>
     * The Amplify Environment name for the pull request.
     * </p>
     * 
     * @return The Amplify Environment name for the pull request.
     */
    public String pullRequestEnvironmentName() {
        return pullRequestEnvironmentName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(framework());
        hashCode = 31 * hashCode + Objects.hashCode(enableAutoBuild());
        hashCode = 31 * hashCode + Objects.hashCode(environmentVariables());
        hashCode = 31 * hashCode + Objects.hashCode(basicAuthCredentials());
        hashCode = 31 * hashCode + Objects.hashCode(enableBasicAuth());
        hashCode = 31 * hashCode + Objects.hashCode(buildSpec());
        hashCode = 31 * hashCode + Objects.hashCode(enablePullRequestPreview());
        hashCode = 31 * hashCode + Objects.hashCode(pullRequestEnvironmentName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoBranchCreationConfig)) {
            return false;
        }
        AutoBranchCreationConfig other = (AutoBranchCreationConfig) obj;
        return Objects.equals(stageAsString(), other.stageAsString()) && Objects.equals(framework(), other.framework())
                && Objects.equals(enableAutoBuild(), other.enableAutoBuild())
                && Objects.equals(environmentVariables(), other.environmentVariables())
                && Objects.equals(basicAuthCredentials(), other.basicAuthCredentials())
                && Objects.equals(enableBasicAuth(), other.enableBasicAuth()) && Objects.equals(buildSpec(), other.buildSpec())
                && Objects.equals(enablePullRequestPreview(), other.enablePullRequestPreview())
                && Objects.equals(pullRequestEnvironmentName(), other.pullRequestEnvironmentName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AutoBranchCreationConfig").add("Stage", stageAsString()).add("Framework", framework())
                .add("EnableAutoBuild", enableAutoBuild()).add("EnvironmentVariables", environmentVariables())
                .add("BasicAuthCredentials", basicAuthCredentials()).add("EnableBasicAuth", enableBasicAuth())
                .add("BuildSpec", buildSpec()).add("EnablePullRequestPreview", enablePullRequestPreview())
                .add("PullRequestEnvironmentName", pullRequestEnvironmentName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stage":
            return Optional.ofNullable(clazz.cast(stageAsString()));
        case "framework":
            return Optional.ofNullable(clazz.cast(framework()));
        case "enableAutoBuild":
            return Optional.ofNullable(clazz.cast(enableAutoBuild()));
        case "environmentVariables":
            return Optional.ofNullable(clazz.cast(environmentVariables()));
        case "basicAuthCredentials":
            return Optional.ofNullable(clazz.cast(basicAuthCredentials()));
        case "enableBasicAuth":
            return Optional.ofNullable(clazz.cast(enableBasicAuth()));
        case "buildSpec":
            return Optional.ofNullable(clazz.cast(buildSpec()));
        case "enablePullRequestPreview":
            return Optional.ofNullable(clazz.cast(enablePullRequestPreview()));
        case "pullRequestEnvironmentName":
            return Optional.ofNullable(clazz.cast(pullRequestEnvironmentName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoBranchCreationConfig, T> g) {
        return obj -> g.apply((AutoBranchCreationConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoBranchCreationConfig> {
        /**
         * <p>
         * Stage for the auto created branch.
         * </p>
         * 
         * @param stage
         *        Stage for the auto created branch.
         * @see Stage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Stage
         */
        Builder stage(String stage);

        /**
         * <p>
         * Stage for the auto created branch.
         * </p>
         * 
         * @param stage
         *        Stage for the auto created branch.
         * @see Stage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Stage
         */
        Builder stage(Stage stage);

        /**
         * <p>
         * Framework for the auto created branch.
         * </p>
         * 
         * @param framework
         *        Framework for the auto created branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder framework(String framework);

        /**
         * <p>
         * Enables auto building for the auto created branch.
         * </p>
         * 
         * @param enableAutoBuild
         *        Enables auto building for the auto created branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableAutoBuild(Boolean enableAutoBuild);

        /**
         * <p>
         * Environment Variables for the auto created branch.
         * </p>
         * 
         * @param environmentVariables
         *        Environment Variables for the auto created branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentVariables(Map<String, String> environmentVariables);

        /**
         * <p>
         * Basic Authorization credentials for the auto created branch.
         * </p>
         * 
         * @param basicAuthCredentials
         *        Basic Authorization credentials for the auto created branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder basicAuthCredentials(String basicAuthCredentials);

        /**
         * <p>
         * Enables Basic Auth for the auto created branch.
         * </p>
         * 
         * @param enableBasicAuth
         *        Enables Basic Auth for the auto created branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableBasicAuth(Boolean enableBasicAuth);

        /**
         * <p>
         * BuildSpec for the auto created branch.
         * </p>
         * 
         * @param buildSpec
         *        BuildSpec for the auto created branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buildSpec(String buildSpec);

        /**
         * <p>
         * Enables Pull Request Preview for auto created branch.
         * </p>
         * 
         * @param enablePullRequestPreview
         *        Enables Pull Request Preview for auto created branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enablePullRequestPreview(Boolean enablePullRequestPreview);

        /**
         * <p>
         * The Amplify Environment name for the pull request.
         * </p>
         * 
         * @param pullRequestEnvironmentName
         *        The Amplify Environment name for the pull request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pullRequestEnvironmentName(String pullRequestEnvironmentName);
    }

    static final class BuilderImpl implements Builder {
        private String stage;

        private String framework;

        private Boolean enableAutoBuild;

        private Map<String, String> environmentVariables = DefaultSdkAutoConstructMap.getInstance();

        private String basicAuthCredentials;

        private Boolean enableBasicAuth;

        private String buildSpec;

        private Boolean enablePullRequestPreview;

        private String pullRequestEnvironmentName;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoBranchCreationConfig model) {
            stage(model.stage);
            framework(model.framework);
            enableAutoBuild(model.enableAutoBuild);
            environmentVariables(model.environmentVariables);
            basicAuthCredentials(model.basicAuthCredentials);
            enableBasicAuth(model.enableBasicAuth);
            buildSpec(model.buildSpec);
            enablePullRequestPreview(model.enablePullRequestPreview);
            pullRequestEnvironmentName(model.pullRequestEnvironmentName);
        }

        public final String getStage() {
            return stage;
        }

        @Override
        public final Builder stage(String stage) {
            this.stage = stage;
            return this;
        }

        @Override
        public final Builder stage(Stage stage) {
            this.stage(stage == null ? null : stage.toString());
            return this;
        }

        public final void setStage(String stage) {
            this.stage = stage;
        }

        public final String getFramework() {
            return framework;
        }

        @Override
        public final Builder framework(String framework) {
            this.framework = framework;
            return this;
        }

        public final void setFramework(String framework) {
            this.framework = framework;
        }

        public final Boolean getEnableAutoBuild() {
            return enableAutoBuild;
        }

        @Override
        public final Builder enableAutoBuild(Boolean enableAutoBuild) {
            this.enableAutoBuild = enableAutoBuild;
            return this;
        }

        public final void setEnableAutoBuild(Boolean enableAutoBuild) {
            this.enableAutoBuild = enableAutoBuild;
        }

        public final Map<String, String> getEnvironmentVariables() {
            return environmentVariables;
        }

        @Override
        public final Builder environmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariablesCopier.copy(environmentVariables);
            return this;
        }

        public final void setEnvironmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariablesCopier.copy(environmentVariables);
        }

        public final String getBasicAuthCredentials() {
            return basicAuthCredentials;
        }

        @Override
        public final Builder basicAuthCredentials(String basicAuthCredentials) {
            this.basicAuthCredentials = basicAuthCredentials;
            return this;
        }

        public final void setBasicAuthCredentials(String basicAuthCredentials) {
            this.basicAuthCredentials = basicAuthCredentials;
        }

        public final Boolean getEnableBasicAuth() {
            return enableBasicAuth;
        }

        @Override
        public final Builder enableBasicAuth(Boolean enableBasicAuth) {
            this.enableBasicAuth = enableBasicAuth;
            return this;
        }

        public final void setEnableBasicAuth(Boolean enableBasicAuth) {
            this.enableBasicAuth = enableBasicAuth;
        }

        public final String getBuildSpec() {
            return buildSpec;
        }

        @Override
        public final Builder buildSpec(String buildSpec) {
            this.buildSpec = buildSpec;
            return this;
        }

        public final void setBuildSpec(String buildSpec) {
            this.buildSpec = buildSpec;
        }

        public final Boolean getEnablePullRequestPreview() {
            return enablePullRequestPreview;
        }

        @Override
        public final Builder enablePullRequestPreview(Boolean enablePullRequestPreview) {
            this.enablePullRequestPreview = enablePullRequestPreview;
            return this;
        }

        public final void setEnablePullRequestPreview(Boolean enablePullRequestPreview) {
            this.enablePullRequestPreview = enablePullRequestPreview;
        }

        public final String getPullRequestEnvironmentName() {
            return pullRequestEnvironmentName;
        }

        @Override
        public final Builder pullRequestEnvironmentName(String pullRequestEnvironmentName) {
            this.pullRequestEnvironmentName = pullRequestEnvironmentName;
            return this;
        }

        public final void setPullRequestEnvironmentName(String pullRequestEnvironmentName) {
            this.pullRequestEnvironmentName = pullRequestEnvironmentName;
        }

        @Override
        public AutoBranchCreationConfig build() {
            return new AutoBranchCreationConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
