/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amp.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.amp.model.AmpRequest;
import software.amazon.awssdk.services.amp.model.Destination;
import software.amazon.awssdk.services.amp.model.RoleConfiguration;
import software.amazon.awssdk.services.amp.model.ScrapeConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateScraperRequest
extends AmpRequest
implements ToCopyableBuilder<Builder, UpdateScraperRequest> {
    private static final SdkField<String> ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("alias").getter(UpdateScraperRequest.getter(UpdateScraperRequest::alias)).setter(UpdateScraperRequest.setter(Builder::alias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alias").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateScraperRequest.getter(UpdateScraperRequest::clientToken)).setter(UpdateScraperRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Destination> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("destination").getter(UpdateScraperRequest.getter(UpdateScraperRequest::destination)).setter(UpdateScraperRequest.setter(Builder::destination)).constructor(Destination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()}).build();
    private static final SdkField<RoleConfiguration> ROLE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("roleConfiguration").getter(UpdateScraperRequest.getter(UpdateScraperRequest::roleConfiguration)).setter(UpdateScraperRequest.setter(Builder::roleConfiguration)).constructor(RoleConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleConfiguration").build()}).build();
    private static final SdkField<ScrapeConfiguration> SCRAPE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("scrapeConfiguration").getter(UpdateScraperRequest.getter(UpdateScraperRequest::scrapeConfiguration)).setter(UpdateScraperRequest.setter(Builder::scrapeConfiguration)).constructor(ScrapeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scrapeConfiguration").build()}).build();
    private static final SdkField<String> SCRAPER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scraperId").getter(UpdateScraperRequest.getter(UpdateScraperRequest::scraperId)).setter(UpdateScraperRequest.setter(Builder::scraperId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("scraperId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIAS_FIELD, CLIENT_TOKEN_FIELD, DESTINATION_FIELD, ROLE_CONFIGURATION_FIELD, SCRAPE_CONFIGURATION_FIELD, SCRAPER_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateScraperRequest.memberNameToFieldInitializer();
    private final String alias;
    private final String clientToken;
    private final Destination destination;
    private final RoleConfiguration roleConfiguration;
    private final ScrapeConfiguration scrapeConfiguration;
    private final String scraperId;

    private UpdateScraperRequest(BuilderImpl builder) {
        super(builder);
        this.alias = builder.alias;
        this.clientToken = builder.clientToken;
        this.destination = builder.destination;
        this.roleConfiguration = builder.roleConfiguration;
        this.scrapeConfiguration = builder.scrapeConfiguration;
        this.scraperId = builder.scraperId;
    }

    public final String alias() {
        return this.alias;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final Destination destination() {
        return this.destination;
    }

    public final RoleConfiguration roleConfiguration() {
        return this.roleConfiguration;
    }

    public final ScrapeConfiguration scrapeConfiguration() {
        return this.scrapeConfiguration;
    }

    public final String scraperId() {
        return this.scraperId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.alias());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.scrapeConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.scraperId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateScraperRequest)) {
            return false;
        }
        UpdateScraperRequest other = (UpdateScraperRequest)((Object)obj);
        return Objects.equals(this.alias(), other.alias()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.destination(), other.destination()) && Objects.equals(this.roleConfiguration(), other.roleConfiguration()) && Objects.equals(this.scrapeConfiguration(), other.scrapeConfiguration()) && Objects.equals(this.scraperId(), other.scraperId());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateScraperRequest").add("Alias", (Object)this.alias()).add("ClientToken", (Object)this.clientToken()).add("Destination", (Object)this.destination()).add("RoleConfiguration", (Object)this.roleConfiguration()).add("ScrapeConfiguration", (Object)this.scrapeConfiguration()).add("ScraperId", (Object)this.scraperId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "alias": {
                return Optional.ofNullable(clazz.cast(this.alias()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "roleConfiguration": {
                return Optional.ofNullable(clazz.cast(this.roleConfiguration()));
            }
            case "scrapeConfiguration": {
                return Optional.ofNullable(clazz.cast(this.scrapeConfiguration()));
            }
            case "scraperId": {
                return Optional.ofNullable(clazz.cast(this.scraperId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("alias", ALIAS_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("destination", DESTINATION_FIELD);
        map.put("roleConfiguration", ROLE_CONFIGURATION_FIELD);
        map.put("scrapeConfiguration", SCRAPE_CONFIGURATION_FIELD);
        map.put("scraperId", SCRAPER_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateScraperRequest, T> g) {
        return obj -> g.apply((UpdateScraperRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AmpRequest.BuilderImpl
    implements Builder {
        private String alias;
        private String clientToken;
        private Destination destination;
        private RoleConfiguration roleConfiguration;
        private ScrapeConfiguration scrapeConfiguration;
        private String scraperId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateScraperRequest model) {
            super(model);
            this.alias(model.alias);
            this.clientToken(model.clientToken);
            this.destination(model.destination);
            this.roleConfiguration(model.roleConfiguration);
            this.scrapeConfiguration(model.scrapeConfiguration);
            this.scraperId(model.scraperId);
        }

        public final String getAlias() {
            return this.alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Destination.Builder getDestination() {
            return this.destination != null ? this.destination.toBuilder() : null;
        }

        public final void setDestination(Destination.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        public final Builder destination(Destination destination) {
            this.destination = destination;
            return this;
        }

        public final RoleConfiguration.Builder getRoleConfiguration() {
            return this.roleConfiguration != null ? this.roleConfiguration.toBuilder() : null;
        }

        public final void setRoleConfiguration(RoleConfiguration.BuilderImpl roleConfiguration) {
            this.roleConfiguration = roleConfiguration != null ? roleConfiguration.build() : null;
        }

        @Override
        public final Builder roleConfiguration(RoleConfiguration roleConfiguration) {
            this.roleConfiguration = roleConfiguration;
            return this;
        }

        public final ScrapeConfiguration.Builder getScrapeConfiguration() {
            return this.scrapeConfiguration != null ? this.scrapeConfiguration.toBuilder() : null;
        }

        public final void setScrapeConfiguration(ScrapeConfiguration.BuilderImpl scrapeConfiguration) {
            this.scrapeConfiguration = scrapeConfiguration != null ? scrapeConfiguration.build() : null;
        }

        @Override
        public final Builder scrapeConfiguration(ScrapeConfiguration scrapeConfiguration) {
            this.scrapeConfiguration = scrapeConfiguration;
            return this;
        }

        public final String getScraperId() {
            return this.scraperId;
        }

        public final void setScraperId(String scraperId) {
            this.scraperId = scraperId;
        }

        @Override
        public final Builder scraperId(String scraperId) {
            this.scraperId = scraperId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateScraperRequest build() {
            return new UpdateScraperRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AmpRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateScraperRequest> {
        public Builder alias(String var1);

        public Builder clientToken(String var1);

        public Builder destination(Destination var1);

        default public Builder destination(Consumer<Destination.Builder> destination) {
            return this.destination((Destination)((Destination.Builder)Destination.builder().applyMutation(destination)).build());
        }

        public Builder roleConfiguration(RoleConfiguration var1);

        default public Builder roleConfiguration(Consumer<RoleConfiguration.Builder> roleConfiguration) {
            return this.roleConfiguration((RoleConfiguration)((RoleConfiguration.Builder)RoleConfiguration.builder().applyMutation(roleConfiguration)).build());
        }

        public Builder scrapeConfiguration(ScrapeConfiguration var1);

        default public Builder scrapeConfiguration(Consumer<ScrapeConfiguration.Builder> scrapeConfiguration) {
            return this.scrapeConfiguration((ScrapeConfiguration)((ScrapeConfiguration.Builder)ScrapeConfiguration.builder().applyMutation(scrapeConfiguration)).build());
        }

        public Builder scraperId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

