/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amp.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.amp.AmpClient;
import software.amazon.awssdk.services.amp.internal.UserAgentUtils;
import software.amazon.awssdk.services.amp.model.ListScrapersRequest;
import software.amazon.awssdk.services.amp.model.ListScrapersResponse;
import software.amazon.awssdk.services.amp.model.ScraperSummary;

public class ListScrapersIterable
implements SdkIterable<ListScrapersResponse> {
    private final AmpClient client;
    private final ListScrapersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListScrapersIterable(AmpClient client, ListScrapersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListScrapersResponseFetcher();
    }

    public Iterator<ListScrapersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ScraperSummary> scrapers() {
        Function<ListScrapersResponse, Iterator> getIterator = response -> {
            if (response != null && response.scrapers() != null) {
                return response.scrapers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListScrapersResponseFetcher
    implements SyncPageFetcher<ListScrapersResponse> {
        private ListScrapersResponseFetcher() {
        }

        public boolean hasNextPage(ListScrapersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListScrapersResponse nextPage(ListScrapersResponse previousPage) {
            if (previousPage == null) {
                return ListScrapersIterable.this.client.listScrapers(ListScrapersIterable.this.firstRequest);
            }
            return ListScrapersIterable.this.client.listScrapers((ListScrapersRequest)((Object)ListScrapersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

