/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amp.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.amp.AmpAsyncClient;
import software.amazon.awssdk.services.amp.model.ListWorkspacesRequest;
import software.amazon.awssdk.services.amp.model.ListWorkspacesResponse;
import software.amazon.awssdk.services.amp.model.WorkspaceSummary;

public class ListWorkspacesPublisher
implements SdkPublisher<ListWorkspacesResponse> {
    private final AmpAsyncClient client;
    private final ListWorkspacesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListWorkspacesPublisher(AmpAsyncClient client, ListWorkspacesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListWorkspacesPublisher(AmpAsyncClient client, ListWorkspacesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListWorkspacesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListWorkspacesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<WorkspaceSummary> workspaces() {
        Function<ListWorkspacesResponse, Iterator> getIterator = response -> {
            if (response != null && response.workspaces() != null) {
                return response.workspaces().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListWorkspacesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListWorkspacesResponseFetcher
    implements AsyncPageFetcher<ListWorkspacesResponse> {
        private ListWorkspacesResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkspacesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListWorkspacesResponse> nextPage(ListWorkspacesResponse previousPage) {
            if (previousPage == null) {
                return ListWorkspacesPublisher.this.client.listWorkspaces(ListWorkspacesPublisher.this.firstRequest);
            }
            return ListWorkspacesPublisher.this.client.listWorkspaces((ListWorkspacesRequest)((Object)ListWorkspacesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

