/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amp.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the properties of a workspace.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkspaceDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<WorkspaceDescription.Builder, WorkspaceDescription> {
    private static final SdkField<String> ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("alias")
            .getter(getter(WorkspaceDescription::alias)).setter(setter(Builder::alias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alias").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(WorkspaceDescription::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(WorkspaceDescription::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> PROMETHEUS_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("prometheusEndpoint").getter(getter(WorkspaceDescription::prometheusEndpoint))
            .setter(setter(Builder::prometheusEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prometheusEndpoint").build())
            .build();

    private static final SdkField<WorkspaceStatus> STATUS_FIELD = SdkField.<WorkspaceStatus> builder(MarshallingType.SDK_POJO)
            .memberName("status").getter(getter(WorkspaceDescription::status)).setter(setter(Builder::status))
            .constructor(WorkspaceStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workspaceId").getter(getter(WorkspaceDescription::workspaceId)).setter(setter(Builder::workspaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workspaceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIAS_FIELD, ARN_FIELD,
            CREATED_AT_FIELD, PROMETHEUS_ENDPOINT_FIELD, STATUS_FIELD, WORKSPACE_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String alias;

    private final String arn;

    private final Instant createdAt;

    private final String prometheusEndpoint;

    private final WorkspaceStatus status;

    private final String workspaceId;

    private WorkspaceDescription(BuilderImpl builder) {
        this.alias = builder.alias;
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.prometheusEndpoint = builder.prometheusEndpoint;
        this.status = builder.status;
        this.workspaceId = builder.workspaceId;
    }

    /**
     * <p>
     * Alias of this workspace.
     * </p>
     * 
     * @return Alias of this workspace.
     */
    public final String alias() {
        return alias;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of this workspace.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of this workspace.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The time when the workspace was created.
     * </p>
     * 
     * @return The time when the workspace was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * Prometheus endpoint URI.
     * </p>
     * 
     * @return Prometheus endpoint URI.
     */
    public final String prometheusEndpoint() {
        return prometheusEndpoint;
    }

    /**
     * <p>
     * The status of this workspace.
     * </p>
     * 
     * @return The status of this workspace.
     */
    public final WorkspaceStatus status() {
        return status;
    }

    /**
     * <p>
     * Unique string identifying this workspace.
     * </p>
     * 
     * @return Unique string identifying this workspace.
     */
    public final String workspaceId() {
        return workspaceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(alias());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(prometheusEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(workspaceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkspaceDescription)) {
            return false;
        }
        WorkspaceDescription other = (WorkspaceDescription) obj;
        return Objects.equals(alias(), other.alias()) && Objects.equals(arn(), other.arn())
                && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(prometheusEndpoint(), other.prometheusEndpoint()) && Objects.equals(status(), other.status())
                && Objects.equals(workspaceId(), other.workspaceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkspaceDescription").add("Alias", alias()).add("Arn", arn()).add("CreatedAt", createdAt())
                .add("PrometheusEndpoint", prometheusEndpoint()).add("Status", status()).add("WorkspaceId", workspaceId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "alias":
            return Optional.ofNullable(clazz.cast(alias()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "prometheusEndpoint":
            return Optional.ofNullable(clazz.cast(prometheusEndpoint()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "workspaceId":
            return Optional.ofNullable(clazz.cast(workspaceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkspaceDescription, T> g) {
        return obj -> g.apply((WorkspaceDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkspaceDescription> {
        /**
         * <p>
         * Alias of this workspace.
         * </p>
         * 
         * @param alias
         *        Alias of this workspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alias(String alias);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of this workspace.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of this workspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The time when the workspace was created.
         * </p>
         * 
         * @param createdAt
         *        The time when the workspace was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * Prometheus endpoint URI.
         * </p>
         * 
         * @param prometheusEndpoint
         *        Prometheus endpoint URI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prometheusEndpoint(String prometheusEndpoint);

        /**
         * <p>
         * The status of this workspace.
         * </p>
         * 
         * @param status
         *        The status of this workspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(WorkspaceStatus status);

        /**
         * <p>
         * The status of this workspace.
         * </p>
         * This is a convenience that creates an instance of the {@link WorkspaceStatus.Builder} avoiding the need to
         * create one manually via {@link WorkspaceStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link WorkspaceStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #status(WorkspaceStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link WorkspaceStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(WorkspaceStatus)
         */
        default Builder status(Consumer<WorkspaceStatus.Builder> status) {
            return status(WorkspaceStatus.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * Unique string identifying this workspace.
         * </p>
         * 
         * @param workspaceId
         *        Unique string identifying this workspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceId(String workspaceId);
    }

    static final class BuilderImpl implements Builder {
        private String alias;

        private String arn;

        private Instant createdAt;

        private String prometheusEndpoint;

        private WorkspaceStatus status;

        private String workspaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkspaceDescription model) {
            alias(model.alias);
            arn(model.arn);
            createdAt(model.createdAt);
            prometheusEndpoint(model.prometheusEndpoint);
            status(model.status);
            workspaceId(model.workspaceId);
        }

        public final String getAlias() {
            return alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getPrometheusEndpoint() {
            return prometheusEndpoint;
        }

        @Override
        public final Builder prometheusEndpoint(String prometheusEndpoint) {
            this.prometheusEndpoint = prometheusEndpoint;
            return this;
        }

        public final void setPrometheusEndpoint(String prometheusEndpoint) {
            this.prometheusEndpoint = prometheusEndpoint;
        }

        public final WorkspaceStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        @Override
        public final Builder status(WorkspaceStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(WorkspaceStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        public final String getWorkspaceId() {
            return workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public WorkspaceDescription build() {
            return new WorkspaceDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
