/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.aiops.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateInvestigationGroupRequest extends AiOpsRequest implements
        ToCopyableBuilder<CreateInvestigationGroupRequest.Builder, CreateInvestigationGroupRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateInvestigationGroupRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(CreateInvestigationGroupRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<EncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField
            .<EncryptionConfiguration> builder(MarshallingType.SDK_POJO).memberName("encryptionConfiguration")
            .getter(getter(CreateInvestigationGroupRequest::encryptionConfiguration))
            .setter(setter(Builder::encryptionConfiguration)).constructor(EncryptionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionConfiguration").build())
            .build();

    private static final SdkField<Long> RETENTION_IN_DAYS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("retentionInDays").getter(getter(CreateInvestigationGroupRequest::retentionInDays))
            .setter(setter(Builder::retentionInDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retentionInDays").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateInvestigationGroupRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<String>> TAG_KEY_BOUNDARIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("tagKeyBoundaries")
            .getter(getter(CreateInvestigationGroupRequest::tagKeyBoundaries))
            .setter(setter(Builder::tagKeyBoundaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagKeyBoundaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, List<String>>> CHATBOT_NOTIFICATION_CHANNEL_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .memberName("chatbotNotificationChannel")
            .getter(getter(CreateInvestigationGroupRequest::chatbotNotificationChannel))
            .setter(setter(Builder::chatbotNotificationChannel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("chatbotNotificationChannel").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<Boolean> IS_CLOUD_TRAIL_EVENT_HISTORY_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isCloudTrailEventHistoryEnabled")
            .getter(getter(CreateInvestigationGroupRequest::isCloudTrailEventHistoryEnabled))
            .setter(setter(Builder::isCloudTrailEventHistoryEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isCloudTrailEventHistoryEnabled")
                    .build()).build();

    private static final SdkField<List<CrossAccountConfiguration>> CROSS_ACCOUNT_CONFIGURATIONS_FIELD = SdkField
            .<List<CrossAccountConfiguration>> builder(MarshallingType.LIST)
            .memberName("crossAccountConfigurations")
            .getter(getter(CreateInvestigationGroupRequest::crossAccountConfigurations))
            .setter(setter(Builder::crossAccountConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("crossAccountConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CrossAccountConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(CrossAccountConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ROLE_ARN_FIELD,
            ENCRYPTION_CONFIGURATION_FIELD, RETENTION_IN_DAYS_FIELD, TAGS_FIELD, TAG_KEY_BOUNDARIES_FIELD,
            CHATBOT_NOTIFICATION_CHANNEL_FIELD, IS_CLOUD_TRAIL_EVENT_HISTORY_ENABLED_FIELD, CROSS_ACCOUNT_CONFIGURATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String roleArn;

    private final EncryptionConfiguration encryptionConfiguration;

    private final Long retentionInDays;

    private final Map<String, String> tags;

    private final List<String> tagKeyBoundaries;

    private final Map<String, List<String>> chatbotNotificationChannel;

    private final Boolean isCloudTrailEventHistoryEnabled;

    private final List<CrossAccountConfiguration> crossAccountConfigurations;

    private CreateInvestigationGroupRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.roleArn = builder.roleArn;
        this.encryptionConfiguration = builder.encryptionConfiguration;
        this.retentionInDays = builder.retentionInDays;
        this.tags = builder.tags;
        this.tagKeyBoundaries = builder.tagKeyBoundaries;
        this.chatbotNotificationChannel = builder.chatbotNotificationChannel;
        this.isCloudTrailEventHistoryEnabled = builder.isCloudTrailEventHistoryEnabled;
        this.crossAccountConfigurations = builder.crossAccountConfigurations;
    }

    /**
     * <p>
     * Provides a name for the investigation group.
     * </p>
     * 
     * @return Provides a name for the investigation group.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Specify the ARN of the IAM role that CloudWatch investigations will use when it gathers investigation data. The
     * permissions in this role determine which of your resources that CloudWatch investigations will have access to
     * during investigations.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Investigations-Security.html#Investigations-Security-Data"
     * >How to control what data CloudWatch investigations has access to during investigations</a>.
     * </p>
     * 
     * @return Specify the ARN of the IAM role that CloudWatch investigations will use when it gathers investigation
     *         data. The permissions in this role determine which of your resources that CloudWatch investigations will
     *         have access to during investigations.</p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Investigations-Security.html#Investigations-Security-Data"
     *         >How to control what data CloudWatch investigations has access to during investigations</a>.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * Use this structure if you want to use a customer managed KMS key to encrypt your investigation data. If you omit
     * this parameter, CloudWatch investigations will use an Amazon Web Services key to encrypt the data. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Investigations-Security.html#Investigations-KMS"
     * >Encryption of investigation data</a>.
     * </p>
     * 
     * @return Use this structure if you want to use a customer managed KMS key to encrypt your investigation data. If
     *         you omit this parameter, CloudWatch investigations will use an Amazon Web Services key to encrypt the
     *         data. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Investigations-Security.html#Investigations-KMS"
     *         >Encryption of investigation data</a>.
     */
    public final EncryptionConfiguration encryptionConfiguration() {
        return encryptionConfiguration;
    }

    /**
     * <p>
     * Specify how long that investigation data is kept. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Investigations-Retention.html">Operational
     * investigation data retention</a>.
     * </p>
     * <p>
     * If you omit this parameter, the default of 90 days is used.
     * </p>
     * 
     * @return Specify how long that investigation data is kept. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Investigations-Retention.html"
     *         >Operational investigation data retention</a>. </p>
     *         <p>
     *         If you omit this parameter, the default of 90 days is used.
     */
    public final Long retentionInDays() {
        return retentionInDays;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of key-value pairs to associate with the investigation group. You can associate as many as 50 tags with an
     * investigation group. To be able to associate tags when you create the investigation group, you must have the
     * <code>cloudwatch:TagResource</code> permission.
     * </p>
     * <p>
     * Tags can help you organize and categorize your resources. You can also use them to scope user permissions by
     * granting a user permission to access or change only resources with certain tag values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of key-value pairs to associate with the investigation group. You can associate as many as 50 tags
     *         with an investigation group. To be able to associate tags when you create the investigation group, you
     *         must have the <code>cloudwatch:TagResource</code> permission.</p>
     *         <p>
     *         Tags can help you organize and categorize your resources. You can also use them to scope user permissions
     *         by granting a user permission to access or change only resources with certain tag values.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagKeyBoundaries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTagKeyBoundaries() {
        return tagKeyBoundaries != null && !(tagKeyBoundaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Enter the existing custom tag keys for custom applications in your system. Resource tags help CloudWatch
     * investigations narrow the search space when it is unable to discover definite relationships between resources.
     * For example, to discover that an Amazon ECS service depends on an Amazon RDS database, CloudWatch investigations
     * can discover this relationship using data sources such as X-Ray and CloudWatch Application Signals. However, if
     * you haven't deployed these features, CloudWatch investigations will attempt to identify possible relationships.
     * Tag boundaries can be used to narrow the resources that will be discovered by CloudWatch investigations in these
     * cases.
     * </p>
     * <p>
     * You don't need to enter tags created by myApplications or CloudFormation, because CloudWatch investigations can
     * automatically detect those tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagKeyBoundaries} method.
     * </p>
     * 
     * @return Enter the existing custom tag keys for custom applications in your system. Resource tags help CloudWatch
     *         investigations narrow the search space when it is unable to discover definite relationships between
     *         resources. For example, to discover that an Amazon ECS service depends on an Amazon RDS database,
     *         CloudWatch investigations can discover this relationship using data sources such as X-Ray and CloudWatch
     *         Application Signals. However, if you haven't deployed these features, CloudWatch investigations will
     *         attempt to identify possible relationships. Tag boundaries can be used to narrow the resources that will
     *         be discovered by CloudWatch investigations in these cases.</p>
     *         <p>
     *         You don't need to enter tags created by myApplications or CloudFormation, because CloudWatch
     *         investigations can automatically detect those tags.
     */
    public final List<String> tagKeyBoundaries() {
        return tagKeyBoundaries;
    }

    /**
     * For responses, this returns true if the service returned a value for the ChatbotNotificationChannel property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasChatbotNotificationChannel() {
        return chatbotNotificationChannel != null && !(chatbotNotificationChannel instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Use this structure to integrate CloudWatch investigations with chat applications. This structure is a string
     * array. For the first string, specify the ARN of an Amazon SNS topic. For the array of strings, specify the ARNs
     * of one or more chat applications configurations that you want to associate with that topic. For more information
     * about these configuration ARNs, see <a
     * href="https://docs.aws.amazon.com/chatbot/latest/adminguide/getting-started.html">Getting started with Amazon Q
     * in chat applications</a> and <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awschatbot.html#awschatbot-resources-for-iam-policies"
     * >Resource type defined by Amazon Web Services Chatbot</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChatbotNotificationChannel} method.
     * </p>
     * 
     * @return Use this structure to integrate CloudWatch investigations with chat applications. This structure is a
     *         string array. For the first string, specify the ARN of an Amazon SNS topic. For the array of strings,
     *         specify the ARNs of one or more chat applications configurations that you want to associate with that
     *         topic. For more information about these configuration ARNs, see <a
     *         href="https://docs.aws.amazon.com/chatbot/latest/adminguide/getting-started.html">Getting started with
     *         Amazon Q in chat applications</a> and <a href=
     *         "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awschatbot.html#awschatbot-resources-for-iam-policies"
     *         >Resource type defined by Amazon Web Services Chatbot</a>.
     */
    public final Map<String, List<String>> chatbotNotificationChannel() {
        return chatbotNotificationChannel;
    }

    /**
     * <p>
     * Specify <code>true</code> to enable CloudWatch investigations to have access to change events that are recorded
     * by CloudTrail. The default is <code>true</code>.
     * </p>
     * 
     * @return Specify <code>true</code> to enable CloudWatch investigations to have access to change events that are
     *         recorded by CloudTrail. The default is <code>true</code>.
     */
    public final Boolean isCloudTrailEventHistoryEnabled() {
        return isCloudTrailEventHistoryEnabled;
    }

    /**
     * For responses, this returns true if the service returned a value for the CrossAccountConfigurations property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCrossAccountConfigurations() {
        return crossAccountConfigurations != null && !(crossAccountConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of <code>sourceRoleArn</code> values that have been configured for cross-account access.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCrossAccountConfigurations} method.
     * </p>
     * 
     * @return List of <code>sourceRoleArn</code> values that have been configured for cross-account access.
     */
    public final List<CrossAccountConfiguration> crossAccountConfigurations() {
        return crossAccountConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(retentionInDays());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTagKeyBoundaries() ? tagKeyBoundaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasChatbotNotificationChannel() ? chatbotNotificationChannel() : null);
        hashCode = 31 * hashCode + Objects.hashCode(isCloudTrailEventHistoryEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(hasCrossAccountConfigurations() ? crossAccountConfigurations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInvestigationGroupRequest)) {
            return false;
        }
        CreateInvestigationGroupRequest other = (CreateInvestigationGroupRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(encryptionConfiguration(), other.encryptionConfiguration())
                && Objects.equals(retentionInDays(), other.retentionInDays()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && hasTagKeyBoundaries() == other.hasTagKeyBoundaries()
                && Objects.equals(tagKeyBoundaries(), other.tagKeyBoundaries())
                && hasChatbotNotificationChannel() == other.hasChatbotNotificationChannel()
                && Objects.equals(chatbotNotificationChannel(), other.chatbotNotificationChannel())
                && Objects.equals(isCloudTrailEventHistoryEnabled(), other.isCloudTrailEventHistoryEnabled())
                && hasCrossAccountConfigurations() == other.hasCrossAccountConfigurations()
                && Objects.equals(crossAccountConfigurations(), other.crossAccountConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateInvestigationGroupRequest").add("Name", name()).add("RoleArn", roleArn())
                .add("EncryptionConfiguration", encryptionConfiguration()).add("RetentionInDays", retentionInDays())
                .add("Tags", hasTags() ? tags() : null)
                .add("TagKeyBoundaries", hasTagKeyBoundaries() ? tagKeyBoundaries() : null)
                .add("ChatbotNotificationChannel", hasChatbotNotificationChannel() ? chatbotNotificationChannel() : null)
                .add("IsCloudTrailEventHistoryEnabled", isCloudTrailEventHistoryEnabled())
                .add("CrossAccountConfigurations", hasCrossAccountConfigurations() ? crossAccountConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "encryptionConfiguration":
            return Optional.ofNullable(clazz.cast(encryptionConfiguration()));
        case "retentionInDays":
            return Optional.ofNullable(clazz.cast(retentionInDays()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "tagKeyBoundaries":
            return Optional.ofNullable(clazz.cast(tagKeyBoundaries()));
        case "chatbotNotificationChannel":
            return Optional.ofNullable(clazz.cast(chatbotNotificationChannel()));
        case "isCloudTrailEventHistoryEnabled":
            return Optional.ofNullable(clazz.cast(isCloudTrailEventHistoryEnabled()));
        case "crossAccountConfigurations":
            return Optional.ofNullable(clazz.cast(crossAccountConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("encryptionConfiguration", ENCRYPTION_CONFIGURATION_FIELD);
        map.put("retentionInDays", RETENTION_IN_DAYS_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("tagKeyBoundaries", TAG_KEY_BOUNDARIES_FIELD);
        map.put("chatbotNotificationChannel", CHATBOT_NOTIFICATION_CHANNEL_FIELD);
        map.put("isCloudTrailEventHistoryEnabled", IS_CLOUD_TRAIL_EVENT_HISTORY_ENABLED_FIELD);
        map.put("crossAccountConfigurations", CROSS_ACCOUNT_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateInvestigationGroupRequest, T> g) {
        return obj -> g.apply((CreateInvestigationGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AiOpsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateInvestigationGroupRequest> {
        /**
         * <p>
         * Provides a name for the investigation group.
         * </p>
         * 
         * @param name
         *        Provides a name for the investigation group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Specify the ARN of the IAM role that CloudWatch investigations will use when it gathers investigation data.
         * The permissions in this role determine which of your resources that CloudWatch investigations will have
         * access to during investigations.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Investigations-Security.html#Investigations-Security-Data"
         * >How to control what data CloudWatch investigations has access to during investigations</a>.
         * </p>
         * 
         * @param roleArn
         *        Specify the ARN of the IAM role that CloudWatch investigations will use when it gathers investigation
         *        data. The permissions in this role determine which of your resources that CloudWatch investigations
         *        will have access to during investigations.</p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Investigations-Security.html#Investigations-Security-Data"
         *        >How to control what data CloudWatch investigations has access to during investigations</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * Use this structure if you want to use a customer managed KMS key to encrypt your investigation data. If you
         * omit this parameter, CloudWatch investigations will use an Amazon Web Services key to encrypt the data. For
         * more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Investigations-Security.html#Investigations-KMS"
         * >Encryption of investigation data</a>.
         * </p>
         * 
         * @param encryptionConfiguration
         *        Use this structure if you want to use a customer managed KMS key to encrypt your investigation data.
         *        If you omit this parameter, CloudWatch investigations will use an Amazon Web Services key to encrypt
         *        the data. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Investigations-Security.html#Investigations-KMS"
         *        >Encryption of investigation data</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration);

        /**
         * <p>
         * Use this structure if you want to use a customer managed KMS key to encrypt your investigation data. If you
         * omit this parameter, CloudWatch investigations will use an Amazon Web Services key to encrypt the data. For
         * more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Investigations-Security.html#Investigations-KMS"
         * >Encryption of investigation data</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link EncryptionConfiguration.Builder} avoiding
         * the need to create one manually via {@link EncryptionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EncryptionConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #encryptionConfiguration(EncryptionConfiguration)}.
         * 
         * @param encryptionConfiguration
         *        a consumer that will call methods on {@link EncryptionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionConfiguration(EncryptionConfiguration)
         */
        default Builder encryptionConfiguration(Consumer<EncryptionConfiguration.Builder> encryptionConfiguration) {
            return encryptionConfiguration(EncryptionConfiguration.builder().applyMutation(encryptionConfiguration).build());
        }

        /**
         * <p>
         * Specify how long that investigation data is kept. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Investigations-Retention.html"
         * >Operational investigation data retention</a>.
         * </p>
         * <p>
         * If you omit this parameter, the default of 90 days is used.
         * </p>
         * 
         * @param retentionInDays
         *        Specify how long that investigation data is kept. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Investigations-Retention.html"
         *        >Operational investigation data retention</a>. </p>
         *        <p>
         *        If you omit this parameter, the default of 90 days is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionInDays(Long retentionInDays);

        /**
         * <p>
         * A list of key-value pairs to associate with the investigation group. You can associate as many as 50 tags
         * with an investigation group. To be able to associate tags when you create the investigation group, you must
         * have the <code>cloudwatch:TagResource</code> permission.
         * </p>
         * <p>
         * Tags can help you organize and categorize your resources. You can also use them to scope user permissions by
         * granting a user permission to access or change only resources with certain tag values.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs to associate with the investigation group. You can associate as many as 50
         *        tags with an investigation group. To be able to associate tags when you create the investigation
         *        group, you must have the <code>cloudwatch:TagResource</code> permission.</p>
         *        <p>
         *        Tags can help you organize and categorize your resources. You can also use them to scope user
         *        permissions by granting a user permission to access or change only resources with certain tag values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * Enter the existing custom tag keys for custom applications in your system. Resource tags help CloudWatch
         * investigations narrow the search space when it is unable to discover definite relationships between
         * resources. For example, to discover that an Amazon ECS service depends on an Amazon RDS database, CloudWatch
         * investigations can discover this relationship using data sources such as X-Ray and CloudWatch Application
         * Signals. However, if you haven't deployed these features, CloudWatch investigations will attempt to identify
         * possible relationships. Tag boundaries can be used to narrow the resources that will be discovered by
         * CloudWatch investigations in these cases.
         * </p>
         * <p>
         * You don't need to enter tags created by myApplications or CloudFormation, because CloudWatch investigations
         * can automatically detect those tags.
         * </p>
         * 
         * @param tagKeyBoundaries
         *        Enter the existing custom tag keys for custom applications in your system. Resource tags help
         *        CloudWatch investigations narrow the search space when it is unable to discover definite relationships
         *        between resources. For example, to discover that an Amazon ECS service depends on an Amazon RDS
         *        database, CloudWatch investigations can discover this relationship using data sources such as X-Ray
         *        and CloudWatch Application Signals. However, if you haven't deployed these features, CloudWatch
         *        investigations will attempt to identify possible relationships. Tag boundaries can be used to narrow
         *        the resources that will be discovered by CloudWatch investigations in these cases.</p>
         *        <p>
         *        You don't need to enter tags created by myApplications or CloudFormation, because CloudWatch
         *        investigations can automatically detect those tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagKeyBoundaries(Collection<String> tagKeyBoundaries);

        /**
         * <p>
         * Enter the existing custom tag keys for custom applications in your system. Resource tags help CloudWatch
         * investigations narrow the search space when it is unable to discover definite relationships between
         * resources. For example, to discover that an Amazon ECS service depends on an Amazon RDS database, CloudWatch
         * investigations can discover this relationship using data sources such as X-Ray and CloudWatch Application
         * Signals. However, if you haven't deployed these features, CloudWatch investigations will attempt to identify
         * possible relationships. Tag boundaries can be used to narrow the resources that will be discovered by
         * CloudWatch investigations in these cases.
         * </p>
         * <p>
         * You don't need to enter tags created by myApplications or CloudFormation, because CloudWatch investigations
         * can automatically detect those tags.
         * </p>
         * 
         * @param tagKeyBoundaries
         *        Enter the existing custom tag keys for custom applications in your system. Resource tags help
         *        CloudWatch investigations narrow the search space when it is unable to discover definite relationships
         *        between resources. For example, to discover that an Amazon ECS service depends on an Amazon RDS
         *        database, CloudWatch investigations can discover this relationship using data sources such as X-Ray
         *        and CloudWatch Application Signals. However, if you haven't deployed these features, CloudWatch
         *        investigations will attempt to identify possible relationships. Tag boundaries can be used to narrow
         *        the resources that will be discovered by CloudWatch investigations in these cases.</p>
         *        <p>
         *        You don't need to enter tags created by myApplications or CloudFormation, because CloudWatch
         *        investigations can automatically detect those tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagKeyBoundaries(String... tagKeyBoundaries);

        /**
         * <p>
         * Use this structure to integrate CloudWatch investigations with chat applications. This structure is a string
         * array. For the first string, specify the ARN of an Amazon SNS topic. For the array of strings, specify the
         * ARNs of one or more chat applications configurations that you want to associate with that topic. For more
         * information about these configuration ARNs, see <a
         * href="https://docs.aws.amazon.com/chatbot/latest/adminguide/getting-started.html">Getting started with Amazon
         * Q in chat applications</a> and <a href=
         * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awschatbot.html#awschatbot-resources-for-iam-policies"
         * >Resource type defined by Amazon Web Services Chatbot</a>.
         * </p>
         * 
         * @param chatbotNotificationChannel
         *        Use this structure to integrate CloudWatch investigations with chat applications. This structure is a
         *        string array. For the first string, specify the ARN of an Amazon SNS topic. For the array of strings,
         *        specify the ARNs of one or more chat applications configurations that you want to associate with that
         *        topic. For more information about these configuration ARNs, see <a
         *        href="https://docs.aws.amazon.com/chatbot/latest/adminguide/getting-started.html">Getting started with
         *        Amazon Q in chat applications</a> and <a href=
         *        "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awschatbot.html#awschatbot-resources-for-iam-policies"
         *        >Resource type defined by Amazon Web Services Chatbot</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chatbotNotificationChannel(Map<String, ? extends Collection<String>> chatbotNotificationChannel);

        /**
         * <p>
         * Specify <code>true</code> to enable CloudWatch investigations to have access to change events that are
         * recorded by CloudTrail. The default is <code>true</code>.
         * </p>
         * 
         * @param isCloudTrailEventHistoryEnabled
         *        Specify <code>true</code> to enable CloudWatch investigations to have access to change events that are
         *        recorded by CloudTrail. The default is <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isCloudTrailEventHistoryEnabled(Boolean isCloudTrailEventHistoryEnabled);

        /**
         * <p>
         * List of <code>sourceRoleArn</code> values that have been configured for cross-account access.
         * </p>
         * 
         * @param crossAccountConfigurations
         *        List of <code>sourceRoleArn</code> values that have been configured for cross-account access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crossAccountConfigurations(Collection<CrossAccountConfiguration> crossAccountConfigurations);

        /**
         * <p>
         * List of <code>sourceRoleArn</code> values that have been configured for cross-account access.
         * </p>
         * 
         * @param crossAccountConfigurations
         *        List of <code>sourceRoleArn</code> values that have been configured for cross-account access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crossAccountConfigurations(CrossAccountConfiguration... crossAccountConfigurations);

        /**
         * <p>
         * List of <code>sourceRoleArn</code> values that have been configured for cross-account access.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.aiops.model.CrossAccountConfiguration.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.aiops.model.CrossAccountConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.aiops.model.CrossAccountConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #crossAccountConfigurations(List<CrossAccountConfiguration>)}.
         * 
         * @param crossAccountConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.aiops.model.CrossAccountConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #crossAccountConfigurations(java.util.Collection<CrossAccountConfiguration>)
         */
        Builder crossAccountConfigurations(Consumer<CrossAccountConfiguration.Builder>... crossAccountConfigurations);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AiOpsRequest.BuilderImpl implements Builder {
        private String name;

        private String roleArn;

        private EncryptionConfiguration encryptionConfiguration;

        private Long retentionInDays;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private List<String> tagKeyBoundaries = DefaultSdkAutoConstructList.getInstance();

        private Map<String, List<String>> chatbotNotificationChannel = DefaultSdkAutoConstructMap.getInstance();

        private Boolean isCloudTrailEventHistoryEnabled;

        private List<CrossAccountConfiguration> crossAccountConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInvestigationGroupRequest model) {
            super(model);
            name(model.name);
            roleArn(model.roleArn);
            encryptionConfiguration(model.encryptionConfiguration);
            retentionInDays(model.retentionInDays);
            tags(model.tags);
            tagKeyBoundaries(model.tagKeyBoundaries);
            chatbotNotificationChannel(model.chatbotNotificationChannel);
            isCloudTrailEventHistoryEnabled(model.isCloudTrailEventHistoryEnabled);
            crossAccountConfigurations(model.crossAccountConfigurations);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return encryptionConfiguration != null ? encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public final Long getRetentionInDays() {
            return retentionInDays;
        }

        public final void setRetentionInDays(Long retentionInDays) {
            this.retentionInDays = retentionInDays;
        }

        @Override
        public final Builder retentionInDays(Long retentionInDays) {
            this.retentionInDays = retentionInDays;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final Collection<String> getTagKeyBoundaries() {
            if (tagKeyBoundaries instanceof SdkAutoConstructList) {
                return null;
            }
            return tagKeyBoundaries;
        }

        public final void setTagKeyBoundaries(Collection<String> tagKeyBoundaries) {
            this.tagKeyBoundaries = TagKeyBoundariesCopier.copy(tagKeyBoundaries);
        }

        @Override
        public final Builder tagKeyBoundaries(Collection<String> tagKeyBoundaries) {
            this.tagKeyBoundaries = TagKeyBoundariesCopier.copy(tagKeyBoundaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagKeyBoundaries(String... tagKeyBoundaries) {
            tagKeyBoundaries(Arrays.asList(tagKeyBoundaries));
            return this;
        }

        public final Map<String, ? extends Collection<String>> getChatbotNotificationChannel() {
            if (chatbotNotificationChannel instanceof SdkAutoConstructMap) {
                return null;
            }
            return chatbotNotificationChannel;
        }

        public final void setChatbotNotificationChannel(Map<String, ? extends Collection<String>> chatbotNotificationChannel) {
            this.chatbotNotificationChannel = ChatbotNotificationChannelCopier.copy(chatbotNotificationChannel);
        }

        @Override
        public final Builder chatbotNotificationChannel(Map<String, ? extends Collection<String>> chatbotNotificationChannel) {
            this.chatbotNotificationChannel = ChatbotNotificationChannelCopier.copy(chatbotNotificationChannel);
            return this;
        }

        public final Boolean getIsCloudTrailEventHistoryEnabled() {
            return isCloudTrailEventHistoryEnabled;
        }

        public final void setIsCloudTrailEventHistoryEnabled(Boolean isCloudTrailEventHistoryEnabled) {
            this.isCloudTrailEventHistoryEnabled = isCloudTrailEventHistoryEnabled;
        }

        @Override
        public final Builder isCloudTrailEventHistoryEnabled(Boolean isCloudTrailEventHistoryEnabled) {
            this.isCloudTrailEventHistoryEnabled = isCloudTrailEventHistoryEnabled;
            return this;
        }

        public final List<CrossAccountConfiguration.Builder> getCrossAccountConfigurations() {
            List<CrossAccountConfiguration.Builder> result = CrossAccountConfigurationsCopier
                    .copyToBuilder(this.crossAccountConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCrossAccountConfigurations(
                Collection<CrossAccountConfiguration.BuilderImpl> crossAccountConfigurations) {
            this.crossAccountConfigurations = CrossAccountConfigurationsCopier.copyFromBuilder(crossAccountConfigurations);
        }

        @Override
        public final Builder crossAccountConfigurations(Collection<CrossAccountConfiguration> crossAccountConfigurations) {
            this.crossAccountConfigurations = CrossAccountConfigurationsCopier.copy(crossAccountConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crossAccountConfigurations(CrossAccountConfiguration... crossAccountConfigurations) {
            crossAccountConfigurations(Arrays.asList(crossAccountConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crossAccountConfigurations(Consumer<CrossAccountConfiguration.Builder>... crossAccountConfigurations) {
            crossAccountConfigurations(Stream.of(crossAccountConfigurations)
                    .map(c -> CrossAccountConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateInvestigationGroupRequest build() {
            return new CreateInvestigationGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
