/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.aiops.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.aiops.AiOpsAsyncClient;
import software.amazon.awssdk.services.aiops.internal.UserAgentUtils;
import software.amazon.awssdk.services.aiops.model.ListInvestigationGroupsModel;
import software.amazon.awssdk.services.aiops.model.ListInvestigationGroupsRequest;
import software.amazon.awssdk.services.aiops.model.ListInvestigationGroupsResponse;

public class ListInvestigationGroupsPublisher
implements SdkPublisher<ListInvestigationGroupsResponse> {
    private final AiOpsAsyncClient client;
    private final ListInvestigationGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListInvestigationGroupsPublisher(AiOpsAsyncClient client, ListInvestigationGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListInvestigationGroupsPublisher(AiOpsAsyncClient client, ListInvestigationGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListInvestigationGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListInvestigationGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ListInvestigationGroupsModel> investigationGroups() {
        Function<ListInvestigationGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.investigationGroups() != null) {
                return response.investigationGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListInvestigationGroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListInvestigationGroupsResponseFetcher
    implements AsyncPageFetcher<ListInvestigationGroupsResponse> {
        private ListInvestigationGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListInvestigationGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListInvestigationGroupsResponse> nextPage(ListInvestigationGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListInvestigationGroupsPublisher.this.client.listInvestigationGroups(ListInvestigationGroupsPublisher.this.firstRequest);
            }
            return ListInvestigationGroupsPublisher.this.client.listInvestigationGroups((ListInvestigationGroupsRequest)((Object)ListInvestigationGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

