/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.aiops.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.aiops.model.AiOpsResponse;
import software.amazon.awssdk.services.aiops.model.InvestigationGroupsCopier;
import software.amazon.awssdk.services.aiops.model.ListInvestigationGroupsModel;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListInvestigationGroupsResponse
extends AiOpsResponse
implements ToCopyableBuilder<Builder, ListInvestigationGroupsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListInvestigationGroupsResponse.getter(ListInvestigationGroupsResponse::nextToken)).setter(ListInvestigationGroupsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<ListInvestigationGroupsModel>> INVESTIGATION_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("investigationGroups").getter(ListInvestigationGroupsResponse.getter(ListInvestigationGroupsResponse::investigationGroups)).setter(ListInvestigationGroupsResponse.setter(Builder::investigationGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("investigationGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ListInvestigationGroupsModel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, INVESTIGATION_GROUPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListInvestigationGroupsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<ListInvestigationGroupsModel> investigationGroups;

    private ListInvestigationGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.investigationGroups = builder.investigationGroups;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasInvestigationGroups() {
        return this.investigationGroups != null && !(this.investigationGroups instanceof SdkAutoConstructList);
    }

    public final List<ListInvestigationGroupsModel> investigationGroups() {
        return this.investigationGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInvestigationGroups() ? this.investigationGroups() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInvestigationGroupsResponse)) {
            return false;
        }
        ListInvestigationGroupsResponse other = (ListInvestigationGroupsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasInvestigationGroups() == other.hasInvestigationGroups() && Objects.equals(this.investigationGroups(), other.investigationGroups());
    }

    public final String toString() {
        return ToString.builder((String)"ListInvestigationGroupsResponse").add("NextToken", (Object)(this.nextToken() == null ? null : "*** Sensitive Data Redacted ***")).add("InvestigationGroups", this.hasInvestigationGroups() ? this.investigationGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "investigationGroups": {
                return Optional.ofNullable(clazz.cast(this.investigationGroups()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("investigationGroups", INVESTIGATION_GROUPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListInvestigationGroupsResponse, T> g) {
        return obj -> g.apply((ListInvestigationGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AiOpsResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ListInvestigationGroupsModel> investigationGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListInvestigationGroupsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.investigationGroups(model.investigationGroups);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ListInvestigationGroupsModel.Builder> getInvestigationGroups() {
            List<ListInvestigationGroupsModel.Builder> result = InvestigationGroupsCopier.copyToBuilder(this.investigationGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInvestigationGroups(Collection<ListInvestigationGroupsModel.BuilderImpl> investigationGroups) {
            this.investigationGroups = InvestigationGroupsCopier.copyFromBuilder(investigationGroups);
        }

        @Override
        public final Builder investigationGroups(Collection<ListInvestigationGroupsModel> investigationGroups) {
            this.investigationGroups = InvestigationGroupsCopier.copy(investigationGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder investigationGroups(ListInvestigationGroupsModel ... investigationGroups) {
            this.investigationGroups(Arrays.asList(investigationGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder investigationGroups(Consumer<ListInvestigationGroupsModel.Builder> ... investigationGroups) {
            this.investigationGroups(Stream.of(investigationGroups).map(c -> (ListInvestigationGroupsModel)((ListInvestigationGroupsModel.Builder)ListInvestigationGroupsModel.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListInvestigationGroupsResponse build() {
            return new ListInvestigationGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AiOpsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListInvestigationGroupsResponse> {
        public Builder nextToken(String var1);

        public Builder investigationGroups(Collection<ListInvestigationGroupsModel> var1);

        public Builder investigationGroups(ListInvestigationGroupsModel ... var1);

        public Builder investigationGroups(Consumer<ListInvestigationGroupsModel.Builder> ... var1);
    }
}

