/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acmpca;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.acmpca.AcmPcaClient;
import software.amazon.awssdk.services.acmpca.AcmPcaServiceClientConfiguration;
import software.amazon.awssdk.services.acmpca.internal.AcmPcaServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.acmpca.model.AcmPcaException;
import software.amazon.awssdk.services.acmpca.model.CertificateMismatchException;
import software.amazon.awssdk.services.acmpca.model.ConcurrentModificationException;
import software.amazon.awssdk.services.acmpca.model.CreateCertificateAuthorityAuditReportRequest;
import software.amazon.awssdk.services.acmpca.model.CreateCertificateAuthorityAuditReportResponse;
import software.amazon.awssdk.services.acmpca.model.CreateCertificateAuthorityRequest;
import software.amazon.awssdk.services.acmpca.model.CreateCertificateAuthorityResponse;
import software.amazon.awssdk.services.acmpca.model.CreatePermissionRequest;
import software.amazon.awssdk.services.acmpca.model.CreatePermissionResponse;
import software.amazon.awssdk.services.acmpca.model.DeleteCertificateAuthorityRequest;
import software.amazon.awssdk.services.acmpca.model.DeleteCertificateAuthorityResponse;
import software.amazon.awssdk.services.acmpca.model.DeletePermissionRequest;
import software.amazon.awssdk.services.acmpca.model.DeletePermissionResponse;
import software.amazon.awssdk.services.acmpca.model.DeletePolicyRequest;
import software.amazon.awssdk.services.acmpca.model.DeletePolicyResponse;
import software.amazon.awssdk.services.acmpca.model.DescribeCertificateAuthorityAuditReportRequest;
import software.amazon.awssdk.services.acmpca.model.DescribeCertificateAuthorityAuditReportResponse;
import software.amazon.awssdk.services.acmpca.model.DescribeCertificateAuthorityRequest;
import software.amazon.awssdk.services.acmpca.model.DescribeCertificateAuthorityResponse;
import software.amazon.awssdk.services.acmpca.model.GetCertificateAuthorityCertificateRequest;
import software.amazon.awssdk.services.acmpca.model.GetCertificateAuthorityCertificateResponse;
import software.amazon.awssdk.services.acmpca.model.GetCertificateAuthorityCsrRequest;
import software.amazon.awssdk.services.acmpca.model.GetCertificateAuthorityCsrResponse;
import software.amazon.awssdk.services.acmpca.model.GetCertificateRequest;
import software.amazon.awssdk.services.acmpca.model.GetCertificateResponse;
import software.amazon.awssdk.services.acmpca.model.GetPolicyRequest;
import software.amazon.awssdk.services.acmpca.model.GetPolicyResponse;
import software.amazon.awssdk.services.acmpca.model.ImportCertificateAuthorityCertificateRequest;
import software.amazon.awssdk.services.acmpca.model.ImportCertificateAuthorityCertificateResponse;
import software.amazon.awssdk.services.acmpca.model.InvalidArgsException;
import software.amazon.awssdk.services.acmpca.model.InvalidArnException;
import software.amazon.awssdk.services.acmpca.model.InvalidNextTokenException;
import software.amazon.awssdk.services.acmpca.model.InvalidPolicyException;
import software.amazon.awssdk.services.acmpca.model.InvalidRequestException;
import software.amazon.awssdk.services.acmpca.model.InvalidStateException;
import software.amazon.awssdk.services.acmpca.model.InvalidTagException;
import software.amazon.awssdk.services.acmpca.model.IssueCertificateRequest;
import software.amazon.awssdk.services.acmpca.model.IssueCertificateResponse;
import software.amazon.awssdk.services.acmpca.model.LimitExceededException;
import software.amazon.awssdk.services.acmpca.model.ListCertificateAuthoritiesRequest;
import software.amazon.awssdk.services.acmpca.model.ListCertificateAuthoritiesResponse;
import software.amazon.awssdk.services.acmpca.model.ListPermissionsRequest;
import software.amazon.awssdk.services.acmpca.model.ListPermissionsResponse;
import software.amazon.awssdk.services.acmpca.model.ListTagsRequest;
import software.amazon.awssdk.services.acmpca.model.ListTagsResponse;
import software.amazon.awssdk.services.acmpca.model.LockoutPreventedException;
import software.amazon.awssdk.services.acmpca.model.MalformedCertificateException;
import software.amazon.awssdk.services.acmpca.model.MalformedCsrException;
import software.amazon.awssdk.services.acmpca.model.PermissionAlreadyExistsException;
import software.amazon.awssdk.services.acmpca.model.PutPolicyRequest;
import software.amazon.awssdk.services.acmpca.model.PutPolicyResponse;
import software.amazon.awssdk.services.acmpca.model.RequestAlreadyProcessedException;
import software.amazon.awssdk.services.acmpca.model.RequestFailedException;
import software.amazon.awssdk.services.acmpca.model.RequestInProgressException;
import software.amazon.awssdk.services.acmpca.model.ResourceNotFoundException;
import software.amazon.awssdk.services.acmpca.model.RestoreCertificateAuthorityRequest;
import software.amazon.awssdk.services.acmpca.model.RestoreCertificateAuthorityResponse;
import software.amazon.awssdk.services.acmpca.model.RevokeCertificateRequest;
import software.amazon.awssdk.services.acmpca.model.RevokeCertificateResponse;
import software.amazon.awssdk.services.acmpca.model.TagCertificateAuthorityRequest;
import software.amazon.awssdk.services.acmpca.model.TagCertificateAuthorityResponse;
import software.amazon.awssdk.services.acmpca.model.TooManyTagsException;
import software.amazon.awssdk.services.acmpca.model.UntagCertificateAuthorityRequest;
import software.amazon.awssdk.services.acmpca.model.UntagCertificateAuthorityResponse;
import software.amazon.awssdk.services.acmpca.model.UpdateCertificateAuthorityRequest;
import software.amazon.awssdk.services.acmpca.model.UpdateCertificateAuthorityResponse;
import software.amazon.awssdk.services.acmpca.transform.CreateCertificateAuthorityAuditReportRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.CreateCertificateAuthorityRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.CreatePermissionRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.DeleteCertificateAuthorityRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.DeletePermissionRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.DeletePolicyRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.DescribeCertificateAuthorityAuditReportRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.DescribeCertificateAuthorityRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.GetCertificateAuthorityCertificateRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.GetCertificateAuthorityCsrRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.GetCertificateRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.GetPolicyRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.ImportCertificateAuthorityCertificateRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.IssueCertificateRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.ListCertificateAuthoritiesRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.ListPermissionsRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.ListTagsRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.PutPolicyRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.RestoreCertificateAuthorityRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.RevokeCertificateRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.TagCertificateAuthorityRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.UntagCertificateAuthorityRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.UpdateCertificateAuthorityRequestMarshaller;
import software.amazon.awssdk.services.acmpca.waiters.AcmPcaWaiter;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultAcmPcaClient
implements AcmPcaClient {
    private static final Logger log = Logger.loggerFor(DefaultAcmPcaClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultAcmPcaClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"ACM_PCA#2.35.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateCertificateAuthorityResponse createCertificateAuthority(CreateCertificateAuthorityRequest createCertificateAuthorityRequest) throws LimitExceededException, InvalidArgsException, InvalidTagException, InvalidPolicyException, AwsServiceException, SdkClientException, AcmPcaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateCertificateAuthorityResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MalformedCSRException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCSRException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCsrException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InvalidArgsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgsException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "RequestInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestInProgressException::builder).build());
                }
                case "LockoutPreventedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventedException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "PermissionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                }
                case "RequestAlreadyProcessedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestAlreadyProcessedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestAlreadyProcessedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                }
                case "CertificateMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateMismatchException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MalformedCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCertificateException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createCertificateAuthorityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaClient.resolveMetricPublishers(clientConfiguration, createCertificateAuthorityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCertificateAuthority");
            CreateCertificateAuthorityResponse createCertificateAuthorityResponse = (CreateCertificateAuthorityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCertificateAuthority").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createCertificateAuthorityRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateCertificateAuthorityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createCertificateAuthorityResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaClient.lambda$createCertificateAuthority$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateCertificateAuthorityAuditReportResponse createCertificateAuthorityAuditReport(CreateCertificateAuthorityAuditReportRequest createCertificateAuthorityAuditReportRequest) throws ResourceNotFoundException, InvalidArgsException, InvalidArnException, InvalidStateException, RequestFailedException, RequestInProgressException, AwsServiceException, SdkClientException, AcmPcaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateCertificateAuthorityAuditReportResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MalformedCSRException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCSRException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCsrException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InvalidArgsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgsException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "RequestInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestInProgressException::builder).build());
                }
                case "LockoutPreventedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventedException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "PermissionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                }
                case "RequestAlreadyProcessedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestAlreadyProcessedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestAlreadyProcessedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                }
                case "CertificateMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateMismatchException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MalformedCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCertificateException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createCertificateAuthorityAuditReportRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaClient.resolveMetricPublishers(clientConfiguration, createCertificateAuthorityAuditReportRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCertificateAuthorityAuditReport");
            CreateCertificateAuthorityAuditReportResponse createCertificateAuthorityAuditReportResponse = (CreateCertificateAuthorityAuditReportResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCertificateAuthorityAuditReport").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createCertificateAuthorityAuditReportRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateCertificateAuthorityAuditReportRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createCertificateAuthorityAuditReportResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaClient.lambda$createCertificateAuthorityAuditReport$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePermissionResponse createPermission(CreatePermissionRequest createPermissionRequest) throws LimitExceededException, PermissionAlreadyExistsException, ResourceNotFoundException, InvalidArnException, InvalidStateException, RequestFailedException, AwsServiceException, SdkClientException, AcmPcaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePermissionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MalformedCSRException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCSRException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCsrException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InvalidArgsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgsException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "RequestInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestInProgressException::builder).build());
                }
                case "LockoutPreventedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventedException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "PermissionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                }
                case "RequestAlreadyProcessedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestAlreadyProcessedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestAlreadyProcessedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                }
                case "CertificateMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateMismatchException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MalformedCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCertificateException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createPermissionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaClient.resolveMetricPublishers(clientConfiguration, createPermissionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreatePermission");
            CreatePermissionResponse createPermissionResponse = (CreatePermissionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePermission").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createPermissionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreatePermissionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createPermissionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaClient.lambda$createPermission$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteCertificateAuthorityResponse deleteCertificateAuthority(DeleteCertificateAuthorityRequest deleteCertificateAuthorityRequest) throws ResourceNotFoundException, InvalidArnException, InvalidStateException, ConcurrentModificationException, AwsServiceException, SdkClientException, AcmPcaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteCertificateAuthorityResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MalformedCSRException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCSRException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCsrException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InvalidArgsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgsException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "RequestInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestInProgressException::builder).build());
                }
                case "LockoutPreventedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventedException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "PermissionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                }
                case "RequestAlreadyProcessedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestAlreadyProcessedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestAlreadyProcessedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                }
                case "CertificateMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateMismatchException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MalformedCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCertificateException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteCertificateAuthorityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaClient.resolveMetricPublishers(clientConfiguration, deleteCertificateAuthorityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCertificateAuthority");
            DeleteCertificateAuthorityResponse deleteCertificateAuthorityResponse = (DeleteCertificateAuthorityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCertificateAuthority").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteCertificateAuthorityRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteCertificateAuthorityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteCertificateAuthorityResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaClient.lambda$deleteCertificateAuthority$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeletePermissionResponse deletePermission(DeletePermissionRequest deletePermissionRequest) throws ResourceNotFoundException, InvalidArnException, InvalidStateException, RequestFailedException, AwsServiceException, SdkClientException, AcmPcaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeletePermissionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MalformedCSRException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCSRException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCsrException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InvalidArgsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgsException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "RequestInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestInProgressException::builder).build());
                }
                case "LockoutPreventedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventedException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "PermissionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                }
                case "RequestAlreadyProcessedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestAlreadyProcessedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestAlreadyProcessedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                }
                case "CertificateMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateMismatchException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MalformedCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCertificateException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deletePermissionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaClient.resolveMetricPublishers(clientConfiguration, deletePermissionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeletePermission");
            DeletePermissionResponse deletePermissionResponse = (DeletePermissionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePermission").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deletePermissionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeletePermissionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deletePermissionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaClient.lambda$deletePermission$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeletePolicyResponse deletePolicy(DeletePolicyRequest deletePolicyRequest) throws LockoutPreventedException, ResourceNotFoundException, InvalidArnException, InvalidStateException, RequestFailedException, ConcurrentModificationException, AwsServiceException, SdkClientException, AcmPcaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeletePolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MalformedCSRException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCSRException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCsrException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InvalidArgsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgsException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "RequestInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestInProgressException::builder).build());
                }
                case "LockoutPreventedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventedException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "PermissionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                }
                case "RequestAlreadyProcessedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestAlreadyProcessedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestAlreadyProcessedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                }
                case "CertificateMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateMismatchException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MalformedCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCertificateException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deletePolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaClient.resolveMetricPublishers(clientConfiguration, deletePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeletePolicy");
            DeletePolicyResponse deletePolicyResponse = (DeletePolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deletePolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeletePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deletePolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaClient.lambda$deletePolicy$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeCertificateAuthorityResponse describeCertificateAuthority(DescribeCertificateAuthorityRequest describeCertificateAuthorityRequest) throws ResourceNotFoundException, InvalidArnException, AwsServiceException, SdkClientException, AcmPcaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeCertificateAuthorityResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MalformedCSRException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCSRException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCsrException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InvalidArgsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgsException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "RequestInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestInProgressException::builder).build());
                }
                case "LockoutPreventedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventedException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "PermissionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                }
                case "RequestAlreadyProcessedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestAlreadyProcessedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestAlreadyProcessedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                }
                case "CertificateMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateMismatchException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MalformedCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCertificateException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeCertificateAuthorityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaClient.resolveMetricPublishers(clientConfiguration, describeCertificateAuthorityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeCertificateAuthority");
            DescribeCertificateAuthorityResponse describeCertificateAuthorityResponse = (DescribeCertificateAuthorityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCertificateAuthority").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeCertificateAuthorityRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeCertificateAuthorityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeCertificateAuthorityResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaClient.lambda$describeCertificateAuthority$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeCertificateAuthorityAuditReportResponse describeCertificateAuthorityAuditReport(DescribeCertificateAuthorityAuditReportRequest describeCertificateAuthorityAuditReportRequest) throws ResourceNotFoundException, InvalidArgsException, InvalidArnException, AwsServiceException, SdkClientException, AcmPcaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeCertificateAuthorityAuditReportResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MalformedCSRException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCSRException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCsrException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InvalidArgsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgsException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "RequestInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestInProgressException::builder).build());
                }
                case "LockoutPreventedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventedException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "PermissionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                }
                case "RequestAlreadyProcessedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestAlreadyProcessedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestAlreadyProcessedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                }
                case "CertificateMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateMismatchException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MalformedCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCertificateException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeCertificateAuthorityAuditReportRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaClient.resolveMetricPublishers(clientConfiguration, describeCertificateAuthorityAuditReportRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeCertificateAuthorityAuditReport");
            DescribeCertificateAuthorityAuditReportResponse describeCertificateAuthorityAuditReportResponse = (DescribeCertificateAuthorityAuditReportResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCertificateAuthorityAuditReport").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeCertificateAuthorityAuditReportRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeCertificateAuthorityAuditReportRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeCertificateAuthorityAuditReportResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaClient.lambda$describeCertificateAuthorityAuditReport$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCertificateResponse getCertificate(GetCertificateRequest getCertificateRequest) throws ResourceNotFoundException, InvalidArnException, InvalidStateException, RequestFailedException, RequestInProgressException, AwsServiceException, SdkClientException, AcmPcaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCertificateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MalformedCSRException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCSRException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCsrException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InvalidArgsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgsException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "RequestInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestInProgressException::builder).build());
                }
                case "LockoutPreventedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventedException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "PermissionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                }
                case "RequestAlreadyProcessedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestAlreadyProcessedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestAlreadyProcessedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                }
                case "CertificateMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateMismatchException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MalformedCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCertificateException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getCertificateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaClient.resolveMetricPublishers(clientConfiguration, getCertificateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCertificate");
            GetCertificateResponse getCertificateResponse = (GetCertificateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCertificate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getCertificateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetCertificateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getCertificateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaClient.lambda$getCertificate$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCertificateAuthorityCertificateResponse getCertificateAuthorityCertificate(GetCertificateAuthorityCertificateRequest getCertificateAuthorityCertificateRequest) throws ResourceNotFoundException, InvalidArnException, InvalidStateException, AwsServiceException, SdkClientException, AcmPcaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCertificateAuthorityCertificateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MalformedCSRException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCSRException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCsrException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InvalidArgsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgsException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "RequestInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestInProgressException::builder).build());
                }
                case "LockoutPreventedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventedException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "PermissionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                }
                case "RequestAlreadyProcessedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestAlreadyProcessedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestAlreadyProcessedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                }
                case "CertificateMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateMismatchException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MalformedCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCertificateException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getCertificateAuthorityCertificateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaClient.resolveMetricPublishers(clientConfiguration, getCertificateAuthorityCertificateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCertificateAuthorityCertificate");
            GetCertificateAuthorityCertificateResponse getCertificateAuthorityCertificateResponse = (GetCertificateAuthorityCertificateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCertificateAuthorityCertificate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getCertificateAuthorityCertificateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetCertificateAuthorityCertificateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getCertificateAuthorityCertificateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaClient.lambda$getCertificateAuthorityCertificate$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCertificateAuthorityCsrResponse getCertificateAuthorityCsr(GetCertificateAuthorityCsrRequest getCertificateAuthorityCsrRequest) throws ResourceNotFoundException, InvalidArnException, InvalidStateException, RequestFailedException, RequestInProgressException, AwsServiceException, SdkClientException, AcmPcaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCertificateAuthorityCsrResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MalformedCSRException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCSRException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCsrException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InvalidArgsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgsException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "RequestInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestInProgressException::builder).build());
                }
                case "LockoutPreventedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventedException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "PermissionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                }
                case "RequestAlreadyProcessedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestAlreadyProcessedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestAlreadyProcessedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                }
                case "CertificateMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateMismatchException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MalformedCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCertificateException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getCertificateAuthorityCsrRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaClient.resolveMetricPublishers(clientConfiguration, getCertificateAuthorityCsrRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCertificateAuthorityCsr");
            GetCertificateAuthorityCsrResponse getCertificateAuthorityCsrResponse = (GetCertificateAuthorityCsrResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCertificateAuthorityCsr").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getCertificateAuthorityCsrRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetCertificateAuthorityCsrRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getCertificateAuthorityCsrResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaClient.lambda$getCertificateAuthorityCsr$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetPolicyResponse getPolicy(GetPolicyRequest getPolicyRequest) throws ResourceNotFoundException, InvalidArnException, InvalidStateException, RequestFailedException, AwsServiceException, SdkClientException, AcmPcaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MalformedCSRException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCSRException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCsrException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InvalidArgsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgsException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "RequestInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestInProgressException::builder).build());
                }
                case "LockoutPreventedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventedException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "PermissionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                }
                case "RequestAlreadyProcessedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestAlreadyProcessedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestAlreadyProcessedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                }
                case "CertificateMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateMismatchException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MalformedCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCertificateException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaClient.resolveMetricPublishers(clientConfiguration, getPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPolicy");
            GetPolicyResponse getPolicyResponse = (GetPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaClient.lambda$getPolicy$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImportCertificateAuthorityCertificateResponse importCertificateAuthorityCertificate(ImportCertificateAuthorityCertificateRequest importCertificateAuthorityCertificateRequest) throws CertificateMismatchException, MalformedCertificateException, ResourceNotFoundException, InvalidArnException, InvalidRequestException, InvalidStateException, RequestFailedException, ConcurrentModificationException, RequestInProgressException, AwsServiceException, SdkClientException, AcmPcaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ImportCertificateAuthorityCertificateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MalformedCSRException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCSRException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCsrException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InvalidArgsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgsException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "RequestInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestInProgressException::builder).build());
                }
                case "LockoutPreventedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventedException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "PermissionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                }
                case "RequestAlreadyProcessedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestAlreadyProcessedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestAlreadyProcessedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                }
                case "CertificateMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateMismatchException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MalformedCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCertificateException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)importCertificateAuthorityCertificateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaClient.resolveMetricPublishers(clientConfiguration, importCertificateAuthorityCertificateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ImportCertificateAuthorityCertificate");
            ImportCertificateAuthorityCertificateResponse importCertificateAuthorityCertificateResponse = (ImportCertificateAuthorityCertificateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ImportCertificateAuthorityCertificate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)importCertificateAuthorityCertificateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ImportCertificateAuthorityCertificateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return importCertificateAuthorityCertificateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaClient.lambda$importCertificateAuthorityCertificate$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IssueCertificateResponse issueCertificate(IssueCertificateRequest issueCertificateRequest) throws LimitExceededException, ResourceNotFoundException, InvalidArgsException, InvalidArnException, InvalidStateException, MalformedCsrException, AwsServiceException, SdkClientException, AcmPcaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, IssueCertificateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MalformedCSRException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCSRException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCsrException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InvalidArgsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgsException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "RequestInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestInProgressException::builder).build());
                }
                case "LockoutPreventedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventedException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "PermissionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                }
                case "RequestAlreadyProcessedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestAlreadyProcessedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestAlreadyProcessedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                }
                case "CertificateMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateMismatchException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MalformedCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCertificateException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)issueCertificateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaClient.resolveMetricPublishers(clientConfiguration, issueCertificateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"IssueCertificate");
            IssueCertificateResponse issueCertificateResponse = (IssueCertificateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("IssueCertificate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)issueCertificateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new IssueCertificateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return issueCertificateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaClient.lambda$issueCertificate$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListCertificateAuthoritiesResponse listCertificateAuthorities(ListCertificateAuthoritiesRequest listCertificateAuthoritiesRequest) throws InvalidNextTokenException, AwsServiceException, SdkClientException, AcmPcaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCertificateAuthoritiesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MalformedCSRException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCSRException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCsrException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InvalidArgsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgsException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "RequestInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestInProgressException::builder).build());
                }
                case "LockoutPreventedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventedException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "PermissionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                }
                case "RequestAlreadyProcessedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestAlreadyProcessedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestAlreadyProcessedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                }
                case "CertificateMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateMismatchException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MalformedCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCertificateException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listCertificateAuthoritiesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaClient.resolveMetricPublishers(clientConfiguration, listCertificateAuthoritiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCertificateAuthorities");
            ListCertificateAuthoritiesResponse listCertificateAuthoritiesResponse = (ListCertificateAuthoritiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCertificateAuthorities").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listCertificateAuthoritiesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListCertificateAuthoritiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listCertificateAuthoritiesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaClient.lambda$listCertificateAuthorities$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPermissionsResponse listPermissions(ListPermissionsRequest listPermissionsRequest) throws ResourceNotFoundException, InvalidArnException, InvalidStateException, RequestFailedException, InvalidNextTokenException, AwsServiceException, SdkClientException, AcmPcaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPermissionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MalformedCSRException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCSRException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCsrException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InvalidArgsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgsException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "RequestInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestInProgressException::builder).build());
                }
                case "LockoutPreventedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventedException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "PermissionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                }
                case "RequestAlreadyProcessedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestAlreadyProcessedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestAlreadyProcessedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                }
                case "CertificateMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateMismatchException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MalformedCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCertificateException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listPermissionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaClient.resolveMetricPublishers(clientConfiguration, listPermissionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPermissions");
            ListPermissionsResponse listPermissionsResponse = (ListPermissionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPermissions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listPermissionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListPermissionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listPermissionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaClient.lambda$listPermissions$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsResponse listTags(ListTagsRequest listTagsRequest) throws ResourceNotFoundException, InvalidArnException, InvalidStateException, RequestFailedException, AwsServiceException, SdkClientException, AcmPcaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MalformedCSRException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCSRException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCsrException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InvalidArgsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgsException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "RequestInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestInProgressException::builder).build());
                }
                case "LockoutPreventedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventedException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "PermissionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                }
                case "RequestAlreadyProcessedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestAlreadyProcessedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestAlreadyProcessedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                }
                case "CertificateMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateMismatchException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MalformedCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCertificateException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaClient.resolveMetricPublishers(clientConfiguration, listTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTags");
            ListTagsResponse listTagsResponse = (ListTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTags").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTagsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaClient.lambda$listTags$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutPolicyResponse putPolicy(PutPolicyRequest putPolicyRequest) throws LockoutPreventedException, ResourceNotFoundException, InvalidArnException, InvalidStateException, RequestFailedException, ConcurrentModificationException, InvalidPolicyException, AwsServiceException, SdkClientException, AcmPcaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutPolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MalformedCSRException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCSRException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCsrException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InvalidArgsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgsException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "RequestInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestInProgressException::builder).build());
                }
                case "LockoutPreventedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventedException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "PermissionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                }
                case "RequestAlreadyProcessedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestAlreadyProcessedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestAlreadyProcessedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                }
                case "CertificateMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateMismatchException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MalformedCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCertificateException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaClient.resolveMetricPublishers(clientConfiguration, putPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutPolicy");
            PutPolicyResponse putPolicyResponse = (PutPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaClient.lambda$putPolicy$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RestoreCertificateAuthorityResponse restoreCertificateAuthority(RestoreCertificateAuthorityRequest restoreCertificateAuthorityRequest) throws ResourceNotFoundException, InvalidArnException, InvalidStateException, AwsServiceException, SdkClientException, AcmPcaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RestoreCertificateAuthorityResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MalformedCSRException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCSRException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCsrException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InvalidArgsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgsException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "RequestInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestInProgressException::builder).build());
                }
                case "LockoutPreventedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventedException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "PermissionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                }
                case "RequestAlreadyProcessedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestAlreadyProcessedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestAlreadyProcessedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                }
                case "CertificateMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateMismatchException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MalformedCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCertificateException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)restoreCertificateAuthorityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaClient.resolveMetricPublishers(clientConfiguration, restoreCertificateAuthorityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RestoreCertificateAuthority");
            RestoreCertificateAuthorityResponse restoreCertificateAuthorityResponse = (RestoreCertificateAuthorityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RestoreCertificateAuthority").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)restoreCertificateAuthorityRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RestoreCertificateAuthorityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return restoreCertificateAuthorityResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaClient.lambda$restoreCertificateAuthority$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RevokeCertificateResponse revokeCertificate(RevokeCertificateRequest revokeCertificateRequest) throws RequestAlreadyProcessedException, LimitExceededException, ResourceNotFoundException, InvalidArnException, InvalidRequestException, InvalidStateException, RequestFailedException, ConcurrentModificationException, RequestInProgressException, AwsServiceException, SdkClientException, AcmPcaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RevokeCertificateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MalformedCSRException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCSRException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCsrException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InvalidArgsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgsException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "RequestInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestInProgressException::builder).build());
                }
                case "LockoutPreventedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventedException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "PermissionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                }
                case "RequestAlreadyProcessedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestAlreadyProcessedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestAlreadyProcessedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                }
                case "CertificateMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateMismatchException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MalformedCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCertificateException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)revokeCertificateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaClient.resolveMetricPublishers(clientConfiguration, revokeCertificateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RevokeCertificate");
            RevokeCertificateResponse revokeCertificateResponse = (RevokeCertificateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RevokeCertificate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)revokeCertificateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RevokeCertificateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return revokeCertificateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaClient.lambda$revokeCertificate$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagCertificateAuthorityResponse tagCertificateAuthority(TagCertificateAuthorityRequest tagCertificateAuthorityRequest) throws ResourceNotFoundException, InvalidArnException, InvalidStateException, InvalidTagException, TooManyTagsException, AwsServiceException, SdkClientException, AcmPcaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagCertificateAuthorityResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MalformedCSRException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCSRException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCsrException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InvalidArgsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgsException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "RequestInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestInProgressException::builder).build());
                }
                case "LockoutPreventedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventedException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "PermissionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                }
                case "RequestAlreadyProcessedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestAlreadyProcessedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestAlreadyProcessedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                }
                case "CertificateMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateMismatchException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MalformedCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCertificateException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagCertificateAuthorityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaClient.resolveMetricPublishers(clientConfiguration, tagCertificateAuthorityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagCertificateAuthority");
            TagCertificateAuthorityResponse tagCertificateAuthorityResponse = (TagCertificateAuthorityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagCertificateAuthority").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)tagCertificateAuthorityRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagCertificateAuthorityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagCertificateAuthorityResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaClient.lambda$tagCertificateAuthority$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagCertificateAuthorityResponse untagCertificateAuthority(UntagCertificateAuthorityRequest untagCertificateAuthorityRequest) throws ResourceNotFoundException, InvalidArnException, InvalidStateException, InvalidTagException, AwsServiceException, SdkClientException, AcmPcaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagCertificateAuthorityResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MalformedCSRException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCSRException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCsrException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InvalidArgsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgsException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "RequestInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestInProgressException::builder).build());
                }
                case "LockoutPreventedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventedException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "PermissionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                }
                case "RequestAlreadyProcessedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestAlreadyProcessedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestAlreadyProcessedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                }
                case "CertificateMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateMismatchException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MalformedCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCertificateException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagCertificateAuthorityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaClient.resolveMetricPublishers(clientConfiguration, untagCertificateAuthorityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagCertificateAuthority");
            UntagCertificateAuthorityResponse untagCertificateAuthorityResponse = (UntagCertificateAuthorityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagCertificateAuthority").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)untagCertificateAuthorityRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagCertificateAuthorityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagCertificateAuthorityResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaClient.lambda$untagCertificateAuthority$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateCertificateAuthorityResponse updateCertificateAuthority(UpdateCertificateAuthorityRequest updateCertificateAuthorityRequest) throws ResourceNotFoundException, InvalidArgsException, InvalidArnException, InvalidStateException, ConcurrentModificationException, InvalidPolicyException, AwsServiceException, SdkClientException, AcmPcaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateCertificateAuthorityResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "MalformedCSRException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCSRException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCsrException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InvalidArgsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgsException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "RequestInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestInProgressException::builder).build());
                }
                case "LockoutPreventedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventedException::builder).build());
                }
                case "InvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                }
                case "PermissionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                }
                case "RequestAlreadyProcessedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestAlreadyProcessedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestAlreadyProcessedException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "InvalidTagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                }
                case "CertificateMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateMismatchException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MalformedCertificateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCertificateException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateCertificateAuthorityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaClient.resolveMetricPublishers(clientConfiguration, updateCertificateAuthorityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateCertificateAuthority");
            UpdateCertificateAuthorityResponse updateCertificateAuthorityResponse = (UpdateCertificateAuthorityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateCertificateAuthority").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateCertificateAuthorityRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateCertificateAuthorityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateCertificateAuthorityResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaClient.lambda$updateCertificateAuthority$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public AcmPcaWaiter waiter() {
        return AcmPcaWaiter.builder().client(this).build();
    }

    public final String serviceName() {
        return "acm-pca";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        AcmPcaServiceClientConfigurationBuilder serviceConfigBuilder = new AcmPcaServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(AcmPcaException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1");
    }

    @Override
    public final AcmPcaServiceClientConfiguration serviceClientConfiguration() {
        return new AcmPcaServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateCertificateAuthority$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagCertificateAuthority$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagCertificateAuthority$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$revokeCertificate$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$restoreCertificateAuthority$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putPolicy$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTags$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPermissions$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listCertificateAuthorities$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$issueCertificate$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$importCertificateAuthorityCertificate$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPolicy$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCertificateAuthorityCsr$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCertificateAuthorityCertificate$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCertificate$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeCertificateAuthorityAuditReport$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeCertificateAuthority$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deletePolicy$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deletePermission$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteCertificateAuthority$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createPermission$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCertificateAuthorityAuditReport$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCertificateAuthority$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

