/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acmpca.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AccessMethodType {
    CA_REPOSITORY("CA_REPOSITORY"),
    RESOURCE_PKI_MANIFEST("RESOURCE_PKI_MANIFEST"),
    RESOURCE_PKI_NOTIFY("RESOURCE_PKI_NOTIFY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AccessMethodType> VALUE_MAP;
    private final String value;

    private AccessMethodType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AccessMethodType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AccessMethodType> knownValues() {
        EnumSet<AccessMethodType> knownValues = EnumSet.allOf(AccessMethodType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AccessMethodType.class, AccessMethodType::toString);
    }
}

