/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acmpca.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.acmpca.model.AcmPcaRequest;
import software.amazon.awssdk.services.acmpca.model.ApiPassthrough;
import software.amazon.awssdk.services.acmpca.model.SigningAlgorithm;
import software.amazon.awssdk.services.acmpca.model.Validity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IssueCertificateRequest
extends AcmPcaRequest
implements ToCopyableBuilder<Builder, IssueCertificateRequest> {
    private static final SdkField<ApiPassthrough> API_PASSTHROUGH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ApiPassthrough").getter(IssueCertificateRequest.getter(IssueCertificateRequest::apiPassthrough)).setter(IssueCertificateRequest.setter(Builder::apiPassthrough)).constructor(ApiPassthrough::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiPassthrough").build()}).build();
    private static final SdkField<String> CERTIFICATE_AUTHORITY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CertificateAuthorityArn").getter(IssueCertificateRequest.getter(IssueCertificateRequest::certificateAuthorityArn)).setter(IssueCertificateRequest.setter(Builder::certificateAuthorityArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateAuthorityArn").build()}).build();
    private static final SdkField<SdkBytes> CSR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("Csr").getter(IssueCertificateRequest.getter(IssueCertificateRequest::csr)).setter(IssueCertificateRequest.setter(Builder::csr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Csr").build()}).build();
    private static final SdkField<String> SIGNING_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SigningAlgorithm").getter(IssueCertificateRequest.getter(IssueCertificateRequest::signingAlgorithmAsString)).setter(IssueCertificateRequest.setter(Builder::signingAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SigningAlgorithm").build()}).build();
    private static final SdkField<String> TEMPLATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateArn").getter(IssueCertificateRequest.getter(IssueCertificateRequest::templateArn)).setter(IssueCertificateRequest.setter(Builder::templateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateArn").build()}).build();
    private static final SdkField<Validity> VALIDITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Validity").getter(IssueCertificateRequest.getter(IssueCertificateRequest::validity)).setter(IssueCertificateRequest.setter(Builder::validity)).constructor(Validity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Validity").build()}).build();
    private static final SdkField<Validity> VALIDITY_NOT_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ValidityNotBefore").getter(IssueCertificateRequest.getter(IssueCertificateRequest::validityNotBefore)).setter(IssueCertificateRequest.setter(Builder::validityNotBefore)).constructor(Validity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidityNotBefore").build()}).build();
    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdempotencyToken").getter(IssueCertificateRequest.getter(IssueCertificateRequest::idempotencyToken)).setter(IssueCertificateRequest.setter(Builder::idempotencyToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdempotencyToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_PASSTHROUGH_FIELD, CERTIFICATE_AUTHORITY_ARN_FIELD, CSR_FIELD, SIGNING_ALGORITHM_FIELD, TEMPLATE_ARN_FIELD, VALIDITY_FIELD, VALIDITY_NOT_BEFORE_FIELD, IDEMPOTENCY_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ApiPassthrough", API_PASSTHROUGH_FIELD);
            this.put("CertificateAuthorityArn", CERTIFICATE_AUTHORITY_ARN_FIELD);
            this.put("Csr", CSR_FIELD);
            this.put("SigningAlgorithm", SIGNING_ALGORITHM_FIELD);
            this.put("TemplateArn", TEMPLATE_ARN_FIELD);
            this.put("Validity", VALIDITY_FIELD);
            this.put("ValidityNotBefore", VALIDITY_NOT_BEFORE_FIELD);
            this.put("IdempotencyToken", IDEMPOTENCY_TOKEN_FIELD);
        }
    });
    private final ApiPassthrough apiPassthrough;
    private final String certificateAuthorityArn;
    private final SdkBytes csr;
    private final String signingAlgorithm;
    private final String templateArn;
    private final Validity validity;
    private final Validity validityNotBefore;
    private final String idempotencyToken;

    private IssueCertificateRequest(BuilderImpl builder) {
        super(builder);
        this.apiPassthrough = builder.apiPassthrough;
        this.certificateAuthorityArn = builder.certificateAuthorityArn;
        this.csr = builder.csr;
        this.signingAlgorithm = builder.signingAlgorithm;
        this.templateArn = builder.templateArn;
        this.validity = builder.validity;
        this.validityNotBefore = builder.validityNotBefore;
        this.idempotencyToken = builder.idempotencyToken;
    }

    public final ApiPassthrough apiPassthrough() {
        return this.apiPassthrough;
    }

    public final String certificateAuthorityArn() {
        return this.certificateAuthorityArn;
    }

    public final SdkBytes csr() {
        return this.csr;
    }

    public final SigningAlgorithm signingAlgorithm() {
        return SigningAlgorithm.fromValue(this.signingAlgorithm);
    }

    public final String signingAlgorithmAsString() {
        return this.signingAlgorithm;
    }

    public final String templateArn() {
        return this.templateArn;
    }

    public final Validity validity() {
        return this.validity;
    }

    public final Validity validityNotBefore() {
        return this.validityNotBefore;
    }

    public final String idempotencyToken() {
        return this.idempotencyToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.apiPassthrough());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateAuthorityArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.csr());
        hashCode = 31 * hashCode + Objects.hashCode(this.signingAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.validity());
        hashCode = 31 * hashCode + Objects.hashCode(this.validityNotBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.idempotencyToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IssueCertificateRequest)) {
            return false;
        }
        IssueCertificateRequest other = (IssueCertificateRequest)((Object)obj);
        return Objects.equals(this.apiPassthrough(), other.apiPassthrough()) && Objects.equals(this.certificateAuthorityArn(), other.certificateAuthorityArn()) && Objects.equals(this.csr(), other.csr()) && Objects.equals(this.signingAlgorithmAsString(), other.signingAlgorithmAsString()) && Objects.equals(this.templateArn(), other.templateArn()) && Objects.equals(this.validity(), other.validity()) && Objects.equals(this.validityNotBefore(), other.validityNotBefore()) && Objects.equals(this.idempotencyToken(), other.idempotencyToken());
    }

    public final String toString() {
        return ToString.builder((String)"IssueCertificateRequest").add("ApiPassthrough", (Object)this.apiPassthrough()).add("CertificateAuthorityArn", (Object)this.certificateAuthorityArn()).add("Csr", (Object)this.csr()).add("SigningAlgorithm", (Object)this.signingAlgorithmAsString()).add("TemplateArn", (Object)this.templateArn()).add("Validity", (Object)this.validity()).add("ValidityNotBefore", (Object)this.validityNotBefore()).add("IdempotencyToken", (Object)this.idempotencyToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApiPassthrough": {
                return Optional.ofNullable(clazz.cast(this.apiPassthrough()));
            }
            case "CertificateAuthorityArn": {
                return Optional.ofNullable(clazz.cast(this.certificateAuthorityArn()));
            }
            case "Csr": {
                return Optional.ofNullable(clazz.cast(this.csr()));
            }
            case "SigningAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.signingAlgorithmAsString()));
            }
            case "TemplateArn": {
                return Optional.ofNullable(clazz.cast(this.templateArn()));
            }
            case "Validity": {
                return Optional.ofNullable(clazz.cast(this.validity()));
            }
            case "ValidityNotBefore": {
                return Optional.ofNullable(clazz.cast(this.validityNotBefore()));
            }
            case "IdempotencyToken": {
                return Optional.ofNullable(clazz.cast(this.idempotencyToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<IssueCertificateRequest, T> g) {
        return obj -> g.apply((IssueCertificateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AcmPcaRequest.BuilderImpl
    implements Builder {
        private ApiPassthrough apiPassthrough;
        private String certificateAuthorityArn;
        private SdkBytes csr;
        private String signingAlgorithm;
        private String templateArn;
        private Validity validity;
        private Validity validityNotBefore;
        private String idempotencyToken;

        private BuilderImpl() {
        }

        private BuilderImpl(IssueCertificateRequest model) {
            super(model);
            this.apiPassthrough(model.apiPassthrough);
            this.certificateAuthorityArn(model.certificateAuthorityArn);
            this.csr(model.csr);
            this.signingAlgorithm(model.signingAlgorithm);
            this.templateArn(model.templateArn);
            this.validity(model.validity);
            this.validityNotBefore(model.validityNotBefore);
            this.idempotencyToken(model.idempotencyToken);
        }

        public final ApiPassthrough.Builder getApiPassthrough() {
            return this.apiPassthrough != null ? this.apiPassthrough.toBuilder() : null;
        }

        public final void setApiPassthrough(ApiPassthrough.BuilderImpl apiPassthrough) {
            this.apiPassthrough = apiPassthrough != null ? apiPassthrough.build() : null;
        }

        @Override
        public final Builder apiPassthrough(ApiPassthrough apiPassthrough) {
            this.apiPassthrough = apiPassthrough;
            return this;
        }

        public final String getCertificateAuthorityArn() {
            return this.certificateAuthorityArn;
        }

        public final void setCertificateAuthorityArn(String certificateAuthorityArn) {
            this.certificateAuthorityArn = certificateAuthorityArn;
        }

        @Override
        public final Builder certificateAuthorityArn(String certificateAuthorityArn) {
            this.certificateAuthorityArn = certificateAuthorityArn;
            return this;
        }

        public final ByteBuffer getCsr() {
            return this.csr == null ? null : this.csr.asByteBuffer();
        }

        public final void setCsr(ByteBuffer csr) {
            this.csr(csr == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)csr));
        }

        @Override
        public final Builder csr(SdkBytes csr) {
            this.csr = csr;
            return this;
        }

        public final String getSigningAlgorithm() {
            return this.signingAlgorithm;
        }

        public final void setSigningAlgorithm(String signingAlgorithm) {
            this.signingAlgorithm = signingAlgorithm;
        }

        @Override
        public final Builder signingAlgorithm(String signingAlgorithm) {
            this.signingAlgorithm = signingAlgorithm;
            return this;
        }

        @Override
        public final Builder signingAlgorithm(SigningAlgorithm signingAlgorithm) {
            this.signingAlgorithm(signingAlgorithm == null ? null : signingAlgorithm.toString());
            return this;
        }

        public final String getTemplateArn() {
            return this.templateArn;
        }

        public final void setTemplateArn(String templateArn) {
            this.templateArn = templateArn;
        }

        @Override
        public final Builder templateArn(String templateArn) {
            this.templateArn = templateArn;
            return this;
        }

        public final Validity.Builder getValidity() {
            return this.validity != null ? this.validity.toBuilder() : null;
        }

        public final void setValidity(Validity.BuilderImpl validity) {
            this.validity = validity != null ? validity.build() : null;
        }

        @Override
        public final Builder validity(Validity validity) {
            this.validity = validity;
            return this;
        }

        public final Validity.Builder getValidityNotBefore() {
            return this.validityNotBefore != null ? this.validityNotBefore.toBuilder() : null;
        }

        public final void setValidityNotBefore(Validity.BuilderImpl validityNotBefore) {
            this.validityNotBefore = validityNotBefore != null ? validityNotBefore.build() : null;
        }

        @Override
        public final Builder validityNotBefore(Validity validityNotBefore) {
            this.validityNotBefore = validityNotBefore;
            return this;
        }

        public final String getIdempotencyToken() {
            return this.idempotencyToken;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public IssueCertificateRequest build() {
            return new IssueCertificateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AcmPcaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, IssueCertificateRequest> {
        public Builder apiPassthrough(ApiPassthrough var1);

        default public Builder apiPassthrough(Consumer<ApiPassthrough.Builder> apiPassthrough) {
            return this.apiPassthrough((ApiPassthrough)((ApiPassthrough.Builder)ApiPassthrough.builder().applyMutation(apiPassthrough)).build());
        }

        public Builder certificateAuthorityArn(String var1);

        public Builder csr(SdkBytes var1);

        public Builder signingAlgorithm(String var1);

        public Builder signingAlgorithm(SigningAlgorithm var1);

        public Builder templateArn(String var1);

        public Builder validity(Validity var1);

        default public Builder validity(Consumer<Validity.Builder> validity) {
            return this.validity((Validity)((Validity.Builder)Validity.builder().applyMutation(validity)).build());
        }

        public Builder validityNotBefore(Validity var1);

        default public Builder validityNotBefore(Consumer<Validity.Builder> validityNotBefore) {
            return this.validityNotBefore((Validity)((Validity.Builder)Validity.builder().applyMutation(validityNotBefore)).build());
        }

        public Builder idempotencyToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

