/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acmpca.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomExtension
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomExtension> {
    private static final SdkField<String> OBJECT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ObjectIdentifier").getter(CustomExtension.getter(CustomExtension::objectIdentifier)).setter(CustomExtension.setter(Builder::objectIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectIdentifier").build()}).build();
    private static final SdkField<String> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Value").getter(CustomExtension.getter(CustomExtension::value)).setter(CustomExtension.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final SdkField<Boolean> CRITICAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Critical").getter(CustomExtension.getter(CustomExtension::critical)).setter(CustomExtension.setter(Builder::critical)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Critical").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBJECT_IDENTIFIER_FIELD, VALUE_FIELD, CRITICAL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String objectIdentifier;
    private final String value;
    private final Boolean critical;

    private CustomExtension(BuilderImpl builder) {
        this.objectIdentifier = builder.objectIdentifier;
        this.value = builder.value;
        this.critical = builder.critical;
    }

    public final String objectIdentifier() {
        return this.objectIdentifier;
    }

    public final String value() {
        return this.value;
    }

    public final Boolean critical() {
        return this.critical;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.objectIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.critical());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomExtension)) {
            return false;
        }
        CustomExtension other = (CustomExtension)obj;
        return Objects.equals(this.objectIdentifier(), other.objectIdentifier()) && Objects.equals(this.value(), other.value()) && Objects.equals(this.critical(), other.critical());
    }

    public final String toString() {
        return ToString.builder((String)"CustomExtension").add("ObjectIdentifier", (Object)this.objectIdentifier()).add("Value", (Object)this.value()).add("Critical", (Object)this.critical()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ObjectIdentifier": {
                return Optional.ofNullable(clazz.cast(this.objectIdentifier()));
            }
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "Critical": {
                return Optional.ofNullable(clazz.cast(this.critical()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomExtension, T> g) {
        return obj -> g.apply((CustomExtension)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String objectIdentifier;
        private String value;
        private Boolean critical;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomExtension model) {
            this.objectIdentifier(model.objectIdentifier);
            this.value(model.value);
            this.critical(model.critical);
        }

        public final String getObjectIdentifier() {
            return this.objectIdentifier;
        }

        public final void setObjectIdentifier(String objectIdentifier) {
            this.objectIdentifier = objectIdentifier;
        }

        @Override
        public final Builder objectIdentifier(String objectIdentifier) {
            this.objectIdentifier = objectIdentifier;
            return this;
        }

        public final String getValue() {
            return this.value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final Boolean getCritical() {
            return this.critical;
        }

        public final void setCritical(Boolean critical) {
            this.critical = critical;
        }

        @Override
        public final Builder critical(Boolean critical) {
            this.critical = critical;
            return this;
        }

        public CustomExtension build() {
            return new CustomExtension(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomExtension> {
        public Builder objectIdentifier(String var1);

        public Builder value(String var1);

        public Builder critical(Boolean var1);
    }
}

