/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acmpca.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum S3ObjectAcl {
    PUBLIC_READ("PUBLIC_READ"),
    BUCKET_OWNER_FULL_CONTROL("BUCKET_OWNER_FULL_CONTROL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, S3ObjectAcl> VALUE_MAP;
    private final String value;

    private S3ObjectAcl(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static S3ObjectAcl fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<S3ObjectAcl> knownValues() {
        EnumSet<S3ObjectAcl> knownValues = EnumSet.allOf(S3ObjectAcl.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(S3ObjectAcl.class, S3ObjectAcl::toString);
    }
}

