/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.acmpca.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines one or more purposes for which the key contained in the certificate can be used. Default value for each
 * option is false.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KeyUsage implements SdkPojo, Serializable, ToCopyableBuilder<KeyUsage.Builder, KeyUsage> {
    private static final SdkField<Boolean> DIGITAL_SIGNATURE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DigitalSignature").getter(getter(KeyUsage::digitalSignature)).setter(setter(Builder::digitalSignature))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DigitalSignature").build()).build();

    private static final SdkField<Boolean> NON_REPUDIATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("NonRepudiation").getter(getter(KeyUsage::nonRepudiation)).setter(setter(Builder::nonRepudiation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NonRepudiation").build()).build();

    private static final SdkField<Boolean> KEY_ENCIPHERMENT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("KeyEncipherment").getter(getter(KeyUsage::keyEncipherment)).setter(setter(Builder::keyEncipherment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyEncipherment").build()).build();

    private static final SdkField<Boolean> DATA_ENCIPHERMENT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DataEncipherment").getter(getter(KeyUsage::dataEncipherment)).setter(setter(Builder::dataEncipherment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataEncipherment").build()).build();

    private static final SdkField<Boolean> KEY_AGREEMENT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("KeyAgreement").getter(getter(KeyUsage::keyAgreement)).setter(setter(Builder::keyAgreement))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyAgreement").build()).build();

    private static final SdkField<Boolean> KEY_CERT_SIGN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("KeyCertSign").getter(getter(KeyUsage::keyCertSign)).setter(setter(Builder::keyCertSign))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyCertSign").build()).build();

    private static final SdkField<Boolean> CRL_SIGN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CRLSign").getter(getter(KeyUsage::crlSign)).setter(setter(Builder::crlSign))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CRLSign").build()).build();

    private static final SdkField<Boolean> ENCIPHER_ONLY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EncipherOnly").getter(getter(KeyUsage::encipherOnly)).setter(setter(Builder::encipherOnly))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncipherOnly").build()).build();

    private static final SdkField<Boolean> DECIPHER_ONLY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DecipherOnly").getter(getter(KeyUsage::decipherOnly)).setter(setter(Builder::decipherOnly))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DecipherOnly").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIGITAL_SIGNATURE_FIELD,
            NON_REPUDIATION_FIELD, KEY_ENCIPHERMENT_FIELD, DATA_ENCIPHERMENT_FIELD, KEY_AGREEMENT_FIELD, KEY_CERT_SIGN_FIELD,
            CRL_SIGN_FIELD, ENCIPHER_ONLY_FIELD, DECIPHER_ONLY_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean digitalSignature;

    private final Boolean nonRepudiation;

    private final Boolean keyEncipherment;

    private final Boolean dataEncipherment;

    private final Boolean keyAgreement;

    private final Boolean keyCertSign;

    private final Boolean crlSign;

    private final Boolean encipherOnly;

    private final Boolean decipherOnly;

    private KeyUsage(BuilderImpl builder) {
        this.digitalSignature = builder.digitalSignature;
        this.nonRepudiation = builder.nonRepudiation;
        this.keyEncipherment = builder.keyEncipherment;
        this.dataEncipherment = builder.dataEncipherment;
        this.keyAgreement = builder.keyAgreement;
        this.keyCertSign = builder.keyCertSign;
        this.crlSign = builder.crlSign;
        this.encipherOnly = builder.encipherOnly;
        this.decipherOnly = builder.decipherOnly;
    }

    /**
     * <p>
     * Key can be used for digital signing.
     * </p>
     * 
     * @return Key can be used for digital signing.
     */
    public final Boolean digitalSignature() {
        return digitalSignature;
    }

    /**
     * <p>
     * Key can be used for non-repudiation.
     * </p>
     * 
     * @return Key can be used for non-repudiation.
     */
    public final Boolean nonRepudiation() {
        return nonRepudiation;
    }

    /**
     * <p>
     * Key can be used to encipher data.
     * </p>
     * 
     * @return Key can be used to encipher data.
     */
    public final Boolean keyEncipherment() {
        return keyEncipherment;
    }

    /**
     * <p>
     * Key can be used to decipher data.
     * </p>
     * 
     * @return Key can be used to decipher data.
     */
    public final Boolean dataEncipherment() {
        return dataEncipherment;
    }

    /**
     * <p>
     * Key can be used in a key-agreement protocol.
     * </p>
     * 
     * @return Key can be used in a key-agreement protocol.
     */
    public final Boolean keyAgreement() {
        return keyAgreement;
    }

    /**
     * <p>
     * Key can be used to sign certificates.
     * </p>
     * 
     * @return Key can be used to sign certificates.
     */
    public final Boolean keyCertSign() {
        return keyCertSign;
    }

    /**
     * <p>
     * Key can be used to sign CRLs.
     * </p>
     * 
     * @return Key can be used to sign CRLs.
     */
    public final Boolean crlSign() {
        return crlSign;
    }

    /**
     * <p>
     * Key can be used only to encipher data.
     * </p>
     * 
     * @return Key can be used only to encipher data.
     */
    public final Boolean encipherOnly() {
        return encipherOnly;
    }

    /**
     * <p>
     * Key can be used only to decipher data.
     * </p>
     * 
     * @return Key can be used only to decipher data.
     */
    public final Boolean decipherOnly() {
        return decipherOnly;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(digitalSignature());
        hashCode = 31 * hashCode + Objects.hashCode(nonRepudiation());
        hashCode = 31 * hashCode + Objects.hashCode(keyEncipherment());
        hashCode = 31 * hashCode + Objects.hashCode(dataEncipherment());
        hashCode = 31 * hashCode + Objects.hashCode(keyAgreement());
        hashCode = 31 * hashCode + Objects.hashCode(keyCertSign());
        hashCode = 31 * hashCode + Objects.hashCode(crlSign());
        hashCode = 31 * hashCode + Objects.hashCode(encipherOnly());
        hashCode = 31 * hashCode + Objects.hashCode(decipherOnly());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyUsage)) {
            return false;
        }
        KeyUsage other = (KeyUsage) obj;
        return Objects.equals(digitalSignature(), other.digitalSignature())
                && Objects.equals(nonRepudiation(), other.nonRepudiation())
                && Objects.equals(keyEncipherment(), other.keyEncipherment())
                && Objects.equals(dataEncipherment(), other.dataEncipherment())
                && Objects.equals(keyAgreement(), other.keyAgreement()) && Objects.equals(keyCertSign(), other.keyCertSign())
                && Objects.equals(crlSign(), other.crlSign()) && Objects.equals(encipherOnly(), other.encipherOnly())
                && Objects.equals(decipherOnly(), other.decipherOnly());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KeyUsage").add("DigitalSignature", digitalSignature()).add("NonRepudiation", nonRepudiation())
                .add("KeyEncipherment", keyEncipherment()).add("DataEncipherment", dataEncipherment())
                .add("KeyAgreement", keyAgreement()).add("KeyCertSign", keyCertSign()).add("CRLSign", crlSign())
                .add("EncipherOnly", encipherOnly()).add("DecipherOnly", decipherOnly()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DigitalSignature":
            return Optional.ofNullable(clazz.cast(digitalSignature()));
        case "NonRepudiation":
            return Optional.ofNullable(clazz.cast(nonRepudiation()));
        case "KeyEncipherment":
            return Optional.ofNullable(clazz.cast(keyEncipherment()));
        case "DataEncipherment":
            return Optional.ofNullable(clazz.cast(dataEncipherment()));
        case "KeyAgreement":
            return Optional.ofNullable(clazz.cast(keyAgreement()));
        case "KeyCertSign":
            return Optional.ofNullable(clazz.cast(keyCertSign()));
        case "CRLSign":
            return Optional.ofNullable(clazz.cast(crlSign()));
        case "EncipherOnly":
            return Optional.ofNullable(clazz.cast(encipherOnly()));
        case "DecipherOnly":
            return Optional.ofNullable(clazz.cast(decipherOnly()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KeyUsage, T> g) {
        return obj -> g.apply((KeyUsage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KeyUsage> {
        /**
         * <p>
         * Key can be used for digital signing.
         * </p>
         * 
         * @param digitalSignature
         *        Key can be used for digital signing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder digitalSignature(Boolean digitalSignature);

        /**
         * <p>
         * Key can be used for non-repudiation.
         * </p>
         * 
         * @param nonRepudiation
         *        Key can be used for non-repudiation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nonRepudiation(Boolean nonRepudiation);

        /**
         * <p>
         * Key can be used to encipher data.
         * </p>
         * 
         * @param keyEncipherment
         *        Key can be used to encipher data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyEncipherment(Boolean keyEncipherment);

        /**
         * <p>
         * Key can be used to decipher data.
         * </p>
         * 
         * @param dataEncipherment
         *        Key can be used to decipher data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataEncipherment(Boolean dataEncipherment);

        /**
         * <p>
         * Key can be used in a key-agreement protocol.
         * </p>
         * 
         * @param keyAgreement
         *        Key can be used in a key-agreement protocol.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyAgreement(Boolean keyAgreement);

        /**
         * <p>
         * Key can be used to sign certificates.
         * </p>
         * 
         * @param keyCertSign
         *        Key can be used to sign certificates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyCertSign(Boolean keyCertSign);

        /**
         * <p>
         * Key can be used to sign CRLs.
         * </p>
         * 
         * @param crlSign
         *        Key can be used to sign CRLs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crlSign(Boolean crlSign);

        /**
         * <p>
         * Key can be used only to encipher data.
         * </p>
         * 
         * @param encipherOnly
         *        Key can be used only to encipher data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encipherOnly(Boolean encipherOnly);

        /**
         * <p>
         * Key can be used only to decipher data.
         * </p>
         * 
         * @param decipherOnly
         *        Key can be used only to decipher data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decipherOnly(Boolean decipherOnly);
    }

    static final class BuilderImpl implements Builder {
        private Boolean digitalSignature;

        private Boolean nonRepudiation;

        private Boolean keyEncipherment;

        private Boolean dataEncipherment;

        private Boolean keyAgreement;

        private Boolean keyCertSign;

        private Boolean crlSign;

        private Boolean encipherOnly;

        private Boolean decipherOnly;

        private BuilderImpl() {
        }

        private BuilderImpl(KeyUsage model) {
            digitalSignature(model.digitalSignature);
            nonRepudiation(model.nonRepudiation);
            keyEncipherment(model.keyEncipherment);
            dataEncipherment(model.dataEncipherment);
            keyAgreement(model.keyAgreement);
            keyCertSign(model.keyCertSign);
            crlSign(model.crlSign);
            encipherOnly(model.encipherOnly);
            decipherOnly(model.decipherOnly);
        }

        public final Boolean getDigitalSignature() {
            return digitalSignature;
        }

        @Override
        public final Builder digitalSignature(Boolean digitalSignature) {
            this.digitalSignature = digitalSignature;
            return this;
        }

        public final void setDigitalSignature(Boolean digitalSignature) {
            this.digitalSignature = digitalSignature;
        }

        public final Boolean getNonRepudiation() {
            return nonRepudiation;
        }

        @Override
        public final Builder nonRepudiation(Boolean nonRepudiation) {
            this.nonRepudiation = nonRepudiation;
            return this;
        }

        public final void setNonRepudiation(Boolean nonRepudiation) {
            this.nonRepudiation = nonRepudiation;
        }

        public final Boolean getKeyEncipherment() {
            return keyEncipherment;
        }

        @Override
        public final Builder keyEncipherment(Boolean keyEncipherment) {
            this.keyEncipherment = keyEncipherment;
            return this;
        }

        public final void setKeyEncipherment(Boolean keyEncipherment) {
            this.keyEncipherment = keyEncipherment;
        }

        public final Boolean getDataEncipherment() {
            return dataEncipherment;
        }

        @Override
        public final Builder dataEncipherment(Boolean dataEncipherment) {
            this.dataEncipherment = dataEncipherment;
            return this;
        }

        public final void setDataEncipherment(Boolean dataEncipherment) {
            this.dataEncipherment = dataEncipherment;
        }

        public final Boolean getKeyAgreement() {
            return keyAgreement;
        }

        @Override
        public final Builder keyAgreement(Boolean keyAgreement) {
            this.keyAgreement = keyAgreement;
            return this;
        }

        public final void setKeyAgreement(Boolean keyAgreement) {
            this.keyAgreement = keyAgreement;
        }

        public final Boolean getKeyCertSign() {
            return keyCertSign;
        }

        @Override
        public final Builder keyCertSign(Boolean keyCertSign) {
            this.keyCertSign = keyCertSign;
            return this;
        }

        public final void setKeyCertSign(Boolean keyCertSign) {
            this.keyCertSign = keyCertSign;
        }

        public final Boolean getCrlSign() {
            return crlSign;
        }

        @Override
        public final Builder crlSign(Boolean crlSign) {
            this.crlSign = crlSign;
            return this;
        }

        public final void setCrlSign(Boolean crlSign) {
            this.crlSign = crlSign;
        }

        public final Boolean getEncipherOnly() {
            return encipherOnly;
        }

        @Override
        public final Builder encipherOnly(Boolean encipherOnly) {
            this.encipherOnly = encipherOnly;
            return this;
        }

        public final void setEncipherOnly(Boolean encipherOnly) {
            this.encipherOnly = encipherOnly;
        }

        public final Boolean getDecipherOnly() {
            return decipherOnly;
        }

        @Override
        public final Builder decipherOnly(Boolean decipherOnly) {
            this.decipherOnly = decipherOnly;
            return this;
        }

        public final void setDecipherOnly(Boolean decipherOnly) {
            this.decipherOnly = decipherOnly;
        }

        @Override
        public KeyUsage build() {
            return new KeyUsage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
